/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.sfm;

import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.abst.feature.tracker.PointTrackerTwoPass;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.DepthVisualOdometry;
import boofcv.abst.sfm.d3.VisualOdometry;
import boofcv.alg.distort.DoNothingPixelTransform_F32;
import boofcv.alg.sfm.DepthSparse3D;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.factory.feature.tracker.FactoryPointTrackerTwoPass;
import boofcv.factory.sfm.FactoryVisualOdometry;
import boofcv.io.UtilIO;
import boofcv.io.image.SimpleImageSequence;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.struct.calib.VisualDepthParameters;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU16;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageType;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import java.io.IOException;

public class ExampleVisualOdometryDepth {
    public static void main(String[] args) throws IOException {
        DefaultMediaManager media = DefaultMediaManager.INSTANCE;
        String directory = UtilIO.pathExample("kinect/straight");
        VisualDepthParameters param = (VisualDepthParameters)UtilIO.loadXML(media.openFile(directory + "visualdepth.xml"));
        PkltConfig configKlt = new PkltConfig();
        configKlt.pyramidScaling = new int[]{1, 2, 4, 8};
        configKlt.templateRadius = 3;
        PointTrackerTwoPass<GrayU8> tracker = FactoryPointTrackerTwoPass.klt(configKlt, new ConfigGeneralDetector(600, 3, 1.0f), GrayU8.class, GrayS16.class);
        DepthSparse3D.I sparseDepth = new DepthSparse3D.I(0.001);
        DepthVisualOdometry<GrayU8, GrayU16> visualOdometry = FactoryVisualOdometry.depthDepthPnP(1.5, 120, 2, 200, 50, true, sparseDepth, tracker, GrayU8.class, GrayU16.class);
        visualOdometry.setCalibration(param.visualParam, new DoNothingPixelTransform_F32());
        SimpleImageSequence<GrayU8> videoVisual = media.openVideo(directory + "rgb.mjpeg", ImageType.single(GrayU8.class));
        SimpleImageSequence<GrayU16> videoDepth = media.openVideo(directory + "depth.mpng", ImageType.single(GrayU16.class));
        while (videoVisual.hasNext()) {
            GrayU16 depth;
            GrayU8 visual = videoVisual.next();
            if (!visualOdometry.process(visual, depth = videoDepth.next())) {
                throw new RuntimeException("VO Failed!");
            }
            Se3_F64 leftToWorld = (Se3_F64)visualOdometry.getCameraToWorld();
            Vector3D_F64 T = leftToWorld.getT();
            System.out.printf("Location %8.2f %8.2f %8.2f      inliers %s\n", T.x, T.y, T.z, ExampleVisualOdometryDepth.inlierPercent(visualOdometry));
        }
    }

    public static String inlierPercent(VisualOdometry alg) {
        if (!(alg instanceof AccessPointTracks3D)) {
            return "";
        }
        AccessPointTracks3D access = (AccessPointTracks3D)((Object)alg);
        int count = 0;
        int N = access.getAllTracks().size();
        for (int i = 0; i < N; ++i) {
            if (!access.isInlier(i)) continue;
            ++count;
        }
        return String.format("%%%5.3f", 100.0 * (double)count / (double)N);
    }
}

