/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.sfm;

import boofcv.abst.geo.Estimate1ofPnP;
import boofcv.abst.geo.RefinePnP;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.factory.geo.ConfigPnP;
import boofcv.factory.geo.ConfigRansac;
import boofcv.factory.geo.EnumPNP;
import boofcv.factory.geo.FactoryMultiView;
import boofcv.factory.geo.FactoryMultiViewRobust;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.geo.Point2D3D;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.struct.EulerType;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.ejml.data.DenseMatrix64F;

public class ExamplePnP {
    IntrinsicParameters intrinsic = new IntrinsicParameters(500.0, 490.0, 0.0, 320.0, 240.0, 640, 480).fsetRadial(0.1, -0.05);
    Random rand = new Random(234L);

    public static void main(String[] args) {
        Se3_F64 worldToCamera = new Se3_F64();
        worldToCamera.getT().set(5.0, 10.0, -7.0);
        ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)0.1, (double)-0.3, (double)0.0, (DenseMatrix64F)worldToCamera.getR());
        ExamplePnP app = new ExamplePnP();
        List<Point2D3D> observations = app.createObservations(worldToCamera, 100);
        System.out.println("Truth:");
        worldToCamera.print();
        System.out.println();
        System.out.println("Estimated, assumed no outliers:");
        app.estimateNoOutliers(observations).print();
        System.out.println("Estimated, assumed that there are outliers:");
        app.estimateOutliers(observations).print();
        System.out.println();
        System.out.println("Adding outliers");
        System.out.println();
        app.addOutliers(observations, 50);
        System.out.println("Estimated, assumed no outliers:");
        app.estimateNoOutliers(observations).print();
        System.out.println("Estimated, assumed that there are outliers:");
        app.estimateOutliers(observations).print();
    }

    public Se3_F64 estimateNoOutliers(List<Point2D3D> observations) {
        Estimate1ofPnP pnp = FactoryMultiView.computePnP_1(EnumPNP.EPNP, 10, 0);
        Se3_F64 worldToCamera = new Se3_F64();
        pnp.process(observations, worldToCamera);
        RefinePnP refine = FactoryMultiView.refinePnP(1.0E-8, 200);
        Se3_F64 refinedWorldToCamera = new Se3_F64();
        if (!refine.fitModel(observations, worldToCamera, refinedWorldToCamera)) {
            throw new RuntimeException("Refined failed! Input probably bad...");
        }
        return refinedWorldToCamera;
    }

    public Se3_F64 estimateOutliers(List<Point2D3D> observations) {
        Ransac<Se3_F64, Point2D3D> ransac = FactoryMultiViewRobust.pnpRansac(new ConfigPnP(this.intrinsic), new ConfigRansac(300, 1.0));
        if (!ransac.process(observations)) {
            throw new RuntimeException("Probably got bad input data with NaN inside of it");
        }
        System.out.println("Inlier size " + ransac.getMatchSet().size());
        Se3_F64 worldToCamera = (Se3_F64)ransac.getModelParameters();
        RefinePnP refine = FactoryMultiView.refinePnP(1.0E-8, 200);
        Se3_F64 refinedWorldToCamera = new Se3_F64();
        if (!refine.fitModel(ransac.getMatchSet(), worldToCamera, refinedWorldToCamera)) {
            throw new RuntimeException("Refined failed! Input probably bad...");
        }
        return refinedWorldToCamera;
    }

    public List<Point2D3D> createObservations(Se3_F64 worldToCamera, int total) {
        Se3_F64 cameraToWorld = worldToCamera.invert(null);
        PointTransform_F64 pixelToNorm = LensDistortionOps.transformPoint(this.intrinsic).undistort_F64(true, false);
        ArrayList<Point2D3D> observations = new ArrayList<Point2D3D>();
        Point2D_F64 norm = new Point2D_F64();
        for (int i = 0; i < total; ++i) {
            double x = this.rand.nextDouble() * (double)this.intrinsic.width;
            double y = this.rand.nextDouble() * (double)this.intrinsic.height;
            pixelToNorm.compute(x, y, norm);
            double Z = this.rand.nextDouble() + 4.0;
            double X = norm.x * Z;
            double Y = norm.y * Z;
            Point3D_F64 cameraPt = new Point3D_F64(X, Y, Z);
            Point3D_F64 worldPt = new Point3D_F64();
            SePointOps_F64.transform((Se3_F64)cameraToWorld, (Point3D_F64)cameraPt, (Point3D_F64)worldPt);
            Point2D3D o = new Point2D3D();
            o.getLocation().set(worldPt);
            o.getObservation().set(norm.x, norm.y);
            observations.add(o);
        }
        return observations;
    }

    public void addOutliers(List<Point2D3D> observations, int total) {
        int size = observations.size();
        for (int i = 0; i < total; ++i) {
            Point2D3D p = observations.get(this.rand.nextInt(size));
            Point2D3D o = new Point2D3D();
            o.observation.set(p.observation);
            o.location.x = p.location.x + this.rand.nextGaussian() * 5.0;
            o.location.y = p.location.y + this.rand.nextGaussian() * 5.0;
            o.location.z = p.location.z + this.rand.nextGaussian() * 5.0;
            observations.add(o);
        }
        Collections.shuffle(observations, this.rand);
    }
}

