/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.segmentation;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.alg.segmentation.watershed.WatershedVincentSoille1991;
import boofcv.factory.segmentation.FactorySegmentationAlg;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.VisualizeRegions;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;

public class ExampleWatershedWithSeeds {
    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("particles01.jpg"));
        GrayU8 input = ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class);
        GrayU8 binary = new GrayU8(input.width, input.height);
        GrayS32 label = new GrayS32(input.width, input.height);
        double mean = ImageStatistics.mean(input);
        ThresholdImageOps.threshold(input, binary, (int)mean, true);
        GrayU8 filtered = BinaryImageOps.erode8(binary, 2, null);
        int numRegions = BinaryImageOps.contour(filtered, ConnectRule.EIGHT, label).size() + 1;
        WatershedVincentSoille1991 watershed = FactorySegmentationAlg.watershed(ConnectRule.FOUR);
        watershed.process(input, label);
        GrayS32 output = watershed.getOutput();
        BufferedImage outLabeled = VisualizeBinaryData.renderLabeledBG(label, numRegions, null);
        VisualizeRegions.watersheds(output, image, 1);
        watershed.removeWatersheds();
        BufferedImage outRegions = VisualizeRegions.regions(output, --numRegions, null);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(image, "Watersheds");
        gui.addImage(outRegions, "Regions");
        gui.addImage(outLabeled, "Seeds");
        ShowImages.showWindow(gui, "Watershed", true);
    }
}

