/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.segmentation;

import boofcv.abst.segmentation.ImageSuperpixels;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.alg.segmentation.ComputeRegionMeanColor;
import boofcv.alg.segmentation.ImageSegmentationOps;
import boofcv.factory.segmentation.ConfigFh04;
import boofcv.factory.segmentation.FactoryImageSegmentation;
import boofcv.factory.segmentation.FactorySegmentationAlg;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.feature.VisualizeRegions;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.feature.ColorQueue_F32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;
import org.ddogleg.struct.GrowQueue_I32;

public class ExampleSegmentSuperpixels {
    public static <T extends ImageBase> void performSegmentation(ImageSuperpixels<T> alg, T color) {
        GBlurImageOps.gaussian(color, color, 0.5, -1, null);
        GrayS32 pixelToSegment = new GrayS32(color.width, color.height);
        alg.segment(color, pixelToSegment);
        ExampleSegmentSuperpixels.visualize(pixelToSegment, color, alg.getTotalSuperpixels());
    }

    public static <T extends ImageBase> void visualize(GrayS32 pixelToRegion, T color, int numSegments) {
        ImageType type = color.getImageType();
        ComputeRegionMeanColor<T> colorize = FactorySegmentationAlg.regionMeanColor(type);
        ColorQueue_F32 segmentColor = new ColorQueue_F32(type.getNumBands());
        segmentColor.resize(numSegments);
        GrowQueue_I32 regionMemberCount = new GrowQueue_I32();
        regionMemberCount.resize(numSegments);
        ImageSegmentationOps.countRegionPixels(pixelToRegion, numSegments, regionMemberCount.data);
        colorize.process(color, pixelToRegion, regionMemberCount, segmentColor);
        BufferedImage outColor = VisualizeRegions.regionsColor(pixelToRegion, segmentColor, null);
        BufferedImage outSegments = VisualizeRegions.regions(pixelToRegion, numSegments, null);
        BufferedImage outBorder = new BufferedImage(color.width, color.height, 1);
        ConvertBufferedImage.convertTo(color, outBorder, true);
        VisualizeRegions.regionBorders(pixelToRegion, 0xFF0000, outBorder);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(outColor, "Color of Segments");
        gui.addImage(outBorder, "Region Borders");
        gui.addImage(outSegments, "Regions");
        ShowImages.showWindow(gui, "Superpixels", true);
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("segment/berkeley_horses.jpg"));
        image = ConvertBufferedImage.stripAlphaChannel(image);
        ImageType<Planar<GrayF32>> imageType = ImageType.pl(3, GrayF32.class);
        ImageSuperpixels<Planar<GrayF32>> alg = FactoryImageSegmentation.fh04(new ConfigFh04(100.0f, 30), imageType);
        Planar<GrayF32> color = imageType.createImage(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFrom(image, color, true);
        ExampleSegmentSuperpixels.performSegmentation(alg, color);
    }
}

