/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.segmentation;

import boofcv.alg.color.ColorHsv;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.Planar;
import georegression.metric.UtilAngle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;

public class ExampleSegmentColor {
    public static void printClickedColor(final BufferedImage image) {
        ImagePanel gui = new ImagePanel(image);
        gui.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                float[] color = new float[3];
                int rgb = image.getRGB(e.getX(), e.getY());
                ColorHsv.rgbToHsv(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, color);
                System.out.println("H = " + color[0] + " S = " + color[1] + " V = " + color[2]);
                ExampleSegmentColor.showSelectedColor("Selected", image, color[0], color[1]);
            }
        });
        ShowImages.showWindow(gui, "Color Selector");
    }

    public static void showSelectedColor(String name, BufferedImage image, float hue, float saturation) {
        Planar<GrayF32> input = ConvertBufferedImage.convertFromMulti(image, null, true, GrayF32.class);
        Planar hsv = (Planar)input.createSameShape();
        ColorHsv.rgbToHsv_F32(input, hsv);
        float maxDist2 = 0.16000001f;
        GrayF32 H = (GrayF32)hsv.getBand(0);
        GrayF32 S = (GrayF32)hsv.getBand(1);
        float adjustUnits = 1.5707964f;
        BufferedImage output = new BufferedImage(input.width, input.height, 1);
        for (int y = 0; y < hsv.height; ++y) {
            for (int x = 0; x < hsv.width; ++x) {
                float ds;
                float dh = UtilAngle.dist((float)H.unsafe_get(x, y), (float)hue);
                float dist2 = dh * dh + (ds = (S.unsafe_get(x, y) - saturation) * adjustUnits) * ds;
                if (!(dist2 <= maxDist2)) continue;
                output.setRGB(x, y, image.getRGB(x, y));
            }
        }
        ShowImages.showWindow(output, "Showing " + name);
    }

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("sunflowers.jpg"));
        ExampleSegmentColor.printClickedColor(image);
        ExampleSegmentColor.showSelectedColor("Yellow", image, 1.0f, 1.0f);
        ExampleSegmentColor.showSelectedColor("Green", image, 1.5f, 0.65f);
    }
}

