/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.alg.filter.blur.BlurImageOps;
import boofcv.alg.misc.GPixelMath;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.Planar;
import java.awt.image.BufferedImage;

public class ExamplePlanarImages {
    public static ListDisplayPanel gui = new ListDisplayPanel();

    public static void independent(BufferedImage input) {
        Planar<GrayU8> image = ConvertBufferedImage.convertFromMulti(input, null, true, GrayU8.class);
        Planar blurred = (Planar)image.createSameShape();
        for (int i = 0; i < image.getNumBands(); ++i) {
            BlurImageOps.gaussian(image.getBand(i), (GrayU8)blurred.getBand(i), -1.0, 5, null);
        }
        BufferedImage output = new BufferedImage(image.width, image.height, input.getType());
        ConvertBufferedImage.convertTo(blurred, output, true);
        gui.addImage(input, "Input");
        gui.addImage(output, "Gaussian Blur");
    }

    public static void pixelAccess(BufferedImage input) {
        int i;
        Planar<GrayU8> image = ConvertBufferedImage.convertFromMulti(input, null, true, GrayU8.class);
        int x = 10;
        int y = 10;
        for (i = 0; i < image.getNumBands(); ++i) {
            System.out.println("Original " + i + " = " + image.getBand(i).get(x, y));
        }
        for (i = 0; i < image.getNumBands(); ++i) {
            image.getBand(i).set(x, y, 100 + i);
        }
        for (i = 0; i < image.getNumBands(); ++i) {
            System.out.println("Result   " + i + " = " + image.getBand(i).get(x, y));
        }
    }

    public static void convertToGray(BufferedImage input) {
        Planar<GrayU8> image = ConvertBufferedImage.convertFromMulti(input, null, true, GrayU8.class);
        GrayU8 gray = new GrayU8(image.width, image.height);
        GPixelMath.averageBand(image, gray);
        BufferedImage outputAve = ConvertBufferedImage.convertTo(gray, null);
        BufferedImage outputBand0 = ConvertBufferedImage.convertTo(image.getBand(0), null);
        gui.addImage(outputAve, "Gray Averaged");
        gui.addImage(outputBand0, "Band 0");
    }

    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(UtilIO.pathExample("apartment_building_02.jpg"));
        ExamplePlanarImages.independent(input);
        ExamplePlanarImages.pixelAccess(input);
        ExamplePlanarImages.convertToGray(input);
        ShowImages.showWindow(gui, "Color Planar Image Examples", true);
    }
}

