/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.DerivativeType;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.core.image.border.BorderType;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.image.BufferedImage;

public class ExampleImageDerivative {
    public static void main(String[] args) {
        BufferedImage input = UtilImageIO.loadImage(UtilIO.pathExample("simple_objects.jpg"));
        GrayF32 grey = new GrayF32(input.getWidth(), input.getHeight());
        ConvertBufferedImage.convertFrom(input, grey);
        GrayF32 derivX = new GrayF32(grey.width, grey.height);
        GrayF32 derivY = new GrayF32(grey.width, grey.height);
        GImageDerivativeOps.gradient(DerivativeType.SOBEL, grey, derivX, derivY, BorderType.EXTENDED);
        GrayF32 derivXX = new GrayF32(grey.width, grey.height);
        GrayF32 derivXY = new GrayF32(grey.width, grey.height);
        GrayF32 derivYY = new GrayF32(grey.width, grey.height);
        GImageDerivativeOps.hessian(DerivativeType.SOBEL, derivX, derivY, derivXX, derivXY, derivYY, BorderType.EXTENDED);
        AnyImageDerivative<GrayF32, GrayF32> derivative = GImageDerivativeOps.createAnyDerivatives(DerivativeType.SOBEL, GrayF32.class, GrayF32.class);
        derivative.setInput(grey);
        GrayF32 derivXYX = derivative.getDerivative(true, false, true);
        ListDisplayPanel gui = new ListDisplayPanel();
        gui.addImage(ConvertBufferedImage.convertTo(grey, null), "Input Grey");
        gui.addImage(VisualizeImageData.colorizeSign((ImageGray)derivX, null, -1.0), "Sobel X");
        gui.addImage(VisualizeImageData.colorizeSign((ImageGray)derivY, null, -1.0), "Sobel Y");
        gui.addImage(VisualizeImageData.colorizeGradient(derivX, derivY, -1.0f), "Sobel X and Y");
        gui.addImage(VisualizeImageData.colorizeSign((ImageGray)derivXX, null, -1.0), "Sobel XX");
        gui.addImage(VisualizeImageData.colorizeSign((ImageGray)derivXY, null, -1.0), "Sobel XY");
        gui.addImage(VisualizeImageData.colorizeSign((ImageGray)derivYY, null, -1.0), "Sobel YY");
        gui.addImage(VisualizeImageData.colorizeSign((ImageGray)derivXYX, null, -1.0), "Sobel XYX");
        ShowImages.showWindow(gui, "Image Derivatives", true);
    }
}

