/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.alg.filter.convolve.GConvolveImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.convolve.Kernel2D_I32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;

public class ExampleConvolution {
    private static ListDisplayPanel panel = new ListDisplayPanel();

    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("sunflowers.jpg"));
        GrayU8 gray = ConvertBufferedImage.convertFromSingle(image, null, GrayU8.class);
        ExampleConvolution.convolve1D(gray);
        ExampleConvolution.convolve2D(gray);
        ExampleConvolution.normalize2D(gray);
        ShowImages.showWindow(panel, "Convolution Examples", true);
    }

    private static void convolve1D(GrayU8 gray) {
        ImageBorder<GrayU8> border = FactoryImageBorder.single(gray, BorderType.EXTENDED);
        Kernel1D_I32 kernel = new Kernel1D_I32(2);
        kernel.offset = 1;
        kernel.data[0] = 1;
        kernel.data[1] = -1;
        GrayS16 output = new GrayS16(gray.width, gray.height);
        GConvolveImageOps.horizontal(kernel, gray, output, border);
        panel.addImage(VisualizeImageData.standard(output, null), "1D Horizontal");
        GConvolveImageOps.vertical(kernel, gray, output, border);
        panel.addImage(VisualizeImageData.standard(output, null), "1D Vertical");
    }

    private static void convolve2D(GrayU8 gray) {
        Kernel2D_I32 kernel = new Kernel2D_I32(3);
        kernel.set(1, 0, 2);
        kernel.set(2, 1, 2);
        kernel.set(0, 1, -2);
        kernel.set(1, 2, -2);
        GrayS16 output = new GrayS16(gray.width, gray.height);
        ImageBorder<GrayU8> border = FactoryImageBorder.single(gray, BorderType.EXTENDED);
        GConvolveImageOps.convolve(kernel, gray, output, border);
        panel.addImage(VisualizeImageData.standard(output, null), "2D Kernel");
    }

    private static void normalize2D(GrayU8 gray) {
        Kernel2D_I32 kernel = (Kernel2D_I32)FactoryKernelGaussian.gaussian2D(GrayU8.class, -1.0, 3);
        GrayU8 output = new GrayU8(gray.width, gray.height);
        GConvolveImageOps.convolveNormalized(kernel, gray, output);
        panel.addImage(VisualizeImageData.standard(output, null), "2D Normalized Kernel");
    }
}

