/*
 * Decompiled with CFR 0.152.
 */
package boofcv.examples.imageprocessing;

import boofcv.alg.filter.binary.BinaryImageOps;
import boofcv.alg.filter.binary.Contour;
import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.alg.filter.binary.ThresholdImageOps;
import boofcv.gui.ListDisplayPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ShowImages;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;
import java.awt.image.BufferedImage;
import java.util.List;

public class ExampleBinaryOps {
    public static void main(String[] args) {
        BufferedImage image = UtilImageIO.loadImage(UtilIO.pathExample("particles01.jpg"));
        GrayF32 input = ConvertBufferedImage.convertFromSingle(image, null, GrayF32.class);
        GrayU8 binary = new GrayU8(input.width, input.height);
        GrayS32 label = new GrayS32(input.width, input.height);
        double threshold = GThresholdImageOps.computeOtsu(input, 0, 255);
        ThresholdImageOps.threshold(input, binary, (float)threshold, true);
        GrayU8 filtered = BinaryImageOps.erode8(binary, 1, null);
        filtered = BinaryImageOps.dilate8(filtered, 1, null);
        List<Contour> contours = BinaryImageOps.contour(filtered, ConnectRule.EIGHT, label);
        int colorExternal = 0xFFFFFF;
        int colorInternal = 0xFF2020;
        BufferedImage visualBinary = VisualizeBinaryData.renderBinary(binary, false, null);
        BufferedImage visualFiltered = VisualizeBinaryData.renderBinary(filtered, false, null);
        BufferedImage visualLabel = VisualizeBinaryData.renderLabeledBG(label, contours.size(), null);
        BufferedImage visualContour = VisualizeBinaryData.renderContours(contours, colorExternal, colorInternal, input.width, input.height, null);
        ListDisplayPanel panel = new ListDisplayPanel();
        panel.addImage(visualBinary, "Binary Original");
        panel.addImage(visualFiltered, "Binary Filtered");
        panel.addImage(visualLabel, "Labeled Blobs");
        panel.addImage(visualContour, "Contours");
        ShowImages.showWindow(panel, "Binary Operations", true);
    }
}

