/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d2;

import boofcv.abst.feature.detect.interest.ConfigFastHessian;
import boofcv.abst.feature.detect.interest.ConfigGeneralDetector;
import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.demonstrations.sfm.d2.Stabilize2DPanel;
import boofcv.demonstrations.sfm.d2.VideoStitchBaseApp;
import boofcv.factory.feature.tracker.FactoryPointTracker;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.homography.Homography2D_F64;
import java.util.ArrayList;

public class VideoStabilizeSequentialPointApp<I extends ImageGray, D extends ImageGray, T extends InvertibleTransform<T>>
extends VideoStitchBaseApp<I, T> {
    private int maxFeatures = 250;
    int largeMotionThreshold = 5000;

    public VideoStabilizeSequentialPointApp(Class<I> imageType, Class<D> derivType) {
        super(2, imageType, true, new Stabilize2DPanel());
        PkltConfig config = new PkltConfig();
        config.templateRadius = 3;
        config.pyramidScaling = new int[]{1, 2, 4, 8};
        ConfigFastHessian configFH = new ConfigFastHessian();
        configFH.maxFeaturesPerScale = 200;
        configFH.initialSampleSize = 2;
        this.addAlgorithm(0, "KLT", FactoryPointTracker.klt(config, new ConfigGeneralDetector(this.maxFeatures, 1, 3.0f), imageType, derivType));
        this.addAlgorithm(0, "ST-BRIEF", FactoryPointTracker.dda_ST_BRIEF(100, new ConfigGeneralDetector(400, 1, 10.0f), imageType, derivType));
        this.addAlgorithm(0, "ST-NCC", FactoryPointTracker.dda_ST_NCC(new ConfigGeneralDetector(500, 3, 10.0f), 5, imageType, derivType));
        this.addAlgorithm(0, "FH-SURF", FactoryPointTracker.dda_FH_SURF_Fast(configFH, null, null, imageType));
        this.addAlgorithm(0, "ST-SURF-KLT", FactoryPointTracker.combined_ST_SURF_KLT(new ConfigGeneralDetector(400, 3, 1.0f), config, 50, null, null, imageType, derivType));
        this.addAlgorithm(0, "FH-SURF-KLT", FactoryPointTracker.combined_FH_SURF_KLT(config, 50, configFH, null, null, imageType));
        this.addAlgorithm(1, "Affine", new Affine2D_F64());
        this.addAlgorithm(1, "Homography", new Homography2D_F64());
        this.absoluteMinimumTracks = 40;
        this.respawnTrackFraction = 0.3;
        this.respawnCoverageFraction = 0.5;
        this.maxJumpFraction = 0.3;
        this.inlierThreshold = 4.0;
    }

    @Override
    protected void init(int inputWidth, int inputHeight) {
        this.setStitchImageSize(inputWidth, inputHeight);
        ((Stabilize2DPanel)this.gui).setInputSize(inputWidth, inputHeight);
        this.alg.configure(inputWidth, inputHeight, this.fitModel.createInstance());
    }

    @Override
    protected boolean checkLocation(StitchingFromMotion2D.Corners corners) {
        return false;
    }

    public static void main(String[] args) {
        VideoStabilizeSequentialPointApp app = new VideoStabilizeSequentialPointApp(GrayF32.class, GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Shake", UtilIO.pathExample("shake.mjpeg")));
        inputs.add(new PathLabel("Zoom", UtilIO.pathExample("zoom.mjpeg")));
        inputs.add(new PathLabel("Rotate", UtilIO.pathExample("rotate.mjpeg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Video Image Stabilize", true);
    }

    @Override
    protected void handleRunningStatus(int status) {
    }
}

