/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.sfm.d2;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JTextArea;

public class ImageMotionInfoPanel
extends StandardAlgConfigPanel
implements ItemListener,
ActionListener {
    JButton resetButton;
    JCheckBox showView;
    JCheckBox showInliers;
    JCheckBox showAll;
    JTextArea displayFPS;
    JTextArea displayNumKeyFrames;
    JTextArea displayNumTracks;
    JTextArea displayNumInliers;
    boolean setShowView = true;
    boolean setShowInliers = false;
    boolean setShowAll = false;
    boolean shouldReset = false;

    public ImageMotionInfoPanel() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(BorderFactory.createEtchedBorder(0));
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(this);
        this.showView = new JCheckBox("View");
        this.showView.addItemListener(this);
        this.showView.setSelected(this.setShowView);
        this.showAll = new JCheckBox("Show All");
        this.showAll.addItemListener(this);
        this.showAll.setSelected(this.setShowAll);
        this.showInliers = new JCheckBox("Show Inliers");
        this.showInliers.addItemListener(this);
        this.showInliers.setSelected(this.setShowInliers);
        this.displayFPS = this.createTextInfo();
        this.displayNumKeyFrames = this.createTextInfo();
        this.displayNumTracks = this.createTextInfo();
        this.displayNumInliers = this.createTextInfo();
        this.addAlignLeft(this.resetButton, this);
        this.addAlignLeft(this.showView, this);
        this.addAlignLeft(this.showAll, this);
        this.addAlignLeft(this.showInliers, this);
        this.addSeparator(200);
        this.addLabeled(this.displayFPS, "Algorithm FPS:", this);
        this.addLabeled(this.displayNumKeyFrames, "Resets:", this);
        this.addLabeled(this.displayNumTracks, "Tracks:", this);
        this.addLabeled(this.displayNumInliers, "Inliers:", this);
        this.setPreferredSize(new Dimension(175, 300));
    }

    private JTextArea createTextInfo() {
        JTextArea comp = new JTextArea(1, 6);
        comp.setMaximumSize(comp.getPreferredSize());
        comp.setEditable(false);
        return comp;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.resetButton) {
            this.shouldReset = true;
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getItem() == this.showInliers) {
            this.setShowInliers = e.getStateChange() != 2;
        } else if (e.getItem() == this.showAll) {
            this.setShowAll = e.getStateChange() != 2;
        } else if (e.getItem() == this.showView) {
            this.setShowView = e.getStateChange() != 2;
        }
    }

    public void setFPS(double fps) {
        this.displayFPS.setText(String.format("%5.1f", fps));
    }

    public void setKeyFrames(int totalFaults) {
        this.displayNumKeyFrames.setText(String.format("%5d", totalFaults));
    }

    public void setNumTracks(int totalTracks) {
        this.displayNumTracks.setText(String.format("%5d", totalTracks));
    }

    public void setNumInliers(int totalInliers) {
        this.displayNumInliers.setText(String.format("%5d", totalInliers));
    }

    public boolean getShowInliers() {
        return this.setShowInliers;
    }

    public boolean getShowAll() {
        return this.setShowAll;
    }

    public boolean getShowView() {
        return this.setShowView;
    }

    public boolean resetRequested() {
        if (this.shouldReset) {
            this.shouldReset = false;
            return true;
        }
        return false;
    }
}

