/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.interpolate;

import boofcv.abst.distort.FDistort;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.core.image.border.BorderType;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;

public class EvaluateInterpolateEnlargeApp<T extends ImageBase>
extends SelectAlgorithmAndInputPanel
implements ComponentListener {
    ImageType<T> imageType;
    T color;
    T scaledImage;
    ImagePanel panel = new ImagePanel();
    boolean hasProcessed = false;

    public EvaluateInterpolateEnlargeApp(ImageType<T> imageType) {
        super(1);
        this.imageType = imageType;
        this.panel.setScaling(ScaleOptions.NONE);
        this.setMainGUI(this.panel);
        this.color = imageType.createImage(1, 1);
        this.scaledImage = imageType.createImage(1, 1);
        this.addAlgorithm(0, "Nearest Neighbor", (Object)TypeInterpolate.NEAREST_NEIGHBOR);
        this.addAlgorithm(0, "Bilinear", (Object)TypeInterpolate.BILINEAR);
        this.addAlgorithm(0, "Bicubic Kernel", (Object)TypeInterpolate.BICUBIC);
        this.addAlgorithm(0, "Polynomial 4", (Object)TypeInterpolate.POLYNOMIAL4);
        this.setPreferredSize(new Dimension(300, 300));
        this.addComponentListener(this);
    }

    public void process(BufferedImage image) {
        this.setInputImage(image);
        ((ImageBase)this.color).reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFrom(image, this.color, true);
        this.hasProcessed = true;
        this.doRefreshAll();
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        if (this.color == null || 0 == this.panel.getWidth() || 0 == this.panel.getHeight()) {
            return;
        }
        TypeInterpolate typeInterpolate = (TypeInterpolate)((Object)cookie);
        ((ImageBase)this.scaledImage).reshape(this.panel.getWidth(), this.panel.getHeight());
        new FDistort((ImageBase)this.color, (ImageBase)this.scaledImage).interp(typeInterpolate).border(BorderType.EXTENDED).scale().apply();
        BufferedImage out = ConvertBufferedImage.convertTo(this.scaledImage, null, true);
        this.panel.setBufferedImage(out);
        this.panel.repaint();
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.hasProcessed;
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.setActiveAlgorithm(0, null, this.getAlgorithmCookie(0));
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    public static void main(String[] args) {
        ImageType<Planar<GrayF32>> type = ImageType.pl(3, GrayF32.class);
        EvaluateInterpolateEnlargeApp<Planar<GrayF32>> app = new EvaluateInterpolateEnlargeApp<Planar<GrayF32>>(type);
        app.setPreferredSize(new Dimension(500, 500));
        app.setBaseDirectory(UtilIO.pathExample(""));
        app.loadInputData(UtilIO.pathExample("interpolation.txt"));
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Interpolation Enlarge", true);
    }
}

