/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.filter;

import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.ProgressMonitor;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ShowImageBlurApp<T extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements ChangeListener {
    int radius = 2;
    int active = 0;
    Class<T> imageType;
    JSpinner radiusSpinner;
    ImagePanel gui = new ImagePanel();
    boolean processedImage = false;
    Planar<T> input;
    Planar<T> output;
    Planar<T> storage;
    BufferedImage renderedImage;
    volatile int progress;

    public ShowImageBlurApp(Class<T> imageType) {
        super(1);
        this.addAlgorithm(0, "Gaussian", 0);
        this.addAlgorithm(0, "Mean", 1);
        this.addAlgorithm(0, "Median", 2);
        this.imageType = imageType;
        this.input = new Planar<T>(imageType, 1, 1, 3);
        this.output = new Planar<T>(imageType, 1, 1, 3);
        this.storage = new Planar<T>(imageType, 1, 1, 3);
        this.addToToolbar(this.createRadialSelect());
        this.setMainGUI(this.gui);
    }

    private JPanel createRadialSelect() {
        JPanel ret = new JPanel();
        ret.setLayout(new BoxLayout(ret, 0));
        JLabel desc = new JLabel("Radius:");
        this.radiusSpinner = new JSpinner(new SpinnerNumberModel(this.radius, 1, 30, 1));
        this.radiusSpinner.addChangeListener(this);
        this.radiusSpinner.setMaximumSize(this.radiusSpinner.getPreferredSize());
        ret.add(Box.createRigidArea(new Dimension(10, 1)));
        ret.add(desc);
        ret.add(this.radiusSpinner);
        ret.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    JPanel src = (JPanel)evt.getSource();
                    boolean value = (Boolean)evt.getNewValue();
                    src.getComponent(1).setEnabled(value);
                    src.getComponent(2).setEnabled(value);
                }
            }
        });
        return ret;
    }

    public void process(final BufferedImage image) {
        this.input.reshape(image.getWidth(), image.getHeight());
        this.output.reshape(image.getWidth(), image.getHeight());
        this.storage.reshape(image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromMulti(image, this.input, true, this.imageType);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowImageBlurApp.this.setInputImage(image);
                ShowImageBlurApp.this.renderedImage = new BufferedImage(ShowImageBlurApp.this.input.width, ShowImageBlurApp.this.input.height, 4);
                ShowImageBlurApp.this.gui.setBufferedImage(ShowImageBlurApp.this.renderedImage);
                ShowImageBlurApp.this.gui.setPreferredSize(new Dimension(ShowImageBlurApp.this.input.width, ShowImageBlurApp.this.input.height));
                ShowImageBlurApp.this.gui.repaint();
                ShowImageBlurApp.this.processedImage = true;
                ShowImageBlurApp.this.doRefreshAll();
            }
        });
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.setActiveAlgorithm(0, null, cookies[0]);
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.active = (Integer)cookie;
        this.performUpdate();
    }

    private synchronized void performUpdate() {
        if (this.input == null || this.output == null) {
            return;
        }
        String message = this.active == 2 ? "Median is slow" : "";
        this.progress = 0;
        MyMonitor monitor = new MyMonitor(this, message);
        monitor.start();
        int i = 0;
        while (i < this.input.getNumBands()) {
            T bandIn = this.input.getBand(i);
            T bandOut = this.output.getBand(i);
            T bandStorage = this.storage.getBand(i);
            switch (this.active) {
                case 0: {
                    GBlurImageOps.gaussian(bandIn, bandOut, -1.0, this.radius, bandStorage);
                    break;
                }
                case 1: {
                    GBlurImageOps.mean(bandIn, bandOut, this.radius, bandStorage);
                    break;
                }
                case 2: {
                    GBlurImageOps.median(bandIn, bandOut, this.radius);
                }
            }
            ++i;
            ++this.progress;
        }
        monitor.stopThread();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ConvertBufferedImage.convertTo(ShowImageBlurApp.this.output, ShowImageBlurApp.this.renderedImage, true);
                ShowImageBlurApp.this.gui.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.process(image);
        }
    }

    @Override
    public synchronized void stateChanged(ChangeEvent e) {
        final int lradius = ((Number)this.radiusSpinner.getValue()).intValue();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ShowImageBlurApp.this.radius = lradius;
                ShowImageBlurApp.this.performUpdate();
            }
        });
    }

    public static void main(String[] args) {
        ShowImageBlurApp<GrayU8> app = new ShowImageBlurApp<GrayU8>(GrayU8.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("sunflowers", UtilIO.pathExample("sunflowers.jpg")));
        inputs.add(new PathLabel("beach", UtilIO.pathExample("scale/beach02.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Image Blur", true);
    }

    private class MyMonitor
    extends ProgressMonitorThread {
        protected MyMonitor(Component comp, String message) {
            super(new ProgressMonitor(comp, "Blurring the Image", message, 0, ShowImageBlurApp.this.input.getNumBands()));
        }

        @Override
        public void doRun() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    MyMonitor.this.monitor.setProgress(ShowImageBlurApp.this.progress);
                }
            });
        }
    }
}

