/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.fiducial;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.fiducial.FiducialStability;
import boofcv.abst.fiducial.SquareImage_to_FiducialDetector;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.calib.ConfigSquareGridBinary;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.fiducial.FactoryFiducial;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.gui.VideoProcessAppBase;
import boofcv.gui.fiducial.VisualizeFiducial;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.SimpleImageSequence;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.Planar;
import georegression.struct.se.Se3_F64;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;

public class FiducialTrackerApp<I extends ImageGray>
extends VideoProcessAppBase<Planar<I>> {
    public static final String SQUARE_NUMBER = "Square Number";
    public static final String SQUARE_PICTURE = "Square Picture";
    public static final String CALIB_CHESS = "Chessboard";
    public static final String CALIB_SQUARE_GRID = "Square Grid";
    public static final String CALIB_SQUARE_BINARY_GRID = "Square Binary Grid";
    private static final Font font = new Font("Serif", 1, 14);
    Class<I> imageClass;
    ImagePanel panel = new ImagePanel();
    I gray;
    FiducialDetector detector;
    IntrinsicParameters intrinsic;
    boolean processedInputImage = false;
    boolean firstFrame = true;
    JCheckBox computeStability = new JCheckBox("Stability");
    FiducialStability stability = new FiducialStability();
    List<FiducialInfo> fiducialInfo = new ArrayList<FiducialInfo>();
    FiducialStability stabilityMax = new FiducialStability();

    public FiducialTrackerApp(Class<I> imageType) {
        super(0, ImageType.pl(3, imageType));
        this.imageClass = imageType;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        this.panel.setPreferredSize(new Dimension(640, 480));
        this.panel.setFocusable(true);
        this.panel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                FiducialTrackerApp.this.isPaused = !FiducialTrackerApp.this.isPaused;
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.addToToolbar(this.computeStability);
        this.computeStability.addActionListener(this);
        this.computeStability.setSelected(true);
        this.setMainGUI(this.panel);
        this.periodSpinner.setValue(33);
    }

    @Override
    public void process(SimpleImageSequence<Planar<I>> sequence) {
        this.stopWorker();
        this.sequence = sequence;
        sequence.setLoop(true);
        this.setPause(false);
        if (!sequence.hasNext()) {
            throw new IllegalArgumentException("Empty sequence");
        }
        this.doRefreshAll();
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.firstFrame = true;
        this.setPause(false);
        this.startWorkerThread();
    }

    @Override
    public void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        this.stopWorker();
        this.sequence.reset();
        this.refreshAll(null);
    }

    @Override
    protected void updateAlg(Planar<I> frame, BufferedImage buffImage) {
        if (this.detector.getInputType().getFamily() == ImageType.Family.GRAY) {
            ((ImageGray)this.gray).reshape(frame.width, frame.height);
            GConvertImage.average(frame, this.gray);
        }
        this.detector.detect(this.gray);
        this.processedInputImage = true;
    }

    @Override
    protected void updateAlgGUI(Planar<I> frame, BufferedImage imageGUI, double fps) {
        if (this.firstFrame) {
            this.panel.setPreferredSize(new Dimension(imageGUI.getWidth(), imageGUI.getHeight()));
            this.firstFrame = false;
        }
        int height = this.getHeight();
        Graphics2D g2 = imageGUI.createGraphics();
        Se3_F64 targetToSensor = new Se3_F64();
        for (int i = 0; i < this.detector.totalFound(); ++i) {
            this.detector.getFiducialToCamera(i, targetToSensor);
            double width = this.detector.getWidth(i);
            long id = this.detector.getId(i);
            VisualizeFiducial.drawLabelCenter(targetToSensor, this.intrinsic, "" + id, g2);
            VisualizeFiducial.drawCube(targetToSensor, this.intrinsic, width, 3, g2);
            if (!this.computeStability.isSelected()) continue;
            this.handleStability(height, g2, i, id);
        }
        this.panel.setBufferedImageSafe(imageGUI);
        this.panel.repaint();
    }

    private void handleStability(int height, Graphics2D g2, int index, long fiducialID) {
        FiducialInfo info = this.findFiducial(fiducialID);
        ++info.totalObserved;
        g2.setFont(font);
        if (this.detector.computeStability(index, 0.25, this.stability)) {
            this.stabilityMax.location = Math.max(this.stability.location, this.stabilityMax.location);
            this.stabilityMax.orientation = Math.max(this.stability.orientation, this.stabilityMax.orientation);
        }
        if (info.totalObserved > 20) {
            double fractionLocation = this.stability.location / this.stabilityMax.location;
            double fractionOrientation = this.stability.orientation / this.stabilityMax.orientation;
            int maxHeight = (int)((double)height * 0.15);
            int x = info.grid * 60;
            int y = 10 + maxHeight;
            g2.setColor(Color.BLUE);
            int h = (int)(fractionLocation * (double)maxHeight);
            g2.fillRect(x, y - h, 20, h);
            g2.setColor(Color.CYAN);
            h = (int)(fractionOrientation * (double)maxHeight);
            g2.fillRect(x += 25, y - h, 20, h);
            g2.setColor(Color.RED);
            g2.drawString("" + info.id, x - 20, y + 20);
        }
    }

    private FiducialInfo findFiducial(long id) {
        for (int i = 0; i < this.fiducialInfo.size(); ++i) {
            FiducialInfo info = this.fiducialInfo.get(i);
            if (info.id != id) continue;
            return info;
        }
        FiducialInfo found = new FiducialInfo();
        found.id = id;
        found.grid = this.fiducialInfo.size();
        this.fiducialInfo.add(found);
        return found;
    }

    @Override
    public void changeInput(String name, int index) {
        this.stopWorker();
        this.processedInputImage = false;
        String videoName = ((PathLabel)this.inputRefs.get(index)).getPath();
        String path = videoName.substring(0, videoName.lastIndexOf(47));
        ConfigThreshold configThreshold = ConfigThreshold.local(ThresholdType.LOCAL_SQUARE, 10);
        if (name.compareTo(SQUARE_NUMBER) == 0) {
            this.detector = FactoryFiducial.squareBinary(new ConfigFiducialBinary(0.1), configThreshold, this.imageClass);
        } else if (name.compareTo(SQUARE_PICTURE) == 0) {
            double length = 0.1;
            this.detector = FactoryFiducial.squareImage(new ConfigFiducialImage(), configThreshold, this.imageClass);
            SquareImage_to_FiducialDetector d = (SquareImage_to_FiducialDetector)this.detector;
            String pathImg = new File(path, "../patterns").getPath();
            ArrayList<String> names = new ArrayList<String>();
            names.add("chicken.png");
            names.add("yinyang.png");
            for (String foo : names) {
                BufferedImage img = this.media.openImage(new File(pathImg, foo).getPath());
                if (img == null) {
                    throw new RuntimeException("Can't find file " + new File(pathImg, foo).getPath());
                }
                d.addPatternImage(ConvertBufferedImage.convertFromSingle(img, null, this.imageClass), 125.0, length);
            }
        } else if (name.compareTo(CALIB_CHESS) == 0) {
            this.detector = FactoryFiducial.calibChessboard(new ConfigChessboard(7, 5, 0.03), this.imageClass);
        } else if (name.compareTo(CALIB_SQUARE_GRID) == 0) {
            this.detector = FactoryFiducial.calibSquareGrid(new ConfigSquareGrid(4, 3, 0.03, 0.03), this.imageClass);
        } else if (name.compareTo(CALIB_SQUARE_BINARY_GRID) == 0) {
            File configFile = new File(path, "description_4x3_3x3_4cm_2cm.txt");
            try {
                ConfigSquareGridBinary config = ConfigSquareGridBinary.parseSimple(new BufferedReader(new FileReader(configFile)));
                this.detector = FactoryFiducial.calibSquareGridBinary(config, this.imageClass);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else {
            throw new RuntimeException("Unknown selection");
        }
        this.intrinsic = (IntrinsicParameters)UtilIO.loadXML(this.media.openFile(path + "/intrinsic.xml"));
        this.detector.setIntrinsic(this.intrinsic);
        this.fiducialInfo.clear();
        this.stabilityMax.location = 0.05;
        this.stabilityMax.orientation = 0.02;
        SimpleImageSequence<Planar<I>> video = this.media.openVideo(videoName, ImageType.pl(3, this.imageClass));
        if (video == null) {
            System.err.println("Can't find video " + videoName);
            System.exit(1);
        }
        this.process(video);
    }

    @Override
    protected void handleRunningStatus(int status) {
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedInputImage;
    }

    public static void main(String[] args) {
        Class<GrayU8> type = GrayU8.class;
        FiducialTrackerApp<GrayU8> app = new FiducialTrackerApp<GrayU8>(type);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel(SQUARE_NUMBER, UtilIO.pathExample("fiducial/binary/movie.mjpeg")));
        inputs.add(new PathLabel(SQUARE_PICTURE, UtilIO.pathExample("fiducial/image/video/movie.mjpeg")));
        inputs.add(new PathLabel(CALIB_CHESS, UtilIO.pathExample("fiducial/chessboard/movie.mjpeg")));
        inputs.add(new PathLabel(CALIB_SQUARE_GRID, UtilIO.pathExample("fiducial/square_grid/movie.mp4")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Detecting Fiducials", true);
    }

    private class FiducialInfo {
        int totalObserved;
        long id;
        int grid;

        private FiducialInfo() {
        }
    }
}

