/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.disparity;

import boofcv.abst.feature.disparity.StereoDisparity;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.border.BorderType;
import boofcv.demonstrations.feature.disparity.DisparityDisplayPanel;
import boofcv.factory.feature.disparity.DisparityAlgorithms;
import boofcv.factory.feature.disparity.FactoryStereoDisparity;
import boofcv.gui.SelectAlgorithmAndInputPanel;
import boofcv.gui.d3.PointCloudTiltPanel;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.PathLabel;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class VisualizeStereoDisparity<T extends ImageGray, D extends ImageGray>
extends SelectAlgorithmAndInputPanel
implements DisparityDisplayPanel.Listener {
    BufferedImage origLeft;
    BufferedImage origRight;
    StereoParameters origCalib;
    private BufferedImage colorLeft;
    private BufferedImage colorRight;
    private BufferedImage disparityOut;
    private T inputLeft;
    private T inputRight;
    private T rectLeft;
    private T rectRight;
    private StereoParameters calib;
    private RectifyCalibrated rectifyAlg = RectifyImageOps.createCalibrated();
    private DisparityDisplayPanel control = new DisparityDisplayPanel();
    private JPanel panel = new JPanel();
    private ImagePanel gui = new ImagePanel();
    private PointCloudTiltPanel cloudGui = new PointCloudTiltPanel();
    private boolean computedCloud;
    private int selectedAlg = 0;
    private StereoDisparity<T, D> activeAlg;
    private DenseMatrix64F rectK;
    private volatile boolean processCalled = false;
    private boolean processedImage = false;
    private boolean rectifiedImages = false;
    PointTransform_F64 leftRectToPixel;

    public VisualizeStereoDisparity() {
        super(1);
        this.addAlgorithm(0, "Five Region", 0);
        this.addAlgorithm(0, "Region", 1);
        this.addAlgorithm(0, "Region Basic", 2);
        this.control.setListener(this);
        this.panel.setLayout(new BorderLayout());
        this.panel.add((Component)this.control, "West");
        this.panel.add((Component)this.gui, "Center");
        this.setMainGUI(this.panel);
    }

    public synchronized void process() {
        if (!this.rectifiedImages) {
            return;
        }
        ProcessThread progress = new ProcessThread(this);
        progress.start();
        this.computedCloud = false;
        this.activeAlg.process(this.rectLeft, this.rectRight);
        this.processCalled = true;
        progress.stopThread();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeStereoDisparity.this.disparityRender();
            }
        });
    }

    private synchronized void changeImageView() {
        JPanel comp;
        if (this.control.selectedView < 3) {
            BufferedImage img;
            switch (this.control.selectedView) {
                case 0: {
                    img = this.disparityOut;
                    break;
                }
                case 1: {
                    img = this.colorLeft;
                    break;
                }
                case 2: {
                    img = this.colorRight;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown option");
                }
            }
            this.gui.setBufferedImage(img);
            this.gui.setPreferredSize(new Dimension(this.origLeft.getWidth(), this.origLeft.getHeight()));
            comp = this.gui;
        } else {
            if (!this.computedCloud) {
                this.computedCloud = true;
                double baseline = this.calib.getRightToLeft().getT().norm();
                this.cloudGui.configure(baseline, this.rectK, this.leftRectToPixel, this.control.minDisparity, this.control.maxDisparity);
                this.cloudGui.process((ImageGray)this.activeAlg.getDisparity(), this.colorLeft);
            }
            comp = this.cloudGui;
        }
        this.panel.remove(this.gui);
        this.panel.remove(this.cloudGui);
        this.panel.add((Component)comp, "Center");
        this.panel.validate();
        comp.repaint();
        this.processedImage = true;
    }

    @Override
    public void refreshAll(Object[] cookies) {
        this.process();
    }

    @Override
    public synchronized void setActiveAlgorithm(int indexFamily, String name, Object cookie) {
        int s = ((Number)cookie).intValue();
        if (s != this.selectedAlg) {
            this.selectedAlg = s;
            this.activeAlg = this.createAlg();
            this.doRefreshAll();
        }
    }

    @Override
    public synchronized void changeInput(String name, int index) {
        this.origCalib = (StereoParameters)UtilIO.loadXML(this.media.openFile(((PathLabel)this.inputRefs.get(index)).getPath(0)));
        this.origLeft = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(1));
        this.origRight = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath(2));
        this.changeInputScale();
    }

    private void rectifyInputImages() {
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(this.calib.left, null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(this.calib.right, null);
        this.rectifyAlg.process(K1, new Se3_F64(), K2, this.calib.getRightToLeft().invert(null));
        DenseMatrix64F rect1 = this.rectifyAlg.getRect1();
        DenseMatrix64F rect2 = this.rectifyAlg.getRect2();
        this.rectK = this.rectifyAlg.getCalibrationMatrix();
        RectifyImageOps.allInsideLeft(this.calib.left, rect1, rect2, this.rectK);
        this.leftRectToPixel = RectifyImageOps.transformRectToPixel_F64(this.calib.left, rect1);
        ImageType<T> imageType = ImageType.single(this.activeAlg.getInputType());
        ImageDistort<T, T> distortRect1 = RectifyImageOps.rectifyImage(this.calib.left, rect1, BorderType.SKIP, imageType);
        ImageDistort<T, T> distortRect2 = RectifyImageOps.rectifyImage(this.calib.right, rect2, BorderType.SKIP, imageType);
        distortRect1.apply(this.inputLeft, this.rectLeft);
        distortRect2.apply(this.inputRight, this.rectRight);
        this.rectifiedImages = true;
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    @Override
    public synchronized void disparitySettingChange() {
        this.processCalled = false;
        this.activeAlg = this.createAlg();
        this.doRefreshAll();
    }

    @Override
    public synchronized void disparityGuiChange() {
        this.changeImageView();
    }

    @Override
    public synchronized void disparityRender() {
        if (!this.processCalled) {
            return;
        }
        int color = this.control.colorInvalid ? 176272 : 0;
        D disparity = this.activeAlg.getDisparity();
        this.disparityOut = VisualizeImageData.disparity(disparity, null, this.activeAlg.getMinDisparity(), this.activeAlg.getMaxDisparity(), color);
        this.changeImageView();
    }

    public StereoDisparity<T, D> createAlg() {
        this.processCalled = false;
        int r = this.control.regionRadius;
        int maxDisparity = Math.min(this.colorLeft.getWidth() - 2 * r, this.control.maxDisparity);
        int minDisparity = Math.min(maxDisparity, this.control.minDisparity);
        if (this.control.useSubpixel) {
            switch (this.selectedAlg) {
                case 2: {
                    this.changeGuiActive(false, false);
                    return FactoryStereoDisparity.regionSubpixelWta(DisparityAlgorithms.RECT, minDisparity, maxDisparity, r, r, -1.0, -1, -1.0, GrayU8.class);
                }
                case 1: {
                    this.changeGuiActive(true, true);
                    return FactoryStereoDisparity.regionSubpixelWta(DisparityAlgorithms.RECT, minDisparity, maxDisparity, r, r, this.control.pixelError, this.control.reverseTol, this.control.texture, GrayU8.class);
                }
                case 0: {
                    this.changeGuiActive(true, true);
                    return FactoryStereoDisparity.regionSubpixelWta(DisparityAlgorithms.RECT_FIVE, minDisparity, maxDisparity, r, r, this.control.pixelError, this.control.reverseTol, this.control.texture, GrayU8.class);
                }
            }
            throw new RuntimeException("Unknown selection");
        }
        switch (this.selectedAlg) {
            case 2: {
                this.changeGuiActive(false, false);
                return FactoryStereoDisparity.regionWta(DisparityAlgorithms.RECT, minDisparity, maxDisparity, r, r, -1.0, -1, -1.0, GrayU8.class);
            }
            case 1: {
                this.changeGuiActive(true, true);
                return FactoryStereoDisparity.regionWta(DisparityAlgorithms.RECT, minDisparity, maxDisparity, r, r, this.control.pixelError, this.control.reverseTol, this.control.texture, GrayU8.class);
            }
            case 0: {
                this.changeGuiActive(true, true);
                return FactoryStereoDisparity.regionWta(DisparityAlgorithms.RECT_FIVE, minDisparity, maxDisparity, r, r, this.control.pixelError, this.control.reverseTol, this.control.texture, GrayU8.class);
            }
        }
        throw new RuntimeException("Unknown selection");
    }

    private void changeGuiActive(final boolean error, final boolean reverse) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                VisualizeStereoDisparity.this.control.setActiveGui(error, reverse);
            }
        });
    }

    @Override
    public synchronized void changeInputScale() {
        this.calib = new StereoParameters(this.origCalib);
        double scale = this.control.inputScale;
        PerspectiveOps.scaleIntrinsic(this.calib.left, scale);
        PerspectiveOps.scaleIntrinsic(this.calib.right, scale);
        int w = (int)((double)this.origLeft.getWidth() * scale);
        int h = (int)((double)this.origLeft.getHeight() * scale);
        this.colorLeft = new BufferedImage(w, h, 4);
        this.colorRight = new BufferedImage(w, h, 4);
        this.colorLeft.createGraphics().drawImage(this.origLeft, AffineTransform.getScaleInstance(scale, scale), null);
        this.colorRight.createGraphics().drawImage(this.origRight, AffineTransform.getScaleInstance(scale, scale), null);
        this.activeAlg = this.createAlg();
        this.inputLeft = GeneralizedImageOps.createSingleBand(this.activeAlg.getInputType(), w, h);
        this.inputRight = GeneralizedImageOps.createSingleBand(this.activeAlg.getInputType(), w, h);
        this.rectLeft = GeneralizedImageOps.createSingleBand(this.activeAlg.getInputType(), w, h);
        this.rectRight = GeneralizedImageOps.createSingleBand(this.activeAlg.getInputType(), w, h);
        ConvertBufferedImage.convertFrom(this.colorLeft, this.inputLeft, true);
        ConvertBufferedImage.convertFrom(this.colorRight, this.inputRight, true);
        this.rectifyInputImages();
        this.doRefreshAll();
    }

    public static void main(String[] args) {
        VisualizeStereoDisparity app = new VisualizeStereoDisparity();
        String dirCalib = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess/");
        String dirImgs = UtilIO.pathExample("stereo/");
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("Chair 1", dirCalib + "stereo.xml", dirImgs + "chair01_left.jpg", dirImgs + "chair01_right.jpg"));
        inputs.add(new PathLabel("Stones 1", dirCalib + "stereo.xml", dirImgs + "stones01_left.jpg", dirImgs + "stones01_right.jpg"));
        inputs.add(new PathLabel("Lantern 1", dirCalib + "stereo.xml", dirImgs + "lantern01_left.jpg", dirImgs + "lantern01_right.jpg"));
        inputs.add(new PathLabel("Wall 1", dirCalib + "stereo.xml", dirImgs + "wall01_left.jpg", dirImgs + "wall01_right.jpg"));
        inputs.add(new PathLabel("Garden 2", dirCalib + "stereo.xml", dirImgs + "garden02_left.jpg", dirImgs + "garden02_right.jpg"));
        inputs.add(new PathLabel("Sundial 1", dirCalib + "stereo.xml", dirImgs + "sundial01_left.jpg", dirImgs + "sundial01_right.jpg"));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Stereo Disparity", true);
    }

    public class ProcessThread
    extends ProgressMonitorThread {
        int state;

        public ProcessThread(JComponent owner) {
            super(new ProgressMonitor(owner, "Computing Disparity", "", 0, 100));
            this.state = 0;
        }

        @Override
        public void doRun() {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProcessThread.this.monitor.setProgress(ProcessThread.this.state);
                    ++ProcessThread.this.state;
                    ProcessThread.this.state %= 100;
                }
            });
        }
    }
}

