/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.disparity;

import boofcv.gui.StandardAlgConfigPanel;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DisparityDisplayPanel
extends StandardAlgConfigPanel
implements ChangeListener,
ItemListener {
    JSpinner inputScaleSpinner = new JSpinner(new SpinnerNumberModel(this.inputScale, 0.25, 1.0, 0.1));
    JComboBox viewSelector;
    JCheckBox invalidToggle;
    JSpinner minDisparitySpinner;
    JSpinner maxDisparitySpinner;
    JCheckBox subpixelToggle;
    JSpinner radiusSpinner;
    JSpinner errorSpinner;
    JSpinner reverseSpinner;
    JSpinner textureSpinner;
    int selectedView;
    boolean colorInvalid = false;
    boolean useSubpixel = true;
    int minDisparity = 0;
    int maxDisparity = 50;
    int pixelError = 30;
    int reverseTol = 6;
    int regionRadius = 3;
    double texture = 0.1;
    double inputScale = 0.5;
    Listener listener;

    public DisparityDisplayPanel() {
        this.inputScaleSpinner.addChangeListener(this);
        this.inputScaleSpinner.setMaximumSize(this.inputScaleSpinner.getPreferredSize());
        this.viewSelector = new JComboBox();
        this.viewSelector.addItem("Disparity");
        this.viewSelector.addItem("Left");
        this.viewSelector.addItem("Right");
        this.viewSelector.addItem("View 3D");
        this.viewSelector.addItemListener(this);
        this.viewSelector.setMaximumSize(this.viewSelector.getPreferredSize());
        this.invalidToggle = new JCheckBox("Color Invalid");
        this.invalidToggle.setSelected(this.colorInvalid);
        this.invalidToggle.addItemListener(this);
        this.invalidToggle.setMaximumSize(this.invalidToggle.getPreferredSize());
        this.minDisparitySpinner = new JSpinner(new SpinnerNumberModel(this.minDisparity, 0, 255, 5));
        this.minDisparitySpinner.addChangeListener(this);
        this.minDisparitySpinner.setMaximumSize(this.minDisparitySpinner.getPreferredSize());
        this.maxDisparitySpinner = new JSpinner(new SpinnerNumberModel(this.maxDisparity, 1, 255, 5));
        this.maxDisparitySpinner.addChangeListener(this);
        this.maxDisparitySpinner.setMaximumSize(this.maxDisparitySpinner.getPreferredSize());
        this.subpixelToggle = new JCheckBox("Subpixel");
        this.subpixelToggle.setSelected(this.useSubpixel);
        this.subpixelToggle.addItemListener(this);
        this.subpixelToggle.setMaximumSize(this.invalidToggle.getPreferredSize());
        this.radiusSpinner = new JSpinner(new SpinnerNumberModel(this.regionRadius, 1, 30, 1));
        this.radiusSpinner.addChangeListener(this);
        this.radiusSpinner.setMaximumSize(this.radiusSpinner.getPreferredSize());
        this.errorSpinner = new JSpinner(new SpinnerNumberModel(this.pixelError, -1, 80, 5));
        this.errorSpinner.addChangeListener(this);
        this.errorSpinner.setMaximumSize(this.errorSpinner.getPreferredSize());
        this.reverseSpinner = new JSpinner(new SpinnerNumberModel(this.reverseTol, -1, 50, 1));
        this.reverseSpinner.addChangeListener(this);
        this.reverseSpinner.setMaximumSize(this.reverseSpinner.getPreferredSize());
        this.textureSpinner = new JSpinner(new SpinnerNumberModel(this.texture, 0.0, 1.0, 0.05));
        this.textureSpinner.addChangeListener(this);
        this.textureSpinner.setPreferredSize(new Dimension(60, this.reverseSpinner.getPreferredSize().height));
        this.textureSpinner.setMaximumSize(this.textureSpinner.getPreferredSize());
        this.addLabeled(this.viewSelector, "View ", this);
        this.addAlignLeft(this.invalidToggle, this);
        this.addSeparator(100);
        this.addLabeled(this.minDisparitySpinner, "Min Disparity", this);
        this.addLabeled(this.maxDisparitySpinner, "Max Disparity", this);
        this.addAlignLeft(this.subpixelToggle, this);
        this.addLabeled(this.radiusSpinner, "Region Radius", this);
        this.addLabeled(this.errorSpinner, "Max Error", this);
        this.addLabeled(this.textureSpinner, "Texture", this);
        this.addLabeled(this.reverseSpinner, "Reverse", this);
        this.addSeparator(100);
        this.addLabeled(this.inputScaleSpinner, "Image Scale", this);
        this.addVerticalGlue(this);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.inputScaleSpinner) {
            this.inputScale = ((Number)this.inputScaleSpinner.getValue()).doubleValue();
            this.listener.changeInputScale();
            return;
        }
        if (e.getSource() == this.reverseSpinner) {
            this.reverseTol = ((Number)this.reverseSpinner.getValue()).intValue();
        } else if (e.getSource() == this.minDisparitySpinner) {
            this.minDisparity = ((Number)this.minDisparitySpinner.getValue()).intValue();
        } else if (e.getSource() == this.maxDisparitySpinner) {
            this.maxDisparity = ((Number)this.maxDisparitySpinner.getValue()).intValue();
        } else if (e.getSource() == this.errorSpinner) {
            this.pixelError = ((Number)this.errorSpinner.getValue()).intValue();
        } else if (e.getSource() == this.radiusSpinner) {
            this.regionRadius = ((Number)this.radiusSpinner.getValue()).intValue();
        } else if (e.getSource() == this.textureSpinner) {
            this.texture = ((Number)this.textureSpinner.getValue()).doubleValue();
        }
        if (this.minDisparity >= this.maxDisparity) {
            this.minDisparity = this.maxDisparity - 1;
            this.minDisparitySpinner.setValue(this.minDisparity);
        } else {
            this.listener.disparitySettingChange();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.listener == null) {
            return;
        }
        if (e.getSource() == this.viewSelector) {
            this.selectedView = this.viewSelector.getSelectedIndex();
            this.listener.disparityGuiChange();
        } else if (e.getSource() == this.invalidToggle) {
            this.colorInvalid = this.invalidToggle.isSelected();
            this.listener.disparityRender();
        } else if (e.getSource() == this.subpixelToggle) {
            this.useSubpixel = this.subpixelToggle.isSelected();
            this.listener.disparitySettingChange();
        }
    }

    public void setActiveGui(boolean error, boolean reverse) {
        this.setEnabled(12, error);
        this.setEnabled(13, reverse);
        this.setEnabled(14, error);
        this.setEnabled(15, reverse);
    }

    public void setListener(Listener listener) {
        this.listener = listener;
    }

    public int getReverseTol() {
        return this.reverseTol;
    }

    public int getMaxDisparity() {
        return this.maxDisparity;
    }

    public int getPixelError() {
        return this.pixelError;
    }

    public int getSelectedView() {
        return this.selectedView;
    }

    public int getRegionRadius() {
        return this.regionRadius;
    }

    public double getTexture() {
        return this.texture;
    }

    public static interface Listener {
        public void disparitySettingChange();

        public void disparityGuiChange();

        public void disparityRender();

        public void changeInputScale();
    }
}

