/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.feature.detect.line;

import boofcv.abst.feature.detect.line.DetectLineHoughFoot;
import boofcv.alg.filter.blur.GBlurImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.factory.feature.detect.line.ConfigHoughFoot;
import boofcv.factory.feature.detect.line.FactoryDetectLineAlgs;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.feature.ImageLinePanel;
import boofcv.gui.image.ShowImages;
import boofcv.gui.image.VisualizeImageData;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.image.UtilImageIO;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.ImageGray;
import java.awt.Dimension;
import java.awt.image.BufferedImage;

public class VisualizeHoughFoot<I extends ImageGray, D extends ImageGray> {
    Class<I> imageType;
    Class<D> derivType;

    public VisualizeHoughFoot(Class<I> imageType, Class<D> derivType) {
        this.imageType = imageType;
        this.derivType = derivType;
    }

    public void process(BufferedImage image) {
        I input = GeneralizedImageOps.createSingleBand(this.imageType, image.getWidth(), image.getHeight());
        I blur = GeneralizedImageOps.createSingleBand(this.imageType, image.getWidth(), image.getHeight());
        ConvertBufferedImage.convertFromSingle(image, input, this.imageType);
        GBlurImageOps.gaussian(input, blur, -1.0, 2, null);
        DetectLineHoughFoot<I, D> alg = FactoryDetectLineAlgs.houghFoot(new ConfigHoughFoot(6, 12, 5, 25.0f, 10), this.imageType, this.derivType);
        ImageLinePanel gui = new ImageLinePanel();
        gui.setBackground(image);
        gui.setLines(alg.detect(blur));
        gui.setPreferredSize(new Dimension(image.getWidth(), image.getHeight()));
        BufferedImage renderedTran = VisualizeImageData.grayMagnitude((ImageGray)alg.getTransform().getTransform(), null, -1.0);
        BufferedImage renderedBinary = VisualizeBinaryData.renderBinary(alg.getBinary(), false, null);
        ShowImages.showWindow(renderedBinary, "Detected Edges");
        ShowImages.showWindow(renderedTran, "Parameter Space");
        ShowImages.showWindow(gui, "Detected Lines");
    }

    public static void main(String[] args) {
        VisualizeHoughFoot<GrayF32, GrayF32> app = new VisualizeHoughFoot<GrayF32, GrayF32>(GrayF32.class, GrayF32.class);
        app.process(UtilImageIO.loadImage(UtilIO.pathExample("lines_indoors.jpg")));
    }
}

