/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.distort.FDistort;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.JPanel;

public class SubpixelGridTargetDisplay<T extends ImageGray>
extends JPanel {
    Class<T> imageType;
    T input;
    T transformed;
    BufferedImage workImage;
    double scale = 1.0;
    List<Point2D_I32> crudePoints;
    List<Point2D_F64> refinedPoints;
    boolean showCrude = true;
    boolean showRefined = true;

    public SubpixelGridTargetDisplay(Class<T> imageType) {
        this.imageType = imageType;
        this.transformed = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
    }

    public void setShow(boolean showCrude, boolean showRefined) {
        this.showCrude = showCrude;
        this.showRefined = showRefined;
    }

    public synchronized void setImage(T input) {
        this.input = input;
    }

    public synchronized void setScale(double scale) {
        if (scale < 0.1) {
            scale = 0.1;
        } else if (scale > 1000.0) {
            scale = 1000.0;
        }
        this.scale = scale;
        Dimension d = new Dimension((int)((double)((ImageGray)this.input).width * scale), (int)((double)((ImageGray)this.input).height * scale));
        this.setSize(d);
        this.setPreferredSize(d);
    }

    public Point2D_F64 getCenter() {
        Rectangle r = this.getVisibleRect();
        double x = (double)(r.x + r.width / 2) / this.scale;
        double y = (double)(r.y + r.height / 2) / this.scale;
        return new Point2D_F64(x, y);
    }

    private synchronized void render(Rectangle visibleRect) {
        if (visibleRect.width == 0 || visibleRect.height == 0) {
            return;
        }
        if (((ImageGray)this.transformed).width != visibleRect.width || ((ImageGray)this.transformed).height != visibleRect.height || this.workImage == null) {
            ((ImageGray)this.transformed).reshape(visibleRect.width, visibleRect.height);
            this.workImage = new BufferedImage(visibleRect.width, visibleRect.height, 1);
        }
        double x = -visibleRect.x;
        double y = -visibleRect.y;
        new FDistort((ImageBase)this.input, (ImageBase)this.transformed).interpNN().affine(this.scale, 0.0, 0.0, this.scale, x, y).apply();
        ConvertBufferedImage.convertTo(this.transformed, this.workImage, true);
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        int y;
        int x;
        super.paintComponent(g);
        if (this.input == null) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        Rectangle r = this.getVisibleRect();
        this.render(r);
        g2.drawImage((Image)this.workImage, r.x, r.y, null);
        if (this.showCrude && this.crudePoints != null) {
            for (Point2D_I32 point2D_I32 : this.crudePoints) {
                x = (int)Math.round((double)point2D_I32.x * this.scale + 0.5 * this.scale);
                y = (int)Math.round((double)point2D_I32.y * this.scale + 0.5 * this.scale);
                VisualizeFeatures.drawPoint(g2, x, y, Color.GRAY);
            }
        }
        if (this.showRefined && this.refinedPoints != null) {
            for (Point2D_F64 point2D_F64 : this.refinedPoints) {
                x = (int)Math.round(point2D_F64.x * this.scale + 0.5 * this.scale);
                y = (int)Math.round(point2D_F64.y * this.scale + 0.5 * this.scale);
                VisualizeFeatures.drawPoint(g2, x, y, Color.RED);
            }
        }
    }

    public double getScale() {
        return this.scale;
    }

    public void setCrudePoints(List<Point2D_I32> crudePoints) {
        this.crudePoints = crudePoints;
    }

    public void setRefinedPoints(List<Point2D_F64> refinedPoints) {
        this.refinedPoints = refinedPoints;
    }
}

