/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.fiducial.calib.CalibrationDetectorChessboard;
import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.geo.calibration.CalibrateStereoPlanar;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.alg.geo.PerspectiveOps;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.geo.rectify.RectifyCalibrated;
import boofcv.demonstrations.calibration.ParseStereoCalibrationConfig;
import boofcv.demonstrations.calibration.StereoPlanarPanel;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.gui.VisualizeApp;
import boofcv.gui.image.ShowImages;
import boofcv.io.MediaManager;
import boofcv.io.ProgressMonitorThread;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.io.wrapper.DefaultMediaManager;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.image.GrayF32;
import georegression.struct.se.Se3_F64;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.ejml.data.DenseMatrix64F;

public class CalibrateStereoPlanarGuiApp
extends JPanel
implements VisualizeApp {
    CalibrateStereoPlanar calibrator;
    StereoPlanarPanel gui = new StereoPlanarPanel();
    JPanel owner;
    List<String> leftImages;
    List<String> rightImages;
    MediaManager media = DefaultMediaManager.INSTANCE;

    public CalibrateStereoPlanarGuiApp() {
        this.setLayout(new BorderLayout());
        this.setPreferredSize(new Dimension(1500, 525));
        this.owner = this;
        this.add((Component)this.gui, "Center");
    }

    public void process(String outputFileName) {
        final ProcessThread monitor = new ProcessThread();
        monitor.start();
        this.calibrator.reset();
        int N = this.leftImages.size();
        for (int i = 0; i < N; ++i) {
            final BufferedImage leftOrig = this.media.openImage(this.leftImages.get(i));
            final BufferedImage rightOrig = this.media.openImage(this.rightImages.get(i));
            if (leftOrig != null && rightOrig != null) {
                GrayF32 rightInput;
                GrayF32 leftInput = ConvertBufferedImage.convertFrom(leftOrig, (GrayF32)null);
                if (this.calibrator.addPair(leftInput, rightInput = ConvertBufferedImage.convertFrom(rightOrig, (GrayF32)null))) {
                    final int number = i;
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            CalibrateStereoPlanarGuiApp.this.gui.addPair("Image " + number, leftOrig, rightOrig);
                            CalibrateStereoPlanarGuiApp.this.gui.repaint();
                            monitor.setMessage(0, "Image " + number);
                        }
                    });
                    continue;
                }
                System.out.println("Feature detection failed in:");
                System.out.println(this.leftImages.get(i) + " and/or " + this.rightImages.get(i));
                continue;
            }
            System.out.println("Failed to load left  = " + this.leftImages.get(i));
            System.out.println("Failed to load right = " + this.rightImages.get(i));
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrateStereoPlanarGuiApp.this.gui.setObservations(CalibrateStereoPlanarGuiApp.this.calibrator.getCalibLeft().getObservations(), CalibrateStereoPlanarGuiApp.this.calibrator.getCalibLeft().getErrors(), CalibrateStereoPlanarGuiApp.this.calibrator.getCalibRight().getObservations(), CalibrateStereoPlanarGuiApp.this.calibrator.getCalibRight().getErrors());
            }
        });
        this.gui.repaint();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                monitor.setMessage(1, "Estimating Parameters");
            }
        });
        StereoParameters param = this.calibrator.process();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrateStereoPlanarGuiApp.this.gui.setObservations(CalibrateStereoPlanarGuiApp.this.calibrator.getCalibLeft().getObservations(), CalibrateStereoPlanarGuiApp.this.calibrator.getCalibLeft().getErrors(), CalibrateStereoPlanarGuiApp.this.calibrator.getCalibRight().getObservations(), CalibrateStereoPlanarGuiApp.this.calibrator.getCalibRight().getErrors());
            }
        });
        this.gui.repaint();
        this.setRectification(param);
        monitor.stopThread();
        this.calibrator.printStatistics();
        param.print();
        if (outputFileName != null) {
            UtilIO.saveXML(param, outputFileName);
        }
    }

    private void setRectification(final StereoParameters param) {
        DenseMatrix64F K1 = PerspectiveOps.calibrationMatrix(param.getLeft(), null);
        DenseMatrix64F K2 = PerspectiveOps.calibrationMatrix(param.getRight(), null);
        RectifyCalibrated rectify = RectifyImageOps.createCalibrated();
        rectify.process(K1, new Se3_F64(), K2, param.getRightToLeft().invert(null));
        final DenseMatrix64F rect1 = rectify.getRect1();
        final DenseMatrix64F rect2 = rectify.getRect2();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CalibrateStereoPlanarGuiApp.this.gui.setRectification(param.getLeft(), rect1, param.getRight(), rect2);
            }
        });
        this.gui.repaint();
    }

    @Override
    public void setMediaManager(MediaManager manager) {
        this.media = manager;
    }

    public void configure(CalibrationDetector detector, int numRadial, boolean includeTangential, boolean assumeZeroSkew, List<String> leftImages, List<String> rightImages) {
        if (leftImages.size() != rightImages.size()) {
            throw new IllegalArgumentException("Number of left and right images must be the same");
        }
        this.calibrator = new CalibrateStereoPlanar(detector);
        this.calibrator.configure(assumeZeroSkew, numRadial, includeTangential);
        this.leftImages = leftImages;
        this.rightImages = rightImages;
    }

    @Override
    public void loadConfigurationFile(String fileName) {
        ParseStereoCalibrationConfig parser = new ParseStereoCalibrationConfig(this.media);
        if (parser.parse(fileName)) {
            this.configure(parser.detector, parser.numRadial, parser.includeTangential, parser.assumeZeroSkew, parser.getLeftImages(), parser.getRightImages());
        } else {
            System.err.println("Configuration failed");
        }
    }

    @Override
    public void loadInputData(String fileName) {
        new Thread(){

            @Override
            public void run() {
                CalibrateStereoPlanarGuiApp.this.process(null);
            }
        }.start();
    }

    @Override
    public boolean getHasProcessedImage() {
        return true;
    }

    public static void main(String[] args) {
        CalibrationDetectorChessboard detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(7, 5, 30.0));
        String directory = UtilIO.pathExample("calibration/stereo/Bumblebee2_Chess");
        List<String> leftImages = BoofMiscOps.directoryList(directory, "left");
        List<String> rightImages = BoofMiscOps.directoryList(directory, "right");
        Collections.sort(leftImages);
        Collections.sort(rightImages);
        CalibrateStereoPlanarGuiApp app = new CalibrateStereoPlanarGuiApp();
        app.configure(detector, 2, false, true, leftImages, rightImages);
        ShowImages.showWindow(app, "Planar Stereo Calibration", true);
        app.process("stereo.xml");
    }

    public class ProcessThread
    extends ProgressMonitorThread {
        public ProcessThread() {
            super(new ProgressMonitor(CalibrateStereoPlanarGuiApp.this.owner, "Computing Calibration", "", 0, 2));
        }

        public void setMessage(final int state, final String message) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProcessThread.this.monitor.setProgress(state);
                    ProcessThread.this.monitor.setNote(message);
                }
            });
        }

        @Override
        public void doRun() {
        }
    }
}

