/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.calibration;

import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.fiducial.calib.ConfigSquareGrid;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.factory.calib.FactoryCalibrationTarget;
import boofcv.io.MediaManager;
import boofcv.io.SimpleStringNumberReader;
import boofcv.io.wrapper.DefaultMediaManager;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;

public class BaseCalibrationConfig {
    MediaManager media = DefaultMediaManager.INSTANCE;
    public boolean assumeZeroSkew;
    public int numRadial;
    public boolean includeTangential;
    public CalibrationDetector detector;

    public BaseCalibrationConfig(MediaManager media) {
        this.media = media;
    }

    public BaseCalibrationConfig() {
    }

    protected void parseTarget(String where) throws FileNotFoundException {
        SimpleStringNumberReader reader = new SimpleStringNumberReader('#');
        Reader input = this.media.openFile(where);
        if (!reader.read(input)) {
            throw new RuntimeException("Parsing configuration failed");
        }
        if (reader.remainingTokens() < 7) {
            throw new RuntimeException("Not enough tokens in config file");
        }
        String type = reader.nextString();
        this.numRadial = (int)reader.nextDouble();
        this.includeTangential = Boolean.parseBoolean(reader.nextString());
        this.assumeZeroSkew = Boolean.parseBoolean(reader.nextString());
        int numCols = (int)reader.nextDouble();
        int numRows = (int)reader.nextDouble();
        double width = reader.nextDouble();
        if (type.compareToIgnoreCase("square") == 0) {
            double space = reader.nextDouble();
            this.detector = FactoryCalibrationTarget.detectorSquareGrid(new ConfigSquareGrid(numRows, numCols, width, space));
        } else if (type.compareToIgnoreCase("chess") == 0) {
            this.detector = FactoryCalibrationTarget.detectorChessboard(new ConfigChessboard(numRows, numCols, width));
        } else {
            throw new RuntimeException("Unknown type: " + type);
        }
        try {
            input.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public CalibrationDetector getDetector() {
        return this.detector;
    }
}

