/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.alg.filter.binary.GThresholdImageOps;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.demonstrations.binary.DemoThresholdingPanel;
import boofcv.gui.SelectInputPanel;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import boofcv.io.PathLabel;
import boofcv.io.UtilIO;
import boofcv.io.image.ConvertBufferedImage;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class DemoImageThresholdingApp<T extends ImageGray>
extends SelectInputPanel
implements DemoThresholdingPanel.Listener {
    Class<T> imageType;
    T imageInput;
    GrayU8 imageBinary = new GrayU8(1, 1);
    BufferedImage work;
    ImagePanel gui = new ImagePanel();
    DemoThresholdingPanel control = new DemoThresholdingPanel(100, false, 20, 1.0, this);
    boolean processedImage = false;
    int which = 0;

    public DemoImageThresholdingApp(Class<T> imageType) {
        this.imageType = imageType;
        this.imageInput = GeneralizedImageOps.createSingleBand(imageType, 1, 1);
        JPanel body = new JPanel();
        body.setLayout(new BorderLayout());
        body.add((Component)this.control, "West");
        body.add((Component)this.gui, "Center");
        this.setMainGUI(body);
    }

    protected void process() {
        int threshValue = this.control.getValueThreshold();
        boolean thresholdDown = this.control.getDirection();
        int threshRadius = this.control.getThreshRadius();
        double threshScale = this.control.getScale();
        switch (this.which) {
            case 0: {
                GThresholdImageOps.threshold(this.imageInput, this.imageBinary, threshValue, thresholdDown);
                break;
            }
            case 1: {
                threshValue = GThresholdImageOps.computeOtsu(this.imageInput, 0, 255);
                GThresholdImageOps.threshold(this.imageInput, this.imageBinary, threshValue, thresholdDown);
                break;
            }
            case 2: {
                threshValue = GThresholdImageOps.computeEntropy(this.imageInput, 0, 255);
                GThresholdImageOps.threshold(this.imageInput, this.imageBinary, threshValue, thresholdDown);
                break;
            }
            case 3: {
                GThresholdImageOps.localSquare(this.imageInput, this.imageBinary, threshRadius, threshScale, thresholdDown, null, null);
                break;
            }
            case 4: {
                GThresholdImageOps.localGaussian(this.imageInput, this.imageBinary, threshRadius, threshScale, thresholdDown, null, null);
                break;
            }
            case 5: {
                GThresholdImageOps.localSauvola(this.imageInput, this.imageBinary, threshRadius, 0.3f, thresholdDown);
                break;
            }
            case 6: {
                GThresholdImageOps.localBlockMinMax(this.imageInput, this.imageBinary, threshRadius * 2 + 1, threshScale, thresholdDown, 15.0);
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (DemoImageThresholdingApp.this.work == null || DemoImageThresholdingApp.this.work.getWidth() != ((ImageGray)DemoImageThresholdingApp.this.imageInput).width || DemoImageThresholdingApp.this.work.getHeight() != ((ImageGray)DemoImageThresholdingApp.this.imageInput).height) {
                    DemoImageThresholdingApp.this.work = new BufferedImage(((ImageGray)DemoImageThresholdingApp.this.imageInput).width, ((ImageGray)DemoImageThresholdingApp.this.imageInput).height, 4);
                }
                VisualizeBinaryData.renderBinary(DemoImageThresholdingApp.this.imageBinary, false, DemoImageThresholdingApp.this.work);
                DemoImageThresholdingApp.this.gui.setBufferedImage(DemoImageThresholdingApp.this.work);
                DemoImageThresholdingApp.this.gui.setPreferredSize(new Dimension(((ImageGray)DemoImageThresholdingApp.this.imageInput).width, ((ImageGray)DemoImageThresholdingApp.this.imageInput).height));
                DemoImageThresholdingApp.this.processedImage = true;
                DemoImageThresholdingApp.this.gui.repaint();
            }
        });
    }

    @Override
    public void changeInput(String name, int index) {
        BufferedImage image = this.media.openImage(((PathLabel)this.inputRefs.get(index)).getPath());
        if (image != null) {
            this.setInputImage(image);
            ((ImageGray)this.imageInput).reshape(image.getWidth(), image.getHeight());
            this.imageBinary.reshape(image.getWidth(), image.getHeight());
            ConvertBufferedImage.convertFrom(image, this.imageInput, true);
            this.process();
        }
    }

    @Override
    public void loadConfigurationFile(String fileName) {
    }

    @Override
    public boolean getHasProcessedImage() {
        return this.processedImage;
    }

    public static void main(String[] args) {
        DemoImageThresholdingApp<GrayF32> app = new DemoImageThresholdingApp<GrayF32>(GrayF32.class);
        ArrayList<PathLabel> inputs = new ArrayList<PathLabel>();
        inputs.add(new PathLabel("particles", UtilIO.pathExample("particles01.jpg")));
        inputs.add(new PathLabel("shapes", UtilIO.pathExample("shapes/shapes01.png")));
        inputs.add(new PathLabel("stained", UtilIO.pathExample("segment/stained_handwriting.jpg")));
        app.setInputList(inputs);
        while (!app.getHasProcessedImage()) {
            Thread.yield();
        }
        ShowImages.showWindow(app, "Thresholding Demo", true);
        System.out.println("Done");
    }

    @Override
    public void changeSelected(int which) {
        this.which = which;
        new Thread(){

            @Override
            public void run() {
                DemoImageThresholdingApp.this.process();
            }
        }.start();
    }

    @Override
    public void settingChanged() {
        new Thread(){

            @Override
            public void run() {
                DemoImageThresholdingApp.this.process();
            }
        }.start();
    }
}

