/*
 * Decompiled with CFR 0.152.
 */
package boofcv.demonstrations.binary;

import boofcv.demonstrations.binary.VisualizeBinaryContourApp;
import boofcv.demonstrations.shapes.ThresholdControlPanel;
import boofcv.gui.StandardAlgConfigPanel;
import boofcv.struct.ConnectRule;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ContourControlPanel
extends StandardAlgConfigPanel
implements ActionListener,
ChangeListener {
    VisualizeBinaryContourApp<?> owner;
    ThresholdControlPanel threshold;
    JComboBox imageView;
    JComboBox connectCombo;
    JSpinner selectZoom;
    private ConnectRule connectRule = ConnectRule.FOUR;
    public int selectedView;
    public double zoom = 1.0;

    public ContourControlPanel(VisualizeBinaryContourApp<?> owner) {
        this.owner = owner;
        this.imageView = new JComboBox();
        this.imageView.addItem("Input");
        this.imageView.addItem("Binary");
        this.imageView.addItem("Black");
        this.imageView.addActionListener(this);
        this.imageView.setMaximumSize(this.imageView.getPreferredSize());
        this.connectCombo = new JComboBox();
        this.connectCombo.addItem("4-Connect");
        this.connectCombo.addItem("8-Connect");
        this.connectCombo.addActionListener(this);
        this.connectCombo.setMaximumSize(this.connectCombo.getPreferredSize());
        this.selectZoom = new JSpinner(new SpinnerNumberModel(this.zoom, 0.1, 50.0, 1.0));
        this.selectZoom.addChangeListener(this);
        this.selectZoom.setMaximumSize(this.selectZoom.getPreferredSize());
        this.threshold = new ThresholdControlPanel(owner);
        this.addLabeled(this.imageView, "View", this);
        this.addLabeled(this.selectZoom, "Zoom", this);
        this.addLabeled(this.connectCombo, "Connect", this);
        this.add(this.threshold);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.connectCombo) {
            this.connectRule = ConnectRule.values()[this.connectCombo.getSelectedIndex()];
            this.owner.contourAlgUpdated();
        } else if (e.getSource() == this.imageView) {
            this.selectedView = this.imageView.getSelectedIndex();
            this.owner.viewUpdated();
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.selectZoom) {
            this.zoom = ((Number)this.selectZoom.getValue()).doubleValue();
            this.owner.viewUpdated();
        }
    }

    public ThresholdControlPanel getThreshold() {
        return this.threshold;
    }

    public ConnectRule getConnectRule() {
        return this.connectRule;
    }
}

