/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.orientation.OrientationAverage;
import boofcv.struct.image.GrayS32;

public class ImplOrientationAverage_S32
extends OrientationAverage<GrayS32> {
    public ImplOrientationAverage_S32(double objectToSample, boolean weighted) {
        super(objectToSample, weighted);
    }

    @Override
    public Class<GrayS32> getImageType() {
        return GrayS32.class;
    }

    @Override
    protected double computeUnweightedScore() {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayS32)this.derivX).startIndex + ((GrayS32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayS32)this.derivY).startIndex + ((GrayS32)this.derivY).stride * y + this.rect.x0;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                sumX += (float)((GrayS32)this.derivX).data[indexX];
                sumY += (float)((GrayS32)this.derivY).data[indexY];
                ++x;
                ++indexX;
                ++indexY;
            }
        }
        return Math.atan2(sumY, sumX);
    }

    @Override
    protected double computeWeightedScore(int c_x, int c_y) {
        float sumX = 0.0f;
        float sumY = 0.0f;
        for (int y = this.rect.y0; y < this.rect.y1; ++y) {
            int indexX = ((GrayS32)this.derivX).startIndex + ((GrayS32)this.derivX).stride * y + this.rect.x0;
            int indexY = ((GrayS32)this.derivY).startIndex + ((GrayS32)this.derivY).stride * y + this.rect.x0;
            int indexW = (y - c_y + this.radiusScale) * this.weights.width + this.rect.x0 - c_x + this.radiusScale;
            int x = this.rect.x0;
            while (x < this.rect.x1) {
                float w = this.weights.data[indexW];
                sumX += w * (float)((GrayS32)this.derivX).data[indexX];
                sumY += w * (float)((GrayS32)this.derivY).data[indexY];
                ++x;
                ++indexX;
                ++indexY;
                ++indexW;
            }
        }
        return Math.atan2(sumY, sumX);
    }
}

