/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.orientation.impl;

import boofcv.alg.feature.describe.SurfDescribeOps;
import boofcv.alg.feature.orientation.OrientationIntegralBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.sparse.GradientValue;
import boofcv.struct.sparse.SparseGradientSafe;
import boofcv.struct.sparse.SparseImageGradient;

public class ImplOrientationAverageGradientIntegral<T extends ImageGray, G extends GradientValue>
extends OrientationIntegralBase<T, G> {
    public ImplOrientationAverageGradientIntegral(double radiusToScale, int sampleRadius, double period, int sampleWidth, double weightSigma, Class<T> imageType) {
        super(radiusToScale, sampleRadius, period, sampleWidth, weightSigma, true, imageType);
    }

    @Override
    public double compute(double c_x, double c_y) {
        double period = this.scale * this.period;
        double tl_x = c_x - (double)this.sampleRadius * period;
        double tl_y = c_y - (double)this.sampleRadius * period;
        SparseImageGradient g = !SurfDescribeOps.isInside(this.ii.width, this.ii.height, tl_x, tl_y, (double)this.sampleWidth * period, (double)this.kernelWidth * this.scale) ? new SparseGradientSafe(this.g) : this.g;
        if (this.weights == null) {
            return this.computeUnweighted(tl_x, tl_y, period, g);
        }
        return this.computeWeighted(tl_x, tl_y, period, g);
    }

    protected double computeUnweighted(double tl_x, double tl_y, double samplePeriod, SparseImageGradient<T, G> g) {
        tl_x += 0.5;
        tl_y += 0.5;
        double Dx = 0.0;
        double Dy = 0.0;
        for (int y = 0; y < this.sampleWidth; ++y) {
            int pixelsY = (int)(tl_y + (double)y * samplePeriod);
            for (int x = 0; x < this.sampleWidth; ++x) {
                int pixelsX = (int)(tl_x + (double)x * samplePeriod);
                G v = g.compute(pixelsX, pixelsY);
                Dx += v.getX();
                Dy += v.getY();
            }
        }
        return Math.atan2(Dy, Dx);
    }

    protected double computeWeighted(double tl_x, double tl_y, double samplePeriod, SparseImageGradient<T, G> g) {
        tl_x += 0.5;
        tl_y += 0.5;
        double Dx = 0.0;
        double Dy = 0.0;
        int i = 0;
        for (int y = 0; y < this.sampleWidth; ++y) {
            int pixelsY = (int)(tl_y + (double)y * samplePeriod);
            int x = 0;
            while (x < this.sampleWidth) {
                int pixelsX = (int)(tl_x + (double)x * samplePeriod);
                double w = this.weights.data[i];
                G v = g.compute(pixelsX, pixelsY);
                Dx += w * v.getX();
                Dy += w * v.getY();
                ++x;
                ++i;
            }
        }
        return Math.atan2(Dy, Dx);
    }
}

