/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.alg.feature.detect.intensity.impl.ImplSsdCornerBase;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;

public abstract class ImplSsdCorner_S16
extends ImplSsdCornerBase<GrayS16, GrayS32> {
    private int[] tempXX = new int[1];
    private int[] tempXY = new int[1];
    private int[] tempYY = new int[1];
    protected int totalXX;
    protected int totalYY;
    protected int totalXY;

    public ImplSsdCorner_S16(int windowRadius) {
        super(windowRadius, GrayS32.class);
    }

    @Override
    public void setImageShape(int imageWidth, int imageHeight) {
        super.setImageShape(imageWidth, imageHeight);
        if (this.tempXX.length < imageWidth) {
            this.tempXX = new int[imageWidth];
            this.tempXY = new int[imageWidth];
            this.tempYY = new int[imageWidth];
        }
    }

    @Override
    protected void horizontal() {
        short[] dataX = ((GrayS16)this.derivX).data;
        short[] dataY = ((GrayS16)this.derivY).data;
        int[] hXX = ((GrayS32)this.horizXX).data;
        int[] hXY = ((GrayS32)this.horizXY).data;
        int[] hYY = ((GrayS32)this.horizYY).data;
        int imgHeight = ((GrayS16)this.derivX).getHeight();
        int imgWidth = ((GrayS16)this.derivX).getWidth();
        int windowWidth = this.radius * 2 + 1;
        int radp1 = this.radius + 1;
        for (int row = 0; row < imgHeight; ++row) {
            short dy;
            short dx;
            int pix;
            int end = pix + windowWidth;
            int totalXX = 0;
            int totalXY = 0;
            int totalYY = 0;
            int indexX = ((GrayS16)this.derivX).startIndex + row * ((GrayS16)this.derivX).stride;
            int indexY = ((GrayS16)this.derivY).startIndex + row * ((GrayS16)this.derivY).stride;
            for (pix = row * imgWidth; pix < end; ++pix) {
                dx = dataX[indexX++];
                dy = dataY[indexY++];
                totalXX += dx * dx;
                totalXY += dx * dy;
                totalYY += dy * dy;
            }
            hXX[pix - radp1] = totalXX;
            hXY[pix - radp1] = totalXY;
            hYY[pix - radp1] = totalYY;
            end = row * imgWidth + imgWidth;
            while (pix < end) {
                dx = dataX[indexX - windowWidth];
                dy = dataY[indexY - windowWidth];
                totalXX -= dx * dx;
                totalXY -= dx * dy;
                totalYY -= dy * dy;
                dx = dataX[indexX];
                dy = dataY[indexY];
                hXX[pix - this.radius] = totalXX += dx * dx;
                hXY[pix - this.radius] = totalXY += dx * dy;
                hYY[pix - this.radius] = totalYY += dy * dy;
                ++pix;
                ++indexX;
                ++indexY;
            }
        }
    }

    @Override
    protected void vertical(GrayF32 intensity) {
        int srcIndex;
        int destIndex;
        int[] hXX = ((GrayS32)this.horizXX).data;
        int[] hXY = ((GrayS32)this.horizXY).data;
        int[] hYY = ((GrayS32)this.horizYY).data;
        float[] inten = intensity.data;
        int imgHeight = ((GrayS32)this.horizXX).getHeight();
        int imgWidth = ((GrayS32)this.horizXX).getWidth();
        int kernelWidth = this.radius * 2 + 1;
        int startX = this.radius;
        int endX = imgWidth - this.radius;
        int backStep = kernelWidth * imgWidth;
        this.x = startX;
        while (this.x < endX) {
            destIndex = imgWidth * this.radius + this.x;
            this.totalYY = 0;
            this.totalXY = 0;
            this.totalXX = 0;
            int indexEnd = srcIndex + imgWidth * kernelWidth;
            for (srcIndex = this.x; srcIndex < indexEnd; srcIndex += imgWidth) {
                this.totalXX += hXX[srcIndex];
                this.totalXY += hXY[srcIndex];
                this.totalYY += hYY[srcIndex];
            }
            this.tempXX[this.x] = this.totalXX;
            this.tempXY[this.x] = this.totalXY;
            this.tempYY[this.x] = this.totalYY;
            this.y = this.radius;
            inten[destIndex] = this.computeIntensity();
            destIndex += imgWidth;
            ++this.y;
            ++this.x;
        }
        this.y = this.radius + 1;
        while (this.y < imgHeight - this.radius) {
            srcIndex = (this.y + this.radius) * imgWidth + startX;
            destIndex = this.y * imgWidth + startX;
            this.x = startX;
            while (this.x < endX) {
                this.totalXX = this.tempXX[this.x] - hXX[srcIndex - backStep];
                this.tempXX[this.x] = this.totalXX += hXX[srcIndex];
                this.totalXY = this.tempXY[this.x] - hXY[srcIndex - backStep];
                this.tempXY[this.x] = this.totalXY += hXY[srcIndex];
                this.totalYY = this.tempYY[this.x] - hYY[srcIndex - backStep];
                this.tempYY[this.x] = this.totalYY += hYY[srcIndex];
                inten[destIndex] = this.computeIntensity();
                ++this.x;
                ++srcIndex;
                ++destIndex;
            }
            ++this.y;
        }
    }
}

