/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.extract;

import boofcv.struct.QueueCorner;
import boofcv.struct.image.GrayF32;

public class ThresholdCornerExtractor {
    private float thresh;

    public ThresholdCornerExtractor(float thresh) {
        this.thresh = thresh;
    }

    public ThresholdCornerExtractor() {
    }

    public void process(GrayF32 intensity, QueueCorner corners) {
        corners.reset();
        float[] data = intensity.data;
        for (int y = 0; y < intensity.height; ++y) {
            int startIndex = intensity.startIndex + y * intensity.stride;
            int endIndex = startIndex + intensity.width;
            for (int index = startIndex; index < endIndex; ++index) {
                if (!(data[index] > this.thresh)) continue;
                int x = index - startIndex;
                corners.add(x, y);
            }
        }
    }

    public float getThreshold() {
        return this.thresh;
    }

    public void setThreshold(float threshold) {
        this.thresh = threshold;
    }
}

