/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge;

import boofcv.abst.filter.blur.BlurFilter;
import boofcv.abst.filter.derivative.ImageGradient;
import boofcv.alg.feature.detect.edge.CannyEdge;
import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.misc.ImageStatistics;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageGray;

public class CannyEdgeDynamic<T extends ImageGray, D extends ImageGray>
extends CannyEdge<T, D> {
    public CannyEdgeDynamic(BlurFilter<T> blur, ImageGradient<T, D> gradient, boolean saveTrace) {
        super(blur, gradient, saveTrace);
    }

    @Override
    protected void performThresholding(float threshLow, float threshHigh, GrayU8 output) {
        if (threshLow < 0.0f || threshLow > 1.0f || threshHigh < 0.0f || threshHigh > 1.0f) {
            throw new IllegalArgumentException("Relative thresholds must be from 0 to 1, inclusive.");
        }
        float max = ImageStatistics.max(this.suppressed);
        threshLow = max * threshLow;
        threshHigh = max * threshHigh;
        if (threshLow <= 0.0f && threshHigh <= 0.0f) {
            if (this.hysteresisPts != null) {
                this.hysteresisPts.getContours().clear();
            }
            if (output != null) {
                ImageMiscOps.fill(output, 0);
            }
        } else {
            super.performThresholding(threshLow, threshHigh, output);
        }
    }
}

