/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort.radtan;

import boofcv.alg.distort.radtan.RadialTangential_F32;
import boofcv.struct.distort.PointTransform_F32;
import georegression.struct.point.Point2D_F32;

public class RemoveRadialNtoN_F32
implements PointTransform_F32 {
    protected RadialTangential_F32 params;
    protected float sum;
    protected float tx;
    protected float ty;
    private float tol = 1.0E-5f;

    public RemoveRadialNtoN_F32() {
    }

    public RemoveRadialNtoN_F32(float tol) {
        this.tol = tol;
    }

    public void setTolerance(float tol) {
        this.tol = tol;
    }

    public RemoveRadialNtoN_F32 setDistortion(float[] radial, float t1, float t2) {
        this.params = new RadialTangential_F32(radial, t1, t2);
        return this;
    }

    public RemoveRadialNtoN_F32 setDistortion(double[] radial, double t1, double t2) {
        this.params = new RadialTangential_F32().set(radial, t1, t2);
        return this;
    }

    @Override
    public void compute(float x, float y, Point2D_F32 out) {
        float[] radial = this.params.radial;
        float t1 = this.params.t1;
        float t2 = this.params.t2;
        float origX = x;
        float origY = y;
        float prevSum = 0.0f;
        for (int iter = 0; iter < 20; ++iter) {
            float r2;
            float ri2 = r2 = x * x + y * y;
            this.sum = 0.0f;
            for (int i = 0; i < radial.length; ++i) {
                this.sum += radial[i] * ri2;
                ri2 *= r2;
            }
            this.tx = 2.0f * t1 * x * y + t2 * (r2 + 2.0f * x * x);
            this.ty = t1 * (r2 + 2.0f * y * y) + 2.0f * t2 * x * y;
            x = (origX - this.tx) / (1.0f + this.sum);
            y = (origY - this.ty) / (1.0f + this.sum);
            if (Math.abs(prevSum - this.sum) <= this.tol) break;
            prevSum = this.sum;
        }
        out.set(x, y);
    }
}

