/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.shape.ConfigPolygonDetector;
import boofcv.factory.shape.ConfigRefinePolygonCornersToImage;
import boofcv.factory.shape.ConfigRefinePolygonLineToImage;
import boofcv.struct.Configuration;

public class ConfigChessboard
implements Configuration {
    public int numRows = -1;
    public int numCols = -1;
    public double maximumCornerDistance = 8.0;
    public ConfigThreshold thresholding = new ConfigThresholdBlockMinMax(10, 35.0, true);
    public ConfigPolygonDetector square = new ConfigPolygonDetector(true, 3, 8);
    public boolean refineWithCorners = false;
    public ConfigRefinePolygonLineToImage configRefineLines = new ConfigRefinePolygonLineToImage();
    public ConfigRefinePolygonCornersToImage configRefineCorners = new ConfigRefinePolygonCornersToImage();
    public double squareWidth;

    public ConfigChessboard(int numRows, int numCols, double squareWidth) {
        this.thresholding.scale = 0.9;
        this.square.contour2Poly_splitFraction = 0.1;
        this.square.contour2Poly_minimumSideFraction = 0.025;
        this.square.minContourImageWidthFraction = 5.0E-4;
        this.square.canTouchBorder = true;
        this.configRefineCorners.cornerOffset = 1.0;
        this.configRefineCorners.lineSamples = 15;
        this.configRefineCorners.convergeTolPixels = 0.2;
        this.configRefineCorners.maxIterations = 5;
        this.configRefineLines.cornerOffset = 1.0;
        this.configRefineLines.lineSamples = 15;
        this.configRefineLines.convergeTolPixels = 0.2;
        this.configRefineLines.maxIterations = 5;
        this.numRows = numRows;
        this.numCols = numCols;
        this.squareWidth = squareWidth;
    }

    @Override
    public void checkValidity() {
        if (this.numCols <= 0 || this.numRows <= 0) {
            throw new IllegalArgumentException("Must specify then number of rows and columns in the target");
        }
    }
}

