/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.abst.fiducial.calib.ConfigChessboard;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.abst.geo.calibration.CalibrationDetector;
import boofcv.alg.fiducial.calib.chess.DetectChessboardFiducial;
import boofcv.alg.geo.calibration.CalibrationObservation;
import boofcv.alg.shapes.polygon.BinaryPolygonDetector;
import boofcv.alg.shapes.polygon.RefineBinaryPolygon;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.factory.shape.FactoryShapeDetector;
import boofcv.struct.image.GrayF32;
import georegression.struct.point.Point2D_F64;
import java.util.ArrayList;
import java.util.List;

public class CalibrationDetectorChessboard
implements CalibrationDetector {
    DetectChessboardFiducial<GrayF32> alg;
    List<Point2D_F64> layoutPoints;
    CalibrationObservation detected;

    public CalibrationDetectorChessboard(ConfigChessboard config) {
        RefineBinaryPolygon<GrayF32> refineLine = FactoryShapeDetector.refinePolygon(config.configRefineLines, GrayF32.class);
        RefineBinaryPolygon<GrayF32> refineCorner = config.refineWithCorners ? FactoryShapeDetector.refinePolygon(config.configRefineLines, GrayF32.class) : null;
        config.square.refine = null;
        BinaryPolygonDetector<GrayF32> detectorSquare = FactoryShapeDetector.polygon(config.square, GrayF32.class);
        InputToBinary<GrayF32> inputToBinary = FactoryThresholdBinary.threshold(config.thresholding, GrayF32.class);
        this.alg = new DetectChessboardFiducial<GrayF32>(config.numRows, config.numCols, config.maximumCornerDistance, detectorSquare, refineLine, refineCorner, inputToBinary);
        this.layoutPoints = CalibrationDetectorChessboard.gridChess(config.numRows, config.numCols, config.squareWidth);
    }

    @Override
    public boolean process(GrayF32 input) {
        if (this.alg.process(input)) {
            this.detected = new CalibrationObservation();
            List<Point2D_F64> found = this.alg.getCalibrationPoints();
            for (int i = 0; i < found.size(); ++i) {
                this.detected.add(found.get(i), i);
            }
            return true;
        }
        return false;
    }

    @Override
    public CalibrationObservation getDetectedPoints() {
        return this.detected;
    }

    @Override
    public List<Point2D_F64> getLayout() {
        return this.layoutPoints;
    }

    public int getGridRows() {
        return this.alg.getRows();
    }

    public int getGridColumns() {
        return this.alg.getColumns();
    }

    public DetectChessboardFiducial<GrayF32> getAlgorithm() {
        return this.alg;
    }

    public static List<Point2D_F64> gridChess(int numRows, int numCols, double squareWidth) {
        ArrayList<Point2D_F64> all = new ArrayList<Point2D_F64>();
        double startX = -((double)(--numCols - 1) * squareWidth) / 2.0;
        double startY = -((double)(--numRows - 1) * squareWidth) / 2.0;
        for (int i = numRows - 1; i >= 0; --i) {
            double y = startY + (double)i * squareWidth;
            for (int j = 0; j < numCols; ++j) {
                double x = startX + (double)j * squareWidth;
                all.add(new Point2D_F64(x, y));
            }
        }
        return all;
    }
}

