/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.stochprocess;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.stochprocess.BrownianMotionBridge;
import umontreal.iro.lecuyer.stochprocess.BrownianMotionPCA;
import umontreal.iro.lecuyer.stochprocess.GammaProcessPCA;

public class GammaProcessPCABridge
extends GammaProcessPCA {
    protected BrownianMotionBridge BMBridge;
    protected double mu2OverNu;
    protected double mu2dTOverNu;
    protected double[] bMu2dtOverNuL;
    protected double[] bMu2dtOverNuR;
    protected int[] wIndexList;

    public GammaProcessPCABridge(double s0, double mu, double nu, RandomStream stream) {
        super(s0, mu, nu, stream);
        this.BMBridge = new BrownianMotionBridge(0.0, 0.0, Math.sqrt(nu), stream);
    }

    @Override
    public double[] generatePath(double[] uniform01) {
        int oldIndexR;
        int newIndex;
        int oldIndexL;
        double[] uniformsV = new double[this.d + 1];
        double[] BMPCApath = this.BMPCA.generatePath(uniform01);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            oldIndexL = this.BMBridge.wIndexList[j];
            newIndex = this.BMBridge.wIndexList[j + 1];
            oldIndexR = this.BMBridge.wIndexList[j + 2];
            double temp = BMPCApath[newIndex] - BMPCApath[oldIndexL];
            temp -= (BMPCApath[oldIndexR] - BMPCApath[oldIndexL]) * this.BMBridge.wMuDt[newIndex];
            uniformsV[newIndex] = NormalDist.cdf01(temp /= this.BMBridge.wSqrtDt[newIndex]);
        }
        double dT = this.BMPCA.t[this.d] - this.BMPCA.t[0];
        uniformsV[this.d] = NormalDist.cdf01((BMPCApath[this.d] - BMPCApath[0] - this.BMPCA.mu * dT) / (this.BMPCA.sigma * Math.sqrt(dT)));
        this.path[0] = this.x0;
        this.path[this.d] = this.x0 + GammaDist.inverseF(this.mu2dTOverNu, this.muOverNu, 10, uniformsV[this.d]);
        for (int j = 0; j < 3 * (this.d - 1); j += 3) {
            oldIndexL = this.wIndexList[j];
            newIndex = this.wIndexList[j + 1];
            oldIndexR = this.wIndexList[j + 2];
            double y = BetaDist.inverseF(this.bMu2dtOverNuL[newIndex], this.bMu2dtOverNuR[newIndex], 8, uniformsV[newIndex]);
            this.path[newIndex] = this.path[oldIndexL] + (this.path[oldIndexR] - this.path[oldIndexL]) * y;
        }
        this.observationIndex = this.d;
        this.observationCounter = this.d;
        return this.path;
    }

    @Override
    public double[] generatePath() {
        double[] u = new double[this.d];
        for (int i = 0; i < this.d; ++i) {
            u[i] = this.stream.nextDouble();
        }
        return this.generatePath(u);
    }

    @Override
    public void setParams(double s0, double mu, double nu) {
        super.setParams(s0, mu, nu);
        this.BMBridge.setParams(0.0, 0.0, Math.sqrt(nu));
        this.BMPCA.setParams(0.0, 0.0, Math.sqrt(nu));
    }

    @Override
    public void setObservationTimes(double[] t, int d) {
        super.setObservationTimes(t, d);
        this.BMBridge.setObservationTimes(t, d);
    }

    @Override
    public BrownianMotionPCA getBMPCA() {
        return this.BMPCA;
    }

    @Override
    protected void init() {
        super.init();
        if (this.observationTimesSet) {
            this.bMu2dtOverNuL = new double[this.d + 1];
            this.bMu2dtOverNuR = new double[this.d + 1];
            this.wIndexList = new int[3 * this.d];
            int[] ptIndex = new int[this.d + 1];
            int indexCounter = 0;
            ptIndex[0] = 0;
            ptIndex[1] = this.d;
            this.mu2OverNu = this.mu * this.mu / this.nu;
            this.mu2dTOverNu = this.mu2OverNu * (this.t[this.d] - this.t[0]);
            for (int powOfTwo = 1; powOfTwo <= this.d / 2; powOfTwo *= 2) {
                int j;
                for (j = powOfTwo; j >= 1; --j) {
                    ptIndex[2 * j] = ptIndex[j];
                }
                for (j = 1; j <= powOfTwo; ++j) {
                    int oldLeft = 2 * j - 2;
                    int oldRight = 2 * j;
                    int newIndex = (int)(0.5 * (double)(ptIndex[oldLeft] + ptIndex[oldRight]));
                    this.bMu2dtOverNuL[newIndex] = this.mu * this.mu * (this.t[newIndex] - this.t[ptIndex[oldLeft]]) / this.nu;
                    this.bMu2dtOverNuR[newIndex] = this.mu * this.mu * (this.t[ptIndex[oldRight]] - this.t[newIndex]) / this.nu;
                    ptIndex[oldLeft + 1] = newIndex;
                    this.wIndexList[indexCounter] = ptIndex[oldLeft];
                    this.wIndexList[indexCounter + 1] = newIndex;
                    this.wIndexList[indexCounter + 2] = ptIndex[oldRight];
                    indexCounter += 3;
                }
            }
            for (int k = 1; k < this.d; ++k) {
                if (ptIndex[k - 1] + 1 >= ptIndex[k]) continue;
                this.bMu2dtOverNuL[ptIndex[k - 1] + 1] = this.mu * this.mu * (this.t[ptIndex[k - 1] + 1] - this.t[ptIndex[k - 1]]) / this.nu;
                this.bMu2dtOverNuR[ptIndex[k - 1] + 1] = this.mu * this.mu * (this.t[ptIndex[k]] - this.t[ptIndex[k - 1] + 1]) / this.nu;
                this.wIndexList[indexCounter] = ptIndex[k] - 2;
                this.wIndexList[indexCounter + 1] = ptIndex[k] - 1;
                this.wIndexList[indexCounter + 2] = ptIndex[k];
                indexCounter += 3;
            }
        }
    }
}

