/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.BetaSymmetricalDist;
import umontreal.iro.lecuyer.randvar.BetaSymmetricalGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class BetaSymmetricalBestGen
extends BetaSymmetricalGen {
    private RandomStream stream2;
    private RandomStream stream3;
    private double afactor;
    private static final double TWOPI = Math.PI * 2;

    public BetaSymmetricalBestGen(RandomStream s1, RandomStream s2, RandomStream s3, double alpha) {
        super(s1, null);
        this.stream2 = s2;
        this.stream3 = s3;
        this.afactor = 1.0 / alpha;
        this.setParams(alpha, alpha, 0.0, 1.0);
    }

    public BetaSymmetricalBestGen(RandomStream s1, double alpha) {
        this(s1, s1, s1, alpha);
    }

    public BetaSymmetricalBestGen(RandomStream s1, RandomStream s2, RandomStream s3, BetaSymmetricalDist dist) {
        super(s1, dist);
        this.stream2 = s2;
        this.stream3 = s3;
        this.afactor = 1.0 / dist.getAlpha();
        if (dist != null) {
            this.setParams(dist.getAlpha(), dist.getAlpha(), dist.getA(), dist.getB());
        }
    }

    public BetaSymmetricalBestGen(RandomStream s1, BetaSymmetricalDist dist) {
        this(s1, s1, s1, dist);
    }

    public static double nextDouble(RandomStream s1, RandomStream s2, RandomStream s3, double alpha) {
        double cos = Math.cos(Math.PI * 2 * s2.nextDouble());
        double temp = 1.0 / Math.pow(s1.nextDouble(), 1.0 / alpha) - 1.0;
        double v = Math.sqrt(1.0 + 1.0 / (temp * cos * cos));
        double S = s3.nextDouble();
        if (S < 0.5) {
            return 0.5 - 0.5 / v;
        }
        return 0.5 + 0.5 / v;
    }

    public static double nextDouble(RandomStream s, double alpha) {
        return BetaSymmetricalBestGen.nextDouble(s, s, s, alpha);
    }

    @Override
    public double nextDouble() {
        double cos = Math.cos(Math.PI * 2 * this.stream2.nextDouble());
        double temp = 1.0 / Math.pow(this.stream.nextDouble(), this.afactor) - 1.0;
        double v = Math.sqrt(1.0 + 1.0 / (temp * cos * cos));
        double S = this.stream3.nextDouble();
        if (S < 0.5) {
            return 0.5 - 0.5 / v;
        }
        return 0.5 + 0.5 / v;
    }

    public RandomStream getStream2() {
        return this.stream2;
    }

    public RandomStream getStream3() {
        return this.stream3;
    }
}

