/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.util.RootFinder;

public class GumbelDist
extends ContinuousDistribution {
    private double delta;
    private double beta;

    public GumbelDist() {
        this.setParams(1.0, 0.0);
    }

    public GumbelDist(double beta, double delta) {
        this.setParams(beta, delta);
    }

    @Override
    public double density(double x) {
        return GumbelDist.density(this.beta, this.delta, x);
    }

    @Override
    public double cdf(double x) {
        return GumbelDist.cdf(this.beta, this.delta, x);
    }

    @Override
    public double barF(double x) {
        return GumbelDist.barF(this.beta, this.delta, x);
    }

    @Override
    public double inverseF(double u) {
        return GumbelDist.inverseF(this.beta, this.delta, u);
    }

    @Override
    public double getMean() {
        return GumbelDist.getMean(this.beta, this.delta);
    }

    @Override
    public double getVariance() {
        return GumbelDist.getVariance(this.beta, this.delta);
    }

    @Override
    public double getStandardDeviation() {
        return GumbelDist.getStandardDeviation(this.beta, this.delta);
    }

    public static double density(double beta, double delta, double x) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        double z = (x - delta) / beta;
        if (z <= -10.0) {
            return 0.0;
        }
        double t = Math.exp(-z);
        return t * Math.exp(-t) / Math.abs(beta);
    }

    public static double cdf(double beta, double delta, double x) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        double z = (x - delta) / beta;
        if (beta > 0.0) {
            if (z <= -7.0) {
                return 0.0;
            }
            return Math.exp(-Math.exp(-z));
        }
        if (z <= -7.0) {
            return 1.0;
        }
        return -Math.expm1(-Math.exp(-z));
    }

    public static double barF(double beta, double delta, double x) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        double z = (x - delta) / beta;
        if (beta > 0.0) {
            if (z <= -7.0) {
                return 1.0;
            }
            return -Math.expm1(-Math.exp(-z));
        }
        if (z <= -7.0) {
            return 0.0;
        }
        return Math.exp(-Math.exp(-z));
    }

    public static double inverseF(double beta, double delta, double u) {
        if (u < 0.0 || u > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        if (u >= 1.0) {
            return Double.POSITIVE_INFINITY;
        }
        if (u <= 0.0) {
            return Double.NEGATIVE_INFINITY;
        }
        if (beta > 0.0) {
            return delta - Math.log(-Math.log(u)) * beta;
        }
        return delta - Math.log(-Math.log1p(-u)) * beta;
    }

    public static double[] getMLE(double[] x, int n) {
        int i;
        if (n <= 1) {
            throw new IllegalArgumentException("n <= 1");
        }
        double[] par = new double[2];
        double xmin = Double.MAX_VALUE;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += x[i];
            if (!(x[i] < xmin)) continue;
            xmin = x[i];
        }
        double mean = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += (x[i] - mean) * (x[i] - mean);
        }
        double variance = sum / ((double)n - 1.0);
        FunctionPlus func = new FunctionPlus(x, n, mean, xmin);
        double lam = 1.0 / (0.7797 * Math.sqrt(variance));
        double EPS = 0.02;
        double a = 0.98 * lam - 5.0;
        if (a <= 0.0) {
            a = 1.0E-15;
        }
        double b = 1.02 * lam + 5.0;
        lam = RootFinder.brentDekker(a, b, func, 1.0E-8);
        par[0] = 1.0 / lam;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += Math.exp(-(x[i] - xmin) * lam);
        }
        par[1] = xmin - Math.log(sum / (double)n) / lam;
        return par;
    }

    public static double[] getMLEmin(double[] x, int n) {
        int i;
        if (n <= 1) {
            throw new IllegalArgumentException("n <= 1");
        }
        double[] par = new double[2];
        double xmax = -1.7976931348623157E308;
        double sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += x[i];
            if (!(x[i] > xmax)) continue;
            xmax = x[i];
        }
        double mean = sum / (double)n;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += (x[i] - mean) * (x[i] - mean);
        }
        double variance = sum / ((double)n - 1.0);
        FunctionMinus func = new FunctionMinus(x, n, mean, xmax);
        double lam = -1.0 / (0.7797 * Math.sqrt(variance));
        double EPS = 0.02;
        double a = 1.02 * lam - 2.0;
        double b = 0.98 * lam + 2.0;
        if (b >= 0.0) {
            b = -1.0E-15;
        }
        lam = RootFinder.brentDekker(a, b, func, 1.0E-12);
        par[0] = 1.0 / lam;
        sum = 0.0;
        for (i = 0; i < n; ++i) {
            sum += Math.exp((xmax - x[i]) * lam);
        }
        par[0] = 1.0 / lam;
        par[1] = xmax - Math.log(sum / (double)n) / lam;
        return par;
    }

    public static GumbelDist getInstanceFromMLE(double[] x, int n) {
        double[] parameters = GumbelDist.getMLE(x, n);
        return new GumbelDist(parameters[0], parameters[1]);
    }

    public static GumbelDist getInstanceFromMLEmin(double[] x, int n) {
        double[] parameters = GumbelDist.getMLEmin(x, n);
        return new GumbelDist(parameters[0], parameters[1]);
    }

    public static double getMean(double beta, double delta) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        return delta + 0.5772156649015329 * beta;
    }

    public static double getVariance(double beta, double delta) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        return Math.PI * Math.PI * beta * beta / 6.0;
    }

    public static double getStandardDeviation(double beta, double delta) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        return Math.sqrt(GumbelDist.getVariance(beta, delta));
    }

    public double getBeta() {
        return this.beta;
    }

    public double getDelta() {
        return this.delta;
    }

    public void setParams(double beta, double delta) {
        if (beta == 0.0) {
            throw new IllegalArgumentException("beta = 0");
        }
        this.delta = delta;
        this.beta = beta;
    }

    @Override
    public double[] getParams() {
        double[] retour = new double[]{this.beta, this.delta};
        return retour;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " : beta = " + this.beta + ", delta = " + this.delta;
    }

    private static class FunctionMinus
    implements MathFunction {
        protected int n;
        protected double mean;
        protected double[] x;
        protected double xmax;

        public FunctionMinus(double[] y, int n, double mean, double xmax) {
            this.n = n;
            this.mean = mean;
            this.x = y;
            this.xmax = xmax;
        }

        @Override
        public double evaluate(double lam) {
            if (lam >= 0.0) {
                return 1.0E100;
            }
            double sum2 = 0.0;
            double sum1 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double tem = Math.exp((this.xmax - this.x[i]) * lam);
                sum1 += tem;
                sum2 += this.x[i] * tem;
            }
            return (this.mean - 1.0 / lam) * sum1 - sum2;
        }
    }

    private static class FunctionPlus
    implements MathFunction {
        protected int n;
        protected double mean;
        protected double[] x;
        private double minx;

        public FunctionPlus(double[] y, int n, double mean, double minx) {
            this.n = n;
            this.mean = mean;
            this.x = y;
            this.minx = minx;
        }

        @Override
        public double evaluate(double lam) {
            if (lam <= 0.0) {
                return 1.0E100;
            }
            double sum2 = 0.0;
            double sum1 = 0.0;
            for (int i = 0; i < this.n; ++i) {
                double tem = Math.exp(-(this.x[i] - this.minx) * lam);
                sum1 += tem;
                sum2 += this.x[i] * tem;
            }
            return (this.mean - 1.0 / lam) * sum1 - sum2;
        }
    }
}

