/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.functions;

import java.io.Serializable;
import umontreal.iro.lecuyer.functions.MathFunction;
import umontreal.iro.lecuyer.functions.MathFunctionWithDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithFirstDerivative;
import umontreal.iro.lecuyer.functions.MathFunctionWithIntegral;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class Polynomial
implements MathFunction,
MathFunctionWithFirstDerivative,
MathFunctionWithDerivative,
MathFunctionWithIntegral,
Serializable,
Cloneable {
    private static final long serialVersionUID = -2911550952861456470L;
    private double[] coeff;

    public Polynomial(double ... coeff) {
        if (coeff == null) {
            throw new NullPointerException();
        }
        if (coeff.length == 0) {
            throw new IllegalArgumentException("At least one coefficient is needed");
        }
        this.coeff = (double[])coeff.clone();
    }

    public int getDegree() {
        return this.coeff.length - 1;
    }

    public double[] getCoefficients() {
        return (double[])this.coeff.clone();
    }

    public double getCoefficient(int i) {
        return this.coeff[i];
    }

    public void setCoefficients(double ... coeff) {
        if (coeff == null) {
            throw new NullPointerException();
        }
        if (coeff.length == 0) {
            throw new IllegalArgumentException("At least one coefficient is needed");
        }
        this.coeff = (double[])coeff.clone();
    }

    @Override
    public double evaluate(double x) {
        double res = this.coeff[this.coeff.length - 1];
        for (int i = this.coeff.length - 2; i >= 0; --i) {
            res = this.coeff[i] + x * res;
        }
        return res;
    }

    @Override
    public double derivative(double x) {
        return this.derivative(x, 1);
    }

    @Override
    public double derivative(double x, int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return this.evaluate(x);
        }
        if (n >= this.coeff.length) {
            return 0.0;
        }
        double res = this.getCoeffDer(this.coeff.length - 1, n);
        for (int i = this.coeff.length - 2; i >= n; --i) {
            res = this.getCoeffDer(i, n) + x * res;
        }
        return res;
    }

    public Polynomial derivativePolynomial(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("n < 0");
        }
        if (n == 0) {
            return this;
        }
        if (n >= this.coeff.length) {
            return new Polynomial(0.0);
        }
        double[] coeffDer = new double[this.coeff.length - n];
        for (int i = this.coeff.length - 1; i >= n; --i) {
            coeffDer[i - n] = this.getCoeffDer(i, n);
        }
        return new Polynomial(coeffDer);
    }

    private double getCoeffDer(int i, int n) {
        double coeffDer = this.coeff[i];
        for (int j = i; j > i - n; --j) {
            coeffDer *= (double)j;
        }
        return coeffDer;
    }

    @Override
    public double integral(double a, double b) {
        return this.integralA0(b) - this.integralA0(a);
    }

    private double integralA0(double u) {
        int n = this.coeff.length - 1;
        double res = u * this.coeff[n] / (double)(n + 1);
        for (int i = this.coeff.length - 2; i >= 0; --i) {
            res = this.coeff[i] * u / (double)(i + 1) + u * res;
        }
        return res;
    }

    public Polynomial integralPolynomial(double c) {
        double[] coeffInt = new double[this.coeff.length + 1];
        coeffInt[0] = c;
        for (int i = 0; i < this.coeff.length; ++i) {
            coeffInt[i + 1] = this.coeff[i] / (double)(i + 1);
        }
        return new Polynomial(coeffInt);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.coeff.length; ++i) {
            if (i > 0) {
                if (this.coeff[i] == 0.0) continue;
                if (this.coeff[i] > 0.0) {
                    sb.append(" + ");
                } else {
                    sb.append(" - ");
                }
                sb.append(PrintfFormat.format(8, 3, 3, Math.abs(this.coeff[i])));
            } else {
                sb.append(PrintfFormat.format(8, 3, 3, this.coeff[i]));
            }
            if (i <= 0) continue;
            sb.append("*X");
            if (i <= 1) continue;
            sb.append("^").append(i);
        }
        return sb.toString();
    }

    public Polynomial clone() {
        Polynomial pol;
        try {
            pol = (Polynomial)super.clone();
        }
        catch (CloneNotSupportedException cne) {
            throw new IllegalStateException("Clone not supported");
        }
        pol.coeff = (double[])this.coeff.clone();
        return pol;
    }
}

