/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.randvar.WeibullGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.Resource;
import umontreal.iro.lecuyer.simprocs.SimProcess;
import umontreal.iro.lecuyer.stat.Tally;

public class TimeShared {
    int nbTerminal = 20;
    double quantum;
    double overhead = 0.001;
    double meanThink = 5.0;
    double alpha = 0.5;
    double lambda = 1.0;
    double delta = 0.0;
    int N = 1100;
    int N0 = 100;
    int nbTasks;
    RandomStream streamThink = new MRG32k3a();
    RandomVariateGen genThink = new ExponentialGen(this.streamThink, 1.0 / this.meanThink);
    RandomStream streamServ = new MRG32k3a("Gen. for service requirements");
    RandomVariateGen genServ = new WeibullGen(this.streamServ, this.alpha, this.lambda, this.delta);
    Resource server = new Resource(1, "The server");
    Tally meanInRep = new Tally("Average for current run");
    Tally statDiff = new Tally("Diff. on mean response times");

    private void simulOneRun() {
        SimProcess.init();
        this.server.init();
        this.meanInRep.init();
        this.nbTasks = 0;
        for (int i = 1; i <= this.nbTerminal; ++i) {
            new Terminal().schedule(0.0);
        }
        Sim.start();
    }

    public void simulateConfigs(double numRuns, double q1, double q2) {
        int rep = 0;
        while ((double)rep < numRuns) {
            this.quantum = q1;
            this.simulOneRun();
            double mean1 = this.meanInRep.average();
            this.streamThink.resetStartSubstream();
            this.streamServ.resetStartSubstream();
            this.quantum = q2;
            this.simulOneRun();
            this.statDiff.add(mean1 - this.meanInRep.average());
            this.streamThink.resetNextSubstream();
            this.streamServ.resetNextSubstream();
            ++rep;
        }
        this.statDiff.setConfidenceIntervalStudent();
        System.out.println(this.statDiff.report(0.9, 3));
    }

    public static void main(String[] args) {
        new TimeShared().simulateConfigs(10.0, 0.1, 0.2);
    }

    class Terminal
    extends SimProcess {
        Terminal() {
        }

        @Override
        public void actions() {
            while (TimeShared.this.nbTasks < TimeShared.this.N) {
                double timeNeeded;
                this.delay(TimeShared.this.genThink.nextDouble());
                double arrivTime = Sim.time();
                for (timeNeeded = TimeShared.this.genServ.nextDouble(); timeNeeded > TimeShared.this.quantum; timeNeeded -= TimeShared.this.quantum) {
                    TimeShared.this.server.request(1);
                    this.delay(TimeShared.this.quantum + TimeShared.this.overhead);
                    TimeShared.this.server.release(1);
                }
                TimeShared.this.server.request(1);
                this.delay(timeNeeded + TimeShared.this.overhead);
                TimeShared.this.server.release(1);
                ++TimeShared.this.nbTasks;
                if (TimeShared.this.nbTasks <= TimeShared.this.N0) continue;
                TimeShared.this.meanInRep.add(Sim.time() - arrivTime);
            }
            Sim.stop();
        }
    }
}

