/*
 * Decompiled with CFR 0.152.
 */
import umontreal.iro.lecuyer.randvar.ExponentialGen;
import umontreal.iro.lecuyer.randvar.RandomVariateGen;
import umontreal.iro.lecuyer.rng.MRG32k3a;
import umontreal.iro.lecuyer.rng.RandomStream;
import umontreal.iro.lecuyer.simevents.Event;
import umontreal.iro.lecuyer.simevents.Sim;
import umontreal.iro.lecuyer.simprocs.Resource;
import umontreal.iro.lecuyer.simprocs.SimProcess;

public class QueueProc {
    Resource server = new Resource(1, "Server");
    RandomVariateGen genArr;
    RandomVariateGen genServ;

    public QueueProc(double lambda, double mu) {
        this.genArr = new ExponentialGen((RandomStream)new MRG32k3a(), lambda);
        this.genServ = new ExponentialGen((RandomStream)new MRG32k3a(), mu);
    }

    public void simulateOneRun(double timeHorizon) {
        SimProcess.init();
        this.server.setStatCollecting(true);
        new EndOfSim().schedule(timeHorizon);
        new Customer().schedule(this.genArr.nextDouble());
        Sim.start();
    }

    public static void main(String[] args) {
        QueueProc queue = new QueueProc(1.0, 2.0);
        queue.simulateOneRun(1000.0);
        System.out.println(queue.server.report());
    }

    class EndOfSim
    extends Event {
        EndOfSim() {
        }

        @Override
        public void actions() {
            Sim.stop();
        }
    }

    class Customer
    extends SimProcess {
        Customer() {
        }

        @Override
        public void actions() {
            new Customer().schedule(QueueProc.this.genArr.nextDouble());
            QueueProc.this.server.request(1);
            this.delay(QueueProc.this.genServ.nextDouble());
            QueueProc.this.server.release(1);
        }
    }
}

