/*
 * Decompiled with CFR 0.152.
 */
package javolution.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import javax.realtime.MemoryArea;
import javolution.lang.Realtime;
import javolution.text.Text;
import javolution.util.FastComparator;
import javolution.util.FastIterator;
import javolution.util.FastTable;
import javolution.xml.XMLSerializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FastCollection<E>
implements Collection<E>,
XMLSerializable,
Realtime {
    private Unmodifiable _unmodifiable;

    protected FastCollection() {
    }

    @Override
    public abstract int size();

    public abstract Record head();

    public abstract Record tail();

    public abstract E valueOf(Record var1);

    public abstract void delete(Record var1);

    public Collection<E> unmodifiable() {
        if (this._unmodifiable == null) {
            MemoryArea.getMemoryArea(this).executeInArea(new Runnable(){

                public void run() {
                    FastCollection.this._unmodifiable = new Unmodifiable();
                }
            });
        }
        return this._unmodifiable;
    }

    @Override
    public Iterator<E> iterator() {
        return FastIterator.valueOf(this);
    }

    public FastComparator<? super E> getValueComparator() {
        return FastComparator.DEFAULT;
    }

    @Override
    public boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        FastComparator<E> fastComparator = this.getValueComparator();
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            if (!fastComparator.areEqual(object, this.valueOf(record))) continue;
            this.delete(record);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        Record record = this.head();
        for (Record record2 = this.tail().getPrevious(); record2 != record; record2 = record2.getPrevious()) {
            this.delete(record2);
        }
    }

    @Override
    public final boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object object) {
        FastComparator<E> fastComparator = this.getValueComparator();
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            if (!fastComparator.areEqual(object, this.valueOf(record))) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection instanceof FastCollection) {
            return this.addAll((FastCollection)collection);
        }
        boolean bl = false;
        Iterator<E> iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (!this.add(iterator.next())) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    private boolean addAll(FastCollection<? extends E> fastCollection) {
        if (fastCollection instanceof FastTable) {
            return this.addAll((FastTable)fastCollection);
        }
        boolean bl = false;
        Record record = fastCollection.head();
        Record record2 = fastCollection.tail();
        while ((record = record.getNext()) != record2) {
            if (!this.add(fastCollection.valueOf(record))) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    private boolean addAll(FastTable<? extends E> fastTable) {
        boolean bl = false;
        int n = 0;
        int n2 = fastTable.size();
        while (n < n2) {
            if (!this.add(fastTable.get(n++))) continue;
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        if (collection instanceof FastCollection) {
            return this.containsAll((FastCollection)collection);
        }
        Iterator<?> iterator = collection.iterator();
        int n = collection.size();
        while (--n >= 0) {
            if (this.contains(iterator.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    private boolean containsAll(FastCollection<?> fastCollection) {
        Record record = fastCollection.head();
        Record record2 = fastCollection.tail();
        while ((record = record.getNext()) != record2) {
            if (this.contains(fastCollection.valueOf(record))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean bl = false;
        Record record = this.head();
        Record record2 = this.tail().getPrevious();
        while (record2 != record) {
            Record record3 = record2.getPrevious();
            if (collection.contains(this.valueOf(record2))) {
                this.delete(record2);
                bl = true;
            }
            record2 = record3;
        }
        return bl;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean bl = false;
        Record record = this.head();
        Record record2 = this.tail().getPrevious();
        while (record2 != record) {
            Record record3 = record2.getPrevious();
            if (!collection.contains(this.valueOf(record2))) {
                this.delete(record2);
                bl = true;
            }
            record2 = record3;
        }
        return bl;
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size()]);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        int n = this.size();
        if (TArray.length < n) {
            throw new UnsupportedOperationException("Destination array too small");
        }
        if (TArray.length > n) {
            TArray[n] = null;
        }
        int n2 = 0;
        T[] TArray2 = TArray;
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            TArray2[n2++] = this.valueOf(record);
        }
        return TArray;
    }

    @Override
    public Text toText() {
        Text text = Text.valueOf((Object)"[");
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            text = text.plus(this.valueOf(record));
            if (record.getNext() == record2) continue;
            text = text.plus(", ");
        }
        return text.plus("]");
    }

    public final String toString() {
        return this.toText().toString();
    }

    @Override
    public boolean equals(Object object) {
        if (this instanceof List) {
            return this.equalsList(object);
        }
        return object == this || object instanceof Collection && ((Collection)object).size() == this.size() && this.containsAll((Collection)object);
    }

    private boolean equalsList(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof List)) {
            return false;
        }
        if (object instanceof FastCollection) {
            return this.equalsList((FastCollection)object);
        }
        List list = (List)object;
        if (this.size() != list.size()) {
            return false;
        }
        Iterator iterator = list.iterator();
        FastComparator<E> fastComparator = this.getValueComparator();
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            Object e;
            E e2 = this.valueOf(record);
            if (fastComparator.areEqual(e2, e = iterator.next())) continue;
            return false;
        }
        return true;
    }

    private boolean equalsList(FastCollection fastCollection) {
        if (this.size() != fastCollection.size()) {
            return false;
        }
        Record record = fastCollection.head();
        FastComparator<E> fastComparator = this.getValueComparator();
        Record record2 = this.head();
        Record record3 = this.tail();
        while ((record2 = record2.getNext()) != record3) {
            E e;
            E e2 = this.valueOf(record2);
            if (fastComparator.areEqual(e2, e = fastCollection.valueOf(record = record.getNext()))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this instanceof List) {
            return this.hashCodeList();
        }
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = 0;
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            n += fastComparator.hashCodeOf(this.valueOf(record));
        }
        return n;
    }

    private int hashCodeList() {
        FastComparator<E> fastComparator = this.getValueComparator();
        int n = 1;
        Record record = this.head();
        Record record2 = this.tail();
        while ((record = record.getNext()) != record2) {
            n = 31 * n + fastComparator.hashCodeOf(this.valueOf(record));
        }
        return n;
    }

    private final class Unmodifiable
    extends FastCollection
    implements Set,
    List {
        private Unmodifiable() {
        }

        public int size() {
            return FastCollection.this.size();
        }

        public Record head() {
            return FastCollection.this.head();
        }

        public Record tail() {
            return FastCollection.this.tail();
        }

        public Object valueOf(Record record) {
            return FastCollection.this.valueOf(record);
        }

        public boolean contains(Object object) {
            return FastCollection.this.contains(object);
        }

        public boolean containsAll(Collection collection) {
            return FastCollection.this.containsAll(collection);
        }

        public FastComparator getValueComparator() {
            return FastCollection.this.getValueComparator();
        }

        public boolean add(Object object) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void delete(Record record) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public boolean addAll(int n, Collection collection) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object get(int n) {
            return ((List)((Object)FastCollection.this)).get(n);
        }

        public Object set(int n, Object object) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public void add(int n, Object object) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public Object remove(int n) {
            throw new UnsupportedOperationException("Unmodifiable");
        }

        public int indexOf(Object object) {
            return ((List)((Object)FastCollection.this)).indexOf(object);
        }

        public int lastIndexOf(Object object) {
            return ((List)((Object)FastCollection.this)).lastIndexOf(object);
        }

        public ListIterator listIterator() {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public ListIterator listIterator(int n) {
            throw new UnsupportedOperationException("List iterator not supported for unmodifiable collection");
        }

        public List subList(int n, int n2) {
            throw new UnsupportedOperationException("Sub-List not supported for unmodifiable collection");
        }
    }

    public static interface Record {
        public Record getPrevious();

        public Record getNext();
    }
}

