/*
 * Decompiled with CFR 0.152.
 */
package javolution.text;

import java.io.IOException;
import java.text.ParsePosition;
import javolution.Javolution;
import javolution.context.ObjectFactory;
import javolution.lang.ClassInitializer;
import javolution.lang.Reflection;
import javolution.text.CharSet;
import javolution.text.Text;
import javolution.text.TextBuilder;
import javolution.text.TypeFormat;
import javolution.util.FastMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TextFormat<T> {
    private static final FastMap FORMATS = new FastMap().setShared(true);

    protected TextFormat() {
    }

    public static <T> TextFormat<T> getInstance(Class<T> clazz) {
        TextFormat textFormat = (TextFormat)FORMATS.get(clazz);
        return textFormat != null ? textFormat : TextFormat.searchFormat(clazz);
    }

    private static TextFormat searchFormat(Class clazz) {
        if (clazz == null) {
            return null;
        }
        ClassInitializer.initialize(clazz);
        TextFormat textFormat = (TextFormat)FORMATS.get(clazz);
        return textFormat != null ? textFormat : TextFormat.searchFormat(TextFormat.superclassOf(clazz));
    }

    private static Class superclassOf(Class clazz) {
        return clazz.getSuperclass();
    }

    public static <T> void setInstance(Class<T> clazz, TextFormat<T> textFormat) {
        ClassInitializer.initialize(clazz);
        FORMATS.put(clazz, textFormat);
    }

    public abstract Appendable format(T var1, Appendable var2) throws IOException;

    public abstract T parse(CharSequence var1, Cursor var2);

    public final Appendable format(T t, TextBuilder textBuilder) {
        try {
            return this.format(t, (Appendable)textBuilder);
        }
        catch (IOException iOException) {
            throw new Error();
        }
    }

    public final Text format(T t) {
        TextBuilder textBuilder = TextBuilder.newInstance();
        this.format(t, textBuilder);
        Text text = textBuilder.toText();
        TextBuilder.recycle(textBuilder);
        return text;
    }

    public final T parse(CharSequence charSequence) {
        Cursor cursor = Cursor.newInstance(0, charSequence.length());
        T t = this.parse(charSequence, cursor);
        if (cursor.hasNext()) {
            throw new IllegalArgumentException("Incomplete Parsing");
        }
        Cursor.recycle(cursor);
        return t;
    }

    static {
        FORMATS.put(new Boolean(true).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format((Boolean)object, appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Boolean(TypeFormat.parseBoolean(charSequence, cursor));
            }
        });
        FORMATS.put(new Character(' ').getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return appendable.append(((Character)object).charValue());
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Character(cursor.next(charSequence));
            }
        });
        FORMATS.put(new Byte(0).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format(((Byte)object).byteValue(), appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Byte(TypeFormat.parseByte(charSequence, 10, cursor));
            }
        });
        FORMATS.put(new Short(0).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format(((Short)object).shortValue(), appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Short(TypeFormat.parseShort(charSequence, 10, cursor));
            }
        });
        FORMATS.put(new Integer(0).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format((Integer)object, appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Integer(TypeFormat.parseInt(charSequence, 10, cursor));
            }
        });
        FORMATS.put(new Long(0L).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format((Long)object, appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Long(TypeFormat.parseLong(charSequence, 10, cursor));
            }
        });
        FORMATS.put("".getClass().getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return appendable.append(Javolution.j2meToCharSeq(((Class)object).getName()));
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                Class clazz;
                Text text = Text.valueOf(charSequence.subSequence(cursor.getIndex(), cursor.getEndIndex()));
                int n = text.indexOfAny(CharSet.WHITESPACES);
                int n2 = n < 0 ? text.length() : n;
                Text text2 = text.subtext(0, n2);
                try {
                    clazz = Reflection.getClass(text2);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new IllegalArgumentException("Class " + text2 + " Not Found");
                }
                cursor.increment(n2);
                return clazz;
            }
        });
        FORMATS.put(new Float(0.0f).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format(((Float)object).floatValue(), appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Float(TypeFormat.parseFloat(charSequence, cursor));
            }
        });
        FORMATS.put(new Double(0.0).getClass(), new TextFormat(){

            public Appendable format(Object object, Appendable appendable) throws IOException {
                return TypeFormat.format((Double)object, appendable);
            }

            public Object parse(CharSequence charSequence, Cursor cursor) {
                return new Double(TypeFormat.parseDouble(charSequence, cursor));
            }
        });
    }

    public static class Cursor
    extends ParsePosition {
        private static final ObjectFactory FACTORY = new ObjectFactory(){

            public Object create() {
                return new Cursor();
            }
        };
        private int _index;
        private int _start;
        private int _end;

        private Cursor() {
            super(0);
        }

        public static Cursor newInstance(int n, int n2) {
            Cursor cursor = (Cursor)FACTORY.object();
            cursor._start = cursor._index = n;
            cursor._end = n2;
            cursor.setErrorIndex(-1);
            return cursor;
        }

        public static void recycle(Cursor cursor) {
            FACTORY.recycle(cursor);
        }

        public final int getIndex() {
            return this._index;
        }

        public final int getStartIndex() {
            return this._start;
        }

        public final int getEndIndex() {
            return this._end;
        }

        public final int getErrorIndex() {
            int n = this.getErrorIndex();
            return n >= 0 ? n : this._index;
        }

        public final void setIndex(int n) {
            if (n < this._start || n > this._end) {
                throw new IllegalArgumentException();
            }
            this._index = n;
        }

        public final void setStartIndex(int n) {
            this._start = n;
        }

        public final void setEndIndex(int n) {
            this._end = n;
        }

        public final void setErrorIndex(int n) {
            super.setErrorIndex(n);
        }

        public final boolean hasNext() {
            return this._index < this._end;
        }

        public final char next(CharSequence charSequence) {
            return this._index < this._end ? charSequence.charAt(this._index++) : (char)'\u0000';
        }

        public final boolean at(char c, CharSequence charSequence) {
            return this._index < this._end && charSequence.charAt(this._index) == c;
        }

        public final boolean at(CharSet charSet, CharSequence charSequence) {
            return this._index < this._end && charSet.contains(charSequence.charAt(this._index));
        }

        public final boolean at(String string, CharSequence charSequence) {
            return this._index < this._end && charSequence.charAt(this._index) == string.charAt(0) ? this.match(string, charSequence) : false;
        }

        private final boolean match(String string, CharSequence charSequence) {
            int n = 1;
            int n2 = this._index + 1;
            int n3 = string.length();
            int n4 = this._end;
            while (n < n3) {
                if (n2 < n4 && charSequence.charAt(n2++) == string.charAt(n++)) continue;
                return false;
            }
            return true;
        }

        public final boolean skip(char c, CharSequence charSequence) {
            while (this._index < this._end && charSequence.charAt(this._index) == c) {
                ++this._index;
            }
            return this._index < this._end;
        }

        public final boolean skip(CharSet charSet, CharSequence charSequence) {
            while (this._index < this._end && charSet.contains(charSequence.charAt(this._index))) {
                ++this._index;
            }
            return this._index < this._end;
        }

        public final Cursor increment() {
            ++this._index;
            return this;
        }

        public final Cursor increment(int n) {
            this._index += n;
            return this;
        }

        public String toString() {
            return String.valueOf(this._index);
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof Cursor)) {
                return false;
            }
            return this._index == ((Cursor)object)._index;
        }

        public int hashCode() {
            return this._index;
        }
    }
}

