/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import edu.uci.ics.jung.algorithms.util.NotRandom;
import edu.uci.ics.jung.algorithms.util.WeightedChoice;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;

public class TestWeightedChoice
extends TestCase {
    private WeightedChoice<String> weighted_choice;
    private Map<String, Double> item_weights = new HashMap<String, Double>();
    private Map<String, Integer> item_counts = new HashMap<String, Integer>();

    public void tearDown() {
        this.item_weights.clear();
        this.item_counts.clear();
    }

    private void initializeWeights(double[] weights) {
        this.item_weights.put("a", weights[0]);
        this.item_weights.put("b", weights[1]);
        this.item_weights.put("c", weights[2]);
        this.item_weights.put("d", weights[3]);
        for (String key : this.item_weights.keySet()) {
            this.item_counts.put(key, 0);
        }
    }

    private void runWeightedChoice() {
        this.weighted_choice = new WeightedChoice<String>(this.item_weights, new NotRandom(100));
        int max_iterations = 10000;
        for (int i = 0; i < max_iterations; ++i) {
            String item = this.weighted_choice.nextItem();
            int count = this.item_counts.get(item);
            this.item_counts.put(item, count + 1);
        }
        for (String key : this.item_weights.keySet()) {
            TestWeightedChoice.assertEquals((int)((int)(this.item_weights.get(key) * (double)max_iterations)), (int)this.item_counts.get(key));
        }
    }

    public void testUniform() {
        this.initializeWeights(new double[]{0.25, 0.25, 0.25, 0.25});
        this.runWeightedChoice();
    }

    public void testNonUniform() {
        this.initializeWeights(new double[]{0.45, 0.1, 0.13, 0.32});
        this.runWeightedChoice();
    }
}

