/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.shortestpath;

import com.google.common.base.Function;
import edu.uci.ics.jung.algorithms.shortestpath.DijkstraDistance;
import edu.uci.ics.jung.algorithms.shortestpath.ShortestPath;
import edu.uci.ics.jung.graph.Graph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class DijkstraShortestPath<V, E>
extends DijkstraDistance<V, E>
implements ShortestPath<V, E> {
    public DijkstraShortestPath(Graph<V, E> g, Function<E, ? extends Number> nev, boolean cached) {
        super(g, nev, cached);
    }

    public DijkstraShortestPath(Graph<V, E> g, Function<E, ? extends Number> nev) {
        super(g, nev);
    }

    public DijkstraShortestPath(Graph<V, E> g) {
        super(g);
    }

    public DijkstraShortestPath(Graph<V, E> g, boolean cached) {
        super(g, cached);
    }

    @Override
    protected DijkstraDistance.SourceData getSourceData(V source) {
        DijkstraDistance.SourceData sd = (DijkstraDistance.SourceData)this.sourceMap.get(source);
        if (sd == null) {
            sd = new SourcePathData(source);
        }
        return sd;
    }

    public E getIncomingEdge(V source, V target) {
        if (!this.g.containsVertex(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (!this.g.containsVertex(target)) {
            throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.g);
        }
        HashSet<V> targets = new HashSet<V>();
        targets.add(target);
        this.singleSourceShortestPath(source, targets, this.g.getVertexCount());
        LinkedHashMap incomingEdgeMap = ((SourcePathData)this.sourceMap.get(source)).incomingEdges;
        Object incomingEdge = incomingEdgeMap.get(target);
        if (!this.cached) {
            this.reset(source);
        }
        return (E)incomingEdge;
    }

    @Override
    public Map<V, E> getIncomingEdgeMap(V source) {
        return this.getIncomingEdgeMap(source, this.g.getVertexCount());
    }

    public List<E> getPath(V source, V target) {
        if (!this.g.containsVertex(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (!this.g.containsVertex(target)) {
            throw new IllegalArgumentException("Specified target vertex " + target + " is not part of graph " + this.g);
        }
        LinkedList path = new LinkedList();
        HashSet<V> targets = new HashSet<V>();
        targets.add(target);
        this.singleSourceShortestPath(source, targets, this.g.getVertexCount());
        LinkedHashMap incomingEdges = ((SourcePathData)this.sourceMap.get(source)).incomingEdges;
        if (incomingEdges.isEmpty() || incomingEdges.get(target) == null) {
            return path;
        }
        V current = target;
        while (!current.equals(source)) {
            Object incoming = incomingEdges.get(current);
            path.addFirst(incoming);
            current = ((Graph)this.g).getOpposite(current, incoming);
        }
        return path;
    }

    public LinkedHashMap<V, E> getIncomingEdgeMap(V source, int numDests) {
        if (!this.g.getVertices().contains(source)) {
            throw new IllegalArgumentException("Specified source vertex " + source + " is not part of graph " + this.g);
        }
        if (numDests < 1 || numDests > this.g.getVertexCount()) {
            throw new IllegalArgumentException("numDests must be >= 1 and <= g.numVertices()");
        }
        this.singleSourceShortestPath(source, null, numDests);
        LinkedHashMap incomingEdgeMap = ((SourcePathData)this.sourceMap.get(source)).incomingEdges;
        if (!this.cached) {
            this.reset(source);
        }
        return incomingEdgeMap;
    }

    protected class SourcePathData
    extends DijkstraDistance.SourceData {
        protected Map<V, E> tentativeIncomingEdges;
        protected LinkedHashMap<V, E> incomingEdges;

        protected SourcePathData(V source) {
            super(source);
            this.incomingEdges = new LinkedHashMap();
            this.tentativeIncomingEdges = new HashMap();
        }

        @Override
        public void update(V dest, E tentative_edge, double new_dist) {
            super.update(dest, tentative_edge, new_dist);
            this.tentativeIncomingEdges.put(dest, tentative_edge);
        }

        @Override
        public Map.Entry<V, Number> getNextVertex() {
            Map.Entry p = super.getNextVertex();
            Object v = p.getKey();
            Object incoming = this.tentativeIncomingEdges.remove(v);
            this.incomingEdges.put(v, incoming);
            return p;
        }

        @Override
        public void restoreVertex(V v, double dist) {
            super.restoreVertex(v, dist);
            Object incoming = this.incomingEdges.get(v);
            this.tentativeIncomingEdges.put(v, incoming);
        }

        @Override
        public void createRecord(V w, E e, double new_dist) {
            super.createRecord(w, e, new_dist);
            this.tentativeIncomingEdges.put(w, e);
        }
    }
}

