/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import com.google.common.base.Function;
import com.google.common.base.Supplier;
import edu.uci.ics.jung.algorithms.scoring.PageRankWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.util.HashSet;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPageRankWithPriors
extends TestCase {
    private DirectedGraph<Integer, Integer> graph;
    private Supplier<Integer> edgeFactory;

    public static Test suite() {
        return new TestSuite(TestPageRankWithPriors.class);
    }

    protected void setUp() {
        this.edgeFactory = new Supplier<Integer>(){
            int i = 0;

            public Integer get() {
                return this.i++;
            }
        };
    }

    private void addEdge(Graph<Integer, Integer> G, Integer v1, Integer v2) {
        Integer edge = (Integer)this.edgeFactory.get();
        this.graph.addEdge(edge, v1, v2);
    }

    public void testGraphScoring() {
        this.graph = new DirectedSparseMultigraph<Integer, Integer>();
        double[] expected_score = new double[]{0.1157, 0.2463, 0.4724, 0.1653};
        for (int i = 0; i < 4; ++i) {
            this.graph.addVertex(i);
        }
        this.addEdge(this.graph, 0, 1);
        this.addEdge(this.graph, 1, 2);
        this.addEdge(this.graph, 2, 3);
        this.addEdge(this.graph, 3, 0);
        this.addEdge(this.graph, 2, 1);
        HashSet<Integer> priors = new HashSet<Integer>();
        priors.add(2);
        PageRankWithPriors<Integer, Integer> pr = new PageRankWithPriors<Integer, Integer>((Hypergraph<Integer, Integer>)this.graph, (Function<Integer, Double>)ScoringUtils.getUniformRootPrior(priors), 0.3);
        pr.evaluate();
        double score_sum = 0.0;
        for (int i = 0; i < this.graph.getVertexCount(); ++i) {
            double score = (Double)pr.getVertexScore(i);
            Assert.assertEquals((double)expected_score[i], (double)score, (double)pr.getTolerance());
            score_sum += score;
        }
        Assert.assertEquals((double)1.0, (double)score_sum, (double)(pr.getTolerance() * (double)this.graph.getVertexCount()));
    }

    public void testHypergraphScoring() {
    }
}

