/*
 * Decompiled with CFR 0.152.
 */
package com.aptech.gaussApi5_0;

import com.aptech.gaussApi5_0.Gauss;
import com.aptech.gaussApi5_0.GaussMatrixInfo;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;

public class GaussMatrix {
    private static byte[] zeroBytes = new byte[8];
    byte[] gaussNativeBytes = null;
    ByteBuffer byteBuffer = null;
    DoubleBuffer doubleBuffer = null;
    private GaussMatrixInfo matrixInfo;
    private ByteOrder byteOrder = ByteOrder.nativeOrder();

    public GaussMatrix(double[][] dArray) {
        int n;
        int n2 = dArray.length;
        int n3 = 0;
        if (n2 == 0) {
            n3 = 0;
        } else {
            n3 = dArray[0].length;
            for (n = 0; n < n2; ++n) {
                if (dArray[n].length == n3) continue;
                throw new IllegalArgumentException("All rows must have the same length.  Row:" + n + " has length " + dArray[n].length);
            }
        }
        if (n3 == 0) {
            n2 = 0;
        }
        this.matrixInfo = new GaussMatrixInfo(n2, n3, false);
        this.gaussNativeBytes = new byte[n2 * n3 * 8];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
        for (n = 0; n < n2; ++n) {
            this.doubleBuffer.put(dArray[n]);
        }
    }

    public GaussMatrix(double[][] dArray, double[][] dArray2) {
        int n;
        int n2 = dArray.length;
        int n3 = 0;
        if (n2 == 0) {
            n3 = 0;
        } else {
            n3 = dArray[0].length;
            for (n = 0; n < n2; ++n) {
                if (dArray[n].length == n3) continue;
                throw new IllegalArgumentException("All rows must have the same length.  Real row:" + n + " has length " + dArray[n].length);
            }
        }
        if (dArray2.length != n2) {
            throw new IllegalArgumentException("Real and Imag must have the same number of rows.");
        }
        for (n = 0; n < n2; ++n) {
            if (dArray2[n].length == n3) continue;
            throw new IllegalArgumentException("All rows must have the same length.  Imag row:" + n + " has length " + dArray2[n].length);
        }
        if (n3 == 0) {
            n2 = 0;
        }
        this.matrixInfo = new GaussMatrixInfo(n2, n3, true);
        this.gaussNativeBytes = new byte[2 * n2 * n3 * 8];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
        for (n = 0; n < n2; ++n) {
            this.doubleBuffer.put(dArray[n]);
        }
        for (n = 0; n < n2; ++n) {
            this.doubleBuffer.put(dArray2[n]);
        }
    }

    public GaussMatrix(double d) {
        this.matrixInfo = new GaussMatrixInfo(1, 1, false);
        this.gaussNativeBytes = new byte[8];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
        this.doubleBuffer.put(d);
    }

    public GaussMatrix(double d, double d2) {
        this.matrixInfo = new GaussMatrixInfo(1, 1, true);
        this.gaussNativeBytes = new byte[16];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
        this.doubleBuffer.put(d);
        this.doubleBuffer.put(d2);
    }

    public GaussMatrix(GaussMatrixInfo gaussMatrixInfo) {
        this(gaussMatrixInfo.getRows(), gaussMatrixInfo.getCols(), gaussMatrixInfo.isComplex());
    }

    public GaussMatrix(int n, int n2, boolean bl) {
        if (!(n != 0 && n2 != 0 || n == 0 && n2 == 0)) {
            throw new IllegalArgumentException("If either rows or cols are 0, both must be zero.");
        }
        this.matrixInfo = new GaussMatrixInfo(n, n2, bl);
        int n3 = n * n2;
        if (bl) {
            n3 *= 2;
        }
        this.gaussNativeBytes = new byte[n3 * 8];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
        for (int i = 0; i < n3; ++i) {
            this.doubleBuffer.put(0.0);
        }
    }

    public GaussMatrix(GaussMatrix gaussMatrix) {
        GaussMatrixInfo gaussMatrixInfo = gaussMatrix.getMatrixInfo();
        this.matrixInfo = new GaussMatrixInfo(gaussMatrixInfo.getRows(), gaussMatrixInfo.getCols(), gaussMatrixInfo.isComplex());
        this.gaussNativeBytes = new byte[gaussMatrix.gaussNativeBytes.length];
        this.byteBuffer = ByteBuffer.wrap(this.gaussNativeBytes);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
        System.arraycopy(gaussMatrix.gaussNativeBytes, 0, this.gaussNativeBytes, 0, gaussMatrix.gaussNativeBytes.length);
    }

    GaussMatrix() {
    }

    private GaussMatrix(int n, int n2, byte[] byArray) {
        this(n, n2, byArray, false);
    }

    private GaussMatrix(int n, int n2, byte[] byArray, boolean bl) {
        if (n < 0) {
            throw new IllegalArgumentException("Number of Rows, " + n + " is negative");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Number of Columns, " + n2 + " is negative");
        }
        if (byArray == null) {
            throw new NullPointerException("nativebytes array");
        }
        int n3 = n;
        int n4 = n2;
        long l = byArray.length;
        if (bl) {
            if (l != (long)(n3 * n4 * 8 * 2)) {
                throw new IllegalArgumentException("Incorrect number of bytes for complex " + n3 + "x" + n4 + " matrix.  Only " + l + " supplied.");
            }
        } else if (l != (long)(n3 * n4 * 8)) {
            throw new IllegalArgumentException("Incorrect number of bytes for " + n3 + "x" + n4 + " matrix.  Only " + l + " supplied.");
        }
        this.matrixInfo = new GaussMatrixInfo(n3, n4, bl);
        this.gaussNativeBytes = byArray;
        this.byteBuffer = ByteBuffer.wrap(byArray);
        this.byteBuffer.order(this.byteOrder);
        this.doubleBuffer = this.byteBuffer.asDoubleBuffer();
    }

    public void setReal(int n, int n2, double d) {
        int n3 = this.matrixInfo.getCols();
        if (n >= this.matrixInfo.getRows() || n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + this.matrixInfo.getRows() + "x" + n3 + " matrix.");
        }
        this.doubleBuffer.position(n * n3 + n2);
        this.doubleBuffer.put(d);
    }

    public void setImag(int n, int n2, double d) {
        int n3 = this.matrixInfo.getRows();
        int n4 = this.matrixInfo.getCols();
        if (n >= n3 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + n3 + "x" + n4 + " matrix.");
        }
        if (!this.isComplex()) {
            throw new IllegalStateException("Matrix is not complex.");
        }
        this.doubleBuffer.position(n3 * n4 + n * n4 + n2);
        this.doubleBuffer.put(d);
    }

    public void setString(int n, int n2, String string) {
        int n3 = this.matrixInfo.getRows();
        int n4 = this.matrixInfo.getCols();
        if (n >= n3 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + n3 + "x" + n4 + " matrix.");
        }
        byte[] byArray = string.getBytes();
        byte[] byArray2 = new byte[8];
        int n5 = byArray.length;
        if (n5 > 8) {
            n5 = 8;
        }
        System.arraycopy(byArray, 0, byArray2, 0, n5);
        if (n5 < 8) {
            System.arraycopy(zeroBytes, 0, byArray2, n5, 8 - n5);
        }
        this.byteBuffer.position(8 * (n * n4 + n2));
        this.byteBuffer.put(byArray2, 0, 8);
    }

    public boolean isComplex() {
        return this.matrixInfo.isComplex();
    }

    public int getRows() {
        return this.matrixInfo.getRows();
    }

    public int getCols() {
        return this.matrixInfo.getCols();
    }

    public GaussMatrixInfo getMatrixInfo() {
        return this.matrixInfo;
    }

    public double getReal(int n, int n2) {
        int n3 = this.matrixInfo.getCols();
        if (n >= this.matrixInfo.getRows() || n2 >= n3) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + this.matrixInfo.getRows() + "x" + n3 + " matrix.");
        }
        return this.doubleBuffer.get(n * this.matrixInfo.getCols() + n2);
    }

    public double[][] getReals() {
        int n = this.matrixInfo.getRows();
        int n2 = this.matrixInfo.getCols();
        double[][] dArray = new double[this.getRows()][this.getCols()];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.getReal(i, j);
            }
        }
        return dArray;
    }

    public double[][] getImags() {
        int n = this.matrixInfo.getRows();
        int n2 = this.matrixInfo.getCols();
        double[][] dArray = new double[this.getRows()][this.getCols()];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray[i][j] = this.getImag(i, j);
            }
        }
        return dArray;
    }

    public double getImag(int n, int n2) {
        int n3 = this.matrixInfo.getRows();
        int n4 = this.matrixInfo.getCols();
        if (n >= n3 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + n3 + "x" + n4 + " matrix.");
        }
        if (!this.isComplex()) {
            return 0.0;
        }
        return this.doubleBuffer.get(n3 * n4 + n * n4 + n2);
    }

    public String getString(int n, int n2) {
        int n3 = this.matrixInfo.getRows();
        int n4 = this.matrixInfo.getCols();
        if (n >= n3 || n2 >= n4) {
            throw new ArrayIndexOutOfBoundsException("[" + n + "," + n2 + "] exceeds max index for " + n3 + "x" + n4 + " matrix.");
        }
        byte[] byArray = new byte[8];
        this.byteBuffer.position(8 * (n * n4 + n2));
        this.byteBuffer.get(byArray, 0, 8);
        for (n = 0; n < byArray.length && byArray[n] != 0; ++n) {
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return new String(byArray2);
    }

    public String[][] getStrings() {
        int n = this.matrixInfo.getRows();
        int n2 = this.matrixInfo.getCols();
        String[][] stringArray = new String[this.getRows()][this.getCols()];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringArray[i][j] = this.getString(i, j);
            }
        }
        return stringArray;
    }

    public String asString() {
        String string = Gauss.nl;
        int n = this.matrixInfo.getRows();
        int n2 = this.matrixInfo.getCols();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                string = string + this.getString(i, j) + " ";
            }
            string = string + Gauss.nl;
        }
        return string;
    }

    public String toString() {
        String string = Gauss.nl;
        int n = this.matrixInfo.getRows();
        int n2 = this.matrixInfo.getCols();
        if (!this.isComplex()) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    string = string + this.getReal(i, j) + " ";
                }
                string = string + Gauss.nl;
            }
        } else {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n2; ++j) {
                    double d = this.getImag(i, j);
                    string = d >= 0.0 ? string + this.getReal(i, j) + "+" + d + "i " : string + this.getReal(i, j) + "" + d + "i ";
                }
                string = string + Gauss.nl;
            }
        }
        return string;
    }

    private byte[] getGaussNativeBytes() {
        return this.gaussNativeBytes;
    }

    static {
        for (int i = 0; i < zeroBytes.length; ++i) {
            GaussMatrix.zeroBytes[i] = 0;
        }
    }
}

