/*
 * Decompiled with CFR 0.152.
 */
package jminhep.cluster;

import jminhep.gui.SetEnv;

public class Get {
    public static double compactness(double[][] indat, int[] assignment, int numClusters, double[][] clusterCenters) {
        int nrow = SetEnv.NRow;
        int ncol = SetEnv.Dim;
        double[] aPixel = new double[ncol];
        double[] dsize = new double[numClusters];
        double[] isize = new double[numClusters];
        for (int j = 0; j < numClusters; ++j) {
            dsize[j] = 0.0;
            isize[j] = 0.0;
        }
        double cs = 0.0;
        double maxSize = 0.0;
        for (int h = 0; h < nrow; ++h) {
            int current = assignment[h];
            if (current < 0) continue;
            for (int b = 0; b < ncol; ++b) {
                aPixel[b] = indat[h][b];
            }
            double ddd = Get.calcDistance(aPixel, clusterCenters[current]);
            dsize[current] = dsize[current] + ddd;
            maxSize = Math.max(maxSize, ddd);
            int n = current;
            isize[n] = isize[n] + 1.0;
        }
        double csumm = 0.0;
        for (int j = 0; j < numClusters; ++j) {
            csumm += dsize[j] / isize[j];
        }
        csumm /= (double)numClusters;
        double minDist = Double.MAX_VALUE;
        for (int c1 = 0; c1 < numClusters - 1; ++c1) {
            for (int c2 = c1 + 1; c2 < numClusters; ++c2) {
                double distance = Get.calcDistance(clusterCenters[c1], clusterCenters[c2]);
                minDist = Math.min(minDist, distance);
            }
        }
        cs = maxSize / minDist;
        return cs;
    }

    public static double calcSquaredDistance(double[] a1, double[] a2) {
        double distance = 0.0;
        for (int e = 0; e < a1.length; ++e) {
            distance += (a1[e] - a2[e]) * (a1[e] - a2[e]);
        }
        return distance;
    }

    public static double calcDistance(double[] a1, double[] a2) {
        double distance = 0.0;
        for (int e = 0; e < a1.length; ++e) {
            distance += (a1[e] - a2[e]) * (a1[e] - a2[e]);
        }
        return Math.sqrt(distance);
    }
}

