/*
 * Decompiled with CFR 0.152.
 */
package jminhep.cluster;

import java.io.Serializable;

public class DataPoint
implements Serializable {
    private double[] a;
    private int Dimena;
    private int clusterNumber;

    public DataPoint(double[] xx, int dim) {
        this.a = new double[dim];
        for (int i = 0; i < dim; ++i) {
            this.a[i] = xx[i];
        }
        this.Dimena = dim;
        this.clusterNumber = 0;
    }

    public DataPoint(double[] xx) {
        int dim = xx.length;
        this.a = new double[dim];
        for (int i = 0; i < dim; ++i) {
            this.a[i] = xx[i];
        }
        this.Dimena = dim;
        this.clusterNumber = 0;
    }

    public int getDimension() {
        return this.Dimena;
    }

    public void assignToCluster(int _clusterNumber) {
        this.clusterNumber = _clusterNumber;
    }

    public int getClusterNumber() {
        return this.clusterNumber;
    }

    public double getAttribute(int index) {
        if (index < this.Dimena) {
            return this.a[index];
        }
        return -999999.0;
    }

    public void showAttributes() {
        String s = "(";
        for (int i = 0; i < this.Dimena; ++i) {
            if (i < this.Dimena - 1) {
                s = s + this.getAttribute(i) + ",";
            }
            if (i != this.Dimena - 1) continue;
            s = s + this.getAttribute(i);
        }
        s = s + ")";
        System.out.println(s);
    }

    public static double distance(DataPoint dp1, DataPoint dp2) {
        double result = 0.0;
        for (int i = 0; i < dp1.Dimena; ++i) {
            double x1 = dp1.getAttribute(i);
            double x2 = dp2.getAttribute(i);
            result += (x1 - x2) * (x1 - x2);
        }
        result = Math.sqrt(result);
        return result;
    }

    public static double distanceSqrt(DataPoint dp1, DataPoint dp2) {
        double result = 0.0;
        for (int i = 0; i < dp1.Dimena; ++i) {
            double x1 = dp1.getAttribute(i);
            double x2 = dp2.getAttribute(i);
            result += (x1 - x2) * (x1 - x2);
        }
        return result;
    }

    public String toString() {
        String s = "(";
        for (int i = 0; i < this.Dimena; ++i) {
            if (i < this.Dimena - 1) {
                s = s + this.getAttribute(i) + ",";
            }
            if (i != this.Dimena - 1) continue;
            s = s + this.getAttribute(i);
        }
        return s + ")[" + this.clusterNumber + "]";
    }

    public static void main(String[] args) {
        double[] a1 = new double[3];
        double[] a2 = new double[3];
        a1[0] = 2.0;
        a1[1] = 3.0;
        a1[2] = 1.0;
        a2[0] = 13.0;
        a2[1] = 14.0;
        a2[2] = 17.0;
        DataPoint dp1 = new DataPoint(a1, 3);
        DataPoint dp2 = new DataPoint(a2, 3);
        System.out.println(DataPoint.distance(dp1, dp2));
        dp1.showAttributes();
        dp2.showAttributes();
        dp1.assignToCluster(7);
        dp1.assignToCluster(17);
    }
}

