/*
 * Decompiled with CFR 0.152.
 */
package jminhep.algorithms;

import java.util.Arrays;
import java.util.Random;
import jminhep.cluster.DataHolder;
import jminhep.cluster.DataPoint;
import jminhep.cluster.Get;
import jminhep.gui.SetEnv;
import jminhep.utils.ArrayOps;
import org.apache.commons.math3.util.FastMath;

public class KMeansAlg {
    private double[][] indat;
    private int nrow;
    private int ncol;
    private int Ierr = 0;
    private DataHolder cMeans;
    private DataHolder data;
    private DataPoint DMin;
    private DataPoint DMax;
    private String description;
    private int maxIterations;
    private int numClusters;
    private int iteration;
    private double epsilon;
    private double[][] clusterCenters;
    private double[][] clusterSeed;
    private double[] aPixel;
    private double compactness;
    private int[] clusterAssignmentCount;
    private int[] outputData;
    private double sumOfDistances;

    public KMeansAlg(DataHolder data) {
        this.data = data;
        this.nrow = data.getSize();
        this.ncol = data.getDimention();
        data.analyseSet();
        this.DMin = data.getMin();
        this.DMax = data.getMax();
        SetEnv.NRow = this.nrow;
        SetEnv.Dim = this.ncol;
        this.Ierr = 0;
        this.numClusters = 0;
        this.maxIterations = 100;
        this.epsilon = 1.0E-6;
        this.compactness = 0.0;
        this.description = "kmeans algorithm";
        this.indat = new double[this.nrow][this.ncol];
        this.aPixel = new double[this.ncol];
        this.outputData = new int[this.nrow];
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = data.getRow(i);
            for (int i2 = 0; i2 < this.ncol; ++i2) {
                this.indat[i][i2] = dp.getAttribute(i2);
            }
        }
    }

    public void setClusters(int numClusters) {
        if (numClusters > this.nrow) {
            System.out.println("Too many clusters! Set to number of points");
            numClusters = this.nrow;
        }
        this.numClusters = numClusters;
    }

    public int getClusters() {
        return this.numClusters;
    }

    public void generateSeed() {
        this.clusterSeed = new double[this.numClusters][this.ncol];
        Random gen = new Random();
        double[] a = new double[this.ncol];
        for (int j = 0; j < this.numClusters; ++j) {
            for (int m = 0; m < this.ncol; ++m) {
                a[m] = this.DMin.getAttribute(m) + gen.nextDouble() * (this.DMax.getAttribute(m) - this.DMin.getAttribute(m));
                this.clusterSeed[j][m] = a[m];
            }
        }
    }

    public void setSeed(double[][] seed) {
        this.clusterSeed = new double[this.numClusters][this.ncol];
        for (int j = 0; j < this.numClusters; ++j) {
            for (int m = 0; m < this.ncol; ++m) {
                this.clusterSeed[j][m] = seed[j][m];
            }
        }
    }

    public double[][] getSeed() {
        return this.clusterSeed;
    }

    public void setOptions(int maxIterations, double epsilon) {
        this.maxIterations = maxIterations;
        this.epsilon = epsilon;
    }

    public void delete() {
        this.numClusters = 0;
        this.maxIterations = 0;
        this.epsilon = 0.0;
        this.nrow = 0;
        this.ncol = 0;
        this.indat = null;
        this.clusterCenters = null;
        this.aPixel = null;
    }

    public DataHolder getCenters() {
        this.cMeans = new DataHolder();
        for (int i = 0; i < this.numClusters; ++i) {
            double[] a = new double[this.ncol];
            for (int j = 0; j < this.ncol; ++j) {
                a[j] = this.clusterCenters[i][j];
            }
            DataPoint c = new DataPoint(a, this.ncol);
            this.cMeans.add(c);
        }
        return this.cMeans;
    }

    public DataHolder getSeedHolder() {
        DataHolder tmp = new DataHolder();
        for (int i = 0; i < this.numClusters; ++i) {
            double[] a = new double[this.ncol];
            for (int j = 0; j < this.ncol; ++j) {
                a[j] = this.clusterSeed[i][j];
            }
            DataPoint c = new DataPoint(a, this.ncol);
            tmp.add(c);
        }
        return tmp;
    }

    public int[] getNumberPoints() {
        return this.clusterAssignmentCount;
    }

    public void run() {
        this.generateSeed();
        this.runKM();
        this.description = "kmeans algorithm fixed cluster mode with single seed event";
    }

    public void runKM() {
        this.iteration = 0;
        this.clusterCenters = new double[this.numClusters][this.ncol];
        this.clusterAssignmentCount = new int[this.numClusters];
        for (int j = 0; j < this.numClusters; ++j) {
            for (int m = 0; m < this.ncol; ++m) {
                this.clusterCenters[j][m] = this.clusterSeed[j][m];
            }
        }
        double lastSumOfDistances = 0.0;
        this.iteration = 0;
        while (this.iteration < this.maxIterations) {
            int cluster;
            int b;
            int h;
            Arrays.fill(this.clusterAssignmentCount, 0);
            for (h = 0; h < this.nrow; ++h) {
                int aClass;
                for (b = 0; b < this.ncol; ++b) {
                    this.aPixel[b] = this.indat[h][b];
                }
                this.outputData[h] = aClass = this.getClassFor(this.aPixel);
                int n = aClass;
                this.clusterAssignmentCount[n] = this.clusterAssignmentCount[n] + 1;
            }
            for (cluster = 0; cluster < this.numClusters; ++cluster) {
                Arrays.fill(this.clusterCenters[cluster], 0.0);
            }
            for (h = 0; h < this.nrow; ++h) {
                for (b = 0; b < this.ncol; ++b) {
                    int theCluster = this.outputData[h];
                    double[] dArray = this.clusterCenters[theCluster];
                    int n = b;
                    dArray[n] = dArray[n] + this.indat[h][b];
                }
            }
            for (cluster = 0; cluster < this.numClusters; ++cluster) {
                if (this.clusterAssignmentCount[cluster] <= 0) continue;
                b = 0;
                while (b < this.ncol) {
                    double[] dArray = this.clusterCenters[cluster];
                    int n = b++;
                    dArray[n] = dArray[n] / (double)this.clusterAssignmentCount[cluster];
                }
            }
            this.sumOfDistances = 0.0;
            for (h = 0; h < this.nrow; ++h) {
                int pixelsClass = this.outputData[h];
                double distance = 0.0;
                for (int b2 = 0; b2 < this.ncol; ++b2) {
                    double e1 = this.indat[h][b2];
                    double e2 = this.clusterCenters[pixelsClass][b2];
                    double diff = (e1 - e2) * (e1 - e2);
                    distance += diff;
                }
                distance = FastMath.sqrt((double)distance);
                this.sumOfDistances += distance;
            }
            if (this.iteration > 0 && FastMath.abs((double)(lastSumOfDistances - this.sumOfDistances)) < this.epsilon) break;
            lastSumOfDistances = this.sumOfDistances;
            ++this.iteration;
        }
        for (int i = 0; i < this.nrow; ++i) {
            DataPoint dp = this.data.getRow(i);
            dp.assignToCluster(this.outputData[i]);
        }
    }

    public double getCompactness() {
        this.compactness = Get.compactness(this.indat, this.outputData, this.numClusters, this.clusterCenters);
        return this.compactness;
    }

    public void run(int Iter) {
        double[] Sum = new double[Iter];
        double[][][] seeds = new double[Iter][this.numClusters][this.ncol];
        this.description = "kmeans algorithm with multiple seed events";
        for (int j = 0; j < Iter; ++j) {
            this.generateSeed();
            this.runKM();
            seeds[j] = this.getSeed();
            Sum[j] = Get.compactness(this.indat, this.outputData, this.numClusters, this.clusterCenters);
        }
        int ibest = ArrayOps.findSmallest(Sum, Iter);
        this.setSeed(seeds[ibest]);
        this.runKM();
        this.description = "kmeans algorithm for multiple iterations";
    }

    private int getClassFor(double[] pixel) {
        float closestSoFar = Float.MAX_VALUE;
        int classSoFar = 0;
        for (int cluster = 0; cluster < this.numClusters; cluster = (int)((short)(cluster + 1))) {
            float distance = 0.0f;
            for (int b = 0; b < this.ncol; ++b) {
                distance = (float)((double)distance + FastMath.abs((double)(this.clusterCenters[cluster][b] - pixel[b])));
            }
            if (!(distance < closestSoFar)) continue;
            closestSoFar = distance;
            classSoFar = cluster;
        }
        return classSoFar;
    }

    public int getError() {
        return this.Ierr;
    }

    public long getSize() {
        return this.maxIterations;
    }

    public String getName() {
        return this.description;
    }
}

