/*
 * Decompiled with CFR 0.152.
 */
package jvx.volume;

import java.awt.Color;
import java.util.Vector;
import jv.function.PuFunction;
import jv.geom.PgBndElementSet;
import jv.geom.PgEdgeStar;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgPolygonSet;
import jv.geom.PgTetraSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsDebug;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.project.PgGeometryIf;
import jv.vecmath.PdBary;
import jv.vecmath.PdMatrix;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuMath;
import jv.vecmath.PuReflect;
import jvx.geom.PgUtil;
import jvx.numeric.PnRootFinder;
import jvx.project.PjWorkshop;
import jvx.volume.PgTetraVertexStar;
import jvx.volume.PwTetraRivara;

public class PwTetraSet
extends PjWorkshop {
    protected PuDouble m_level = new PuDouble("Level", (PsUpdateIf)this);
    protected PgTetraSet m_tetraSet;
    protected PgElementSet m_surface;
    protected PuFunction m_function = new PuFunction(3, 1);
    public static final int INPUT_FUNCTION = 0;
    public static final int INPUT_SCALAR_DATA = 1;
    public int m_inputType = 0;
    protected PdVector m_scalarData;
    PwTetraRivara m_tetraRivara;
    private static final int[][] quadIntersection = new int[][]{{0, 3, 1, 2, 4, 5}, {1, 4, 0, 2, 3, 5}, {2, 5, 0, 4, 3, 1}};
    private static final int[][] triangleIntersection = new int[][]{{0, 4, 5, 1, 2, 3}, {1, 3, 5, 0, 4, 2}, {2, 3, 4, 0, 1, 5}, {0, 1, 2, 3, 4, 5}};
    private static final int[][] triangleIntersectionOneZero = new int[][]{{0, 4, 0, 1}, {4, 5, 0, 3}, {5, 0, 0, 2}, {1, 5, 1, 2}, {5, 3, 1, 3}, {3, 1, 1, 0}, {2, 3, 2, 0}, {3, 4, 2, 3}, {4, 2, 2, 1}, {0, 1, 3, 2}, {1, 2, 3, 0}, {2, 0, 3, 1}};
    private static final int[][] triangleIntersectionTwoZeros = new int[][]{{3, 0, 1}, {1, 3, 0}, {3, 2, 0}, {2, 1, 0}, {0, 2, 1}, {1, 0, 2}};
    private static final int[][] tetIntersectionFourZeros = new int[][]{{0, 3, 1, 2, 4, 1, 5, 2}, {0, 2, 3, 1, 5, 2, 0, 3}, {0, 1, 2, 3, 0, 3, 4, 1}};
    private static final int[][] tetIntersectionThreeZeros = new int[][]{{2, 1, 3, 1, 2, 3}, {0, 2, 4, 2, 0, 3}, {1, 0, 5, 0, 1, 3}, {4, 3, 5, 1, 0, 2}};
    private static final int[][] tetIntersectionTwoZeros = new int[][]{{1, 0, 3, 2, 0, 1}, {0, 2, 3, 1, 2, 0}, {4, 0, 0, 1, 3, 2}, {0, 5, 0, 2, 1, 3}, {2, 1, 3, 0, 1, 2}, {1, 3, 1, 0, 2, 3}, {5, 1, 1, 2, 3, 0}, {3, 2, 2, 0, 3, 1}, {2, 4, 2, 1, 0, 3}, {4, 3, 2, 3, 1, 0}, {3, 5, 1, 3, 0, 2}, {5, 4, 0, 3, 2, 1}};
    private static final int[][] tetIntersectionOneZero = new int[][]{{1, 2, 3, 0}, {0, 2, 1, 3}, {0, 1, 3, 2}, {0, 3, 2, 1}, {1, 3, 0, 2}, {2, 3, 1, 0}};
    static /* synthetic */ Class class$jvx$volume$PwTetraSet;

    public PwTetraSet() {
        super("TetraSet Refinement");
        if (((Object)((Object)this)).getClass() == (class$jvx$volume$PwTetraSet == null ? (class$jvx$volume$PwTetraSet = PwTetraSet.class$("jvx.volume.PwTetraSet")) : class$jvx$volume$PwTetraSet)) {
            this.init();
        }
    }

    public void init() {
        this.m_level.setDefBounds(-10.0, 10.0, 0.1, 1.0);
        this.m_level.setDefValue(0.0);
        this.m_level.init();
    }

    public boolean update(Object object) {
        if (object == this.m_level) {
            this.computeLevelSurface();
            this.m_surface.update((Object)this.m_surface);
            return true;
        }
        return super.update(object);
    }

    public PgElementSet getSurface() {
        return this.m_surface;
    }

    public void setGeometry(PgGeometry pgGeometry) {
        super.setGeometry(pgGeometry);
        this.m_tetraSet = (PgTetraSet)pgGeometry;
        this.m_surface = new PgElementSet(this.m_tetraSet.getDimOfVertices());
        this.m_surface.setName("Level Surface");
        this.m_surface.showElementBackColor(true);
        this.m_tetraRivara = new PwTetraRivara();
        this.m_tetraRivara.setGeometry((PgGeometry)this.m_tetraSet);
    }

    public void setInputType(int n) {
        this.m_inputType = n;
    }

    public int getInputType() {
        return this.m_inputType;
    }

    public void setScalarData(PdVector pdVector) {
        this.m_scalarData = pdVector;
    }

    public PdVector getScalarData() {
        return this.m_scalarData;
    }

    public void setLevelValue(double d) {
        this.m_level.setValue(d);
    }

    public double getLevelValue() {
        return this.m_level.getValue();
    }

    public void getPositiveTetraSet() {
        if (this.m_display != null) {
            if (this.m_inputType == 0) {
                this.m_display.addGeometry((PgGeometryIf)PwTetraSet.intersectTetraSet(this.m_tetraSet, null, this.m_function, this.m_level.getValue(), true));
            } else {
                this.m_display.addGeometry((PgGeometryIf)PwTetraSet.intersectTetraSet(this.m_tetraSet, null, this.m_scalarData, this.m_level.getValue(), true));
            }
        } else {
            PsDebug.warning((String)"Missing display");
        }
    }

    public void getNegativeTetraSet() {
        if (this.m_display != null) {
            if (this.m_inputType == 0) {
                this.m_display.addGeometry((PgGeometryIf)PwTetraSet.intersectTetraSet(this.m_tetraSet, null, this.m_function, this.m_level.getValue(), false));
            } else {
                this.m_display.addGeometry((PgGeometryIf)PwTetraSet.intersectTetraSet(this.m_tetraSet, null, this.m_scalarData, this.m_level.getValue(), false));
            }
        } else {
            PsDebug.warning((String)"Missing display");
        }
    }

    public PgElementSet computeLevelSurface() {
        if (this.m_inputType == 0) {
            return PwTetraSet.getLevelSurface(this.m_tetraSet, this.m_surface, this.m_function, this.m_level.getValue());
        }
        return PwTetraSet.getLevelSurface(this.m_tetraSet, this.m_surface, this.m_scalarData, this.m_level.getValue());
    }

    public void globalRefine() {
        PwTetraRivara.refineGlobalIntoEight(this.m_tetraSet);
        this.m_tetraSet.update((Object)this.m_tetraSet);
    }

    public void rivaraRefine() {
        if (this.m_inputType == 0) {
            this.m_tetraRivara.refine(PwTetraSet.grepValue(this.m_tetraSet, this.m_function, this.m_level.getValue()));
        } else {
            this.m_tetraRivara.refine(PwTetraSet.grepValue(this.m_tetraSet, this.m_scalarData, this.m_level.getValue()));
        }
        this.m_tetraSet.update((Object)this.m_tetraSet);
    }

    public void colorVertices() {
        int n = this.m_tetraSet.getNumVertices();
        float[] fArray = new float[n];
        for (int i = 0; i < n; ++i) {
            fArray[i] = this.m_inputType == 0 ? (float)this.m_function.eval(0, this.m_tetraSet.getVertex(i).getEntries()) : (float)this.m_scalarData.m_data[i];
        }
        PwTetraSet.colorVertices((PgPointSet)this.m_tetraSet, fArray);
        this.m_tetraSet.update((Object)this.m_tetraSet);
    }

    public static Vector grepValue(PgTetraSet pgTetraSet, PuFunction puFunction, double d) {
        Vector<Integer> vector = new Vector<Integer>();
        PdVector pdVector = new PdVector(pgTetraSet.getDimOfVertices());
        double[] dArray = new double[1];
        int n = pgTetraSet.getNumTetras();
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector = pgTetraSet.getTetra(i);
            pdVector.copyArray(pgTetraSet.getVertex(piVector.getEntry(0)));
            puFunction.eval(dArray, pdVector.m_data);
            int n2 = PuMath.sign((double)(dArray[0] - d));
            for (int j = 1; j < 4; ++j) {
                pdVector.copyArray(pgTetraSet.getVertex(piVector.getEntry(j)));
                puFunction.eval(dArray, pdVector.m_data);
                if (PuMath.sign((double)(dArray[0] - d)) == n2) continue;
                vector.addElement(new Integer(i));
                continue block0;
            }
        }
        return vector;
    }

    public static Vector grepValue(PgTetraSet pgTetraSet, PdVector pdVector, double d) {
        Vector<Integer> vector = new Vector<Integer>();
        int n = pgTetraSet.getNumTetras();
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector = pgTetraSet.getTetra(i);
            int n2 = PuMath.sign((double)(pdVector.m_data[piVector.getEntry(0)] - d));
            for (int j = 1; j < 4; ++j) {
                if (PuMath.sign((double)(pdVector.m_data[piVector.getEntry(j)] - d)) == n2) continue;
                vector.addElement(new Integer(i));
                continue block0;
            }
        }
        return vector;
    }

    public static PgElementSet getLevelSurface(PgTetraSet pgTetraSet, PgElementSet pgElementSet, PuFunction puFunction, double d) {
        PgElementSet pgElementSet2 = pgElementSet == null ? new PgElementSet(pgTetraSet.getDimOfVertices()) : pgElementSet;
        Vector vector = new Vector();
        int n = pgTetraSet.getNumTetras();
        int n2 = pgTetraSet.getNumVertices();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = puFunction.eval(0, pgTetraSet.getVertex((int)i).m_data) - d;
        }
        PiVector[] piVectorArray = new PiVector[n];
        PiVector.realloc((PiVector[])piVectorArray, (int)n, (int)6);
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector(n2);
        PwTetraSet.computeLevelVertices(pgTetraSet, dArray, puFunction, d, vector, piVectorArray, piVector, piVector2, 0.0);
        int n3 = vector.size();
        pgElementSet2.setNumVertices(n3);
        for (int i = 0; i < n3; ++i) {
            pgElementSet2.setVertex(i, (PdVector)vector.elementAt(i));
        }
        Vector vector2 = new Vector();
        PwTetraSet.getSurfaceConnectivity(pgTetraSet, piVector2, piVector, piVectorArray, dArray, vector2);
        int n4 = vector2.size();
        pgElementSet2.setNumElements(n4);
        for (int i = 0; i < n4; ++i) {
            pgElementSet2.setElement(i, (PiVector)vector2.elementAt(i));
        }
        pgElementSet2.makeVertexNormals();
        pgElementSet2.makeElementNormals();
        pgElementSet2.makeNeighbour();
        return pgElementSet2;
    }

    public static PgElementSet getLevelSurface(PgTetraSet pgTetraSet, PgElementSet pgElementSet, PdVector pdVector, double d) {
        PgElementSet pgElementSet2 = pgElementSet == null ? new PgElementSet(pgTetraSet.getDimOfVertices()) : pgElementSet;
        Vector vector = new Vector();
        int n = pgTetraSet.getNumTetras();
        int n2 = pgTetraSet.getNumVertices();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = pdVector.m_data[i] - d;
        }
        PiVector[] piVectorArray = new PiVector[n];
        PiVector.realloc((PiVector[])piVectorArray, (int)n, (int)6);
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector(n2);
        PwTetraSet.computeLevelVertices(pgTetraSet, dArray, pdVector, d, vector, piVectorArray, piVector, piVector2, 0.0);
        int n3 = vector.size();
        pgElementSet2.setNumVertices(n3);
        for (int i = 0; i < n3; ++i) {
            pgElementSet2.setVertex(i, (PdVector)vector.elementAt(i));
        }
        Vector vector2 = new Vector();
        PwTetraSet.getSurfaceConnectivity(pgTetraSet, piVector2, piVector, piVectorArray, dArray, vector2);
        int n4 = vector2.size();
        pgElementSet2.setNumElements(n4);
        for (int i = 0; i < n4; ++i) {
            pgElementSet2.setElement(i, (PiVector)vector2.elementAt(i));
        }
        pgElementSet2.makeVertexNormals();
        pgElementSet2.makeElementNormals();
        pgElementSet2.makeNeighbour();
        return pgElementSet2;
    }

    public static PgTetraSet intersectTetraSet(PgTetraSet pgTetraSet, PgTetraSet pgTetraSet2, PuFunction puFunction, double d, boolean bl) {
        PgTetraSet pgTetraSet3;
        if (pgTetraSet2 == null) {
            pgTetraSet3 = new PgTetraSet(pgTetraSet.getDimOfVertices());
            if (bl) {
                pgTetraSet3.setName(pgTetraSet.getName() + " +");
            } else {
                pgTetraSet3.setName(pgTetraSet.getName() + " -");
            }
        } else {
            pgTetraSet3 = pgTetraSet2;
        }
        Vector vector = new Vector();
        int n = pgTetraSet.getNumTetras();
        int n2 = pgTetraSet.getNumVertices();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = puFunction.eval(0, pgTetraSet.getVertex((int)i).m_data) - d;
        }
        PiVector[] piVectorArray = new PiVector[n];
        PiVector.realloc((PiVector[])piVectorArray, (int)n, (int)6);
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector(n2);
        double d2 = 1.0;
        if (!bl) {
            d2 = -1.0;
        }
        PwTetraSet.computeLevelVertices(pgTetraSet, dArray, puFunction, d, vector, piVectorArray, piVector, piVector2, d2);
        int n3 = vector.size();
        pgTetraSet3.setNumVertices(n3);
        for (int i = 0; i < n3; ++i) {
            pgTetraSet3.setVertex(i, (PdVector)vector.elementAt(i));
        }
        Vector vector2 = new Vector();
        PwTetraSet.getIntersectedTetraConnectivity(pgTetraSet, piVector2, piVector, piVectorArray, dArray, vector2, d2);
        int n4 = vector2.size();
        pgTetraSet3.setNumTetras(n4);
        for (int i = 0; i < n4; ++i) {
            PiVector piVector3 = (PiVector)vector2.elementAt(i);
            pgTetraSet3.setTetra(i, piVector3);
        }
        pgTetraSet3.makeNeighbour();
        return pgTetraSet3;
    }

    public static PgTetraSet intersectTetraSet(PgTetraSet pgTetraSet, PgTetraSet pgTetraSet2, PdVector pdVector, double d, boolean bl) {
        PgTetraSet pgTetraSet3;
        if (pgTetraSet2 == null) {
            pgTetraSet3 = new PgTetraSet(pgTetraSet.getDimOfVertices());
            if (bl) {
                pgTetraSet3.setName(pgTetraSet.getName() + " +");
            } else {
                pgTetraSet3.setName(pgTetraSet.getName() + " -");
            }
        } else {
            pgTetraSet3 = pgTetraSet2;
        }
        Vector vector = new Vector();
        int n = pgTetraSet.getNumTetras();
        int n2 = pgTetraSet.getNumVertices();
        double[] dArray = new double[n2];
        for (int i = 0; i < n2; ++i) {
            dArray[i] = pdVector.m_data[i] - d;
        }
        PiVector[] piVectorArray = new PiVector[n];
        PiVector.realloc((PiVector[])piVectorArray, (int)n, (int)6);
        PiVector piVector = new PiVector();
        PiVector piVector2 = new PiVector(n2);
        double d2 = 1.0;
        if (!bl) {
            d2 = -1.0;
        }
        PwTetraSet.computeLevelVertices(pgTetraSet, dArray, pdVector, d, vector, piVectorArray, piVector, piVector2, d2);
        int n3 = vector.size();
        pgTetraSet3.setNumVertices(n3);
        for (int i = 0; i < n3; ++i) {
            pgTetraSet3.setVertex(i, (PdVector)vector.elementAt(i));
        }
        Vector vector2 = new Vector();
        PwTetraSet.getIntersectedTetraConnectivity(pgTetraSet, piVector2, piVector, piVectorArray, dArray, vector2, d2);
        int n4 = vector2.size();
        pgTetraSet3.setNumTetras(n4);
        for (int i = 0; i < n4; ++i) {
            PiVector piVector3 = (PiVector)vector2.elementAt(i);
            pgTetraSet3.setTetra(i, piVector3);
        }
        pgTetraSet3.makeNeighbour();
        return pgTetraSet3;
    }

    protected static void computeLevelVertices(PgTetraSet pgTetraSet, double[] dArray, PuFunction puFunction, double d, Vector vector, PiVector[] piVectorArray, PiVector piVector, PiVector piVector2, double d2) {
        int n;
        int n2 = pgTetraSet.getNumVertices();
        PgEdgeStar[] pgEdgeStarArray = pgTetraSet.makeEdgeStars();
        int n3 = pgEdgeStarArray.length;
        piVector.setSize(n3);
        piVector.setConstant(-1);
        for (n = 0; n < n2; ++n) {
            if (dArray[n] == 0.0 || dArray[n] * d2 > 0.0) {
                piVector2.m_data[n] = vector.size();
                vector.addElement(PdVector.copyNew((PdVector)pgTetraSet.getVertex(n)));
                continue;
            }
            piVector2.m_data[n] = -1;
        }
        for (n = 0; n < n3; ++n) {
            int n4 = pgEdgeStarArray[n].getValence();
            for (int i = 0; i < n4; ++i) {
                piVectorArray[pgEdgeStarArray[n].getElementInd((int)i)].m_data[pgEdgeStarArray[n].getNeighbourLocInd((int)i)] = n;
            }
            if (dArray[pgEdgeStarArray[n].m_data[0]] * dArray[pgEdgeStarArray[n].m_data[1]] < 0.0) {
                piVector.m_data[n] = vector.size();
                if (puFunction != null) {
                    double[] dArray2 = PnRootFinder.findValue(puFunction, pgTetraSet.getVertex((int)pgEdgeStarArray[n].m_data[0]).m_data, pgTetraSet.getVertex((int)pgEdgeStarArray[n].m_data[1]).m_data, d);
                    vector.addElement(new PdVector(dArray2));
                    continue;
                }
                vector.addElement(PdVector.blendNew((double)(dArray[pgEdgeStarArray[n].m_data[1]] / (dArray[pgEdgeStarArray[n].m_data[1]] - dArray[pgEdgeStarArray[n].m_data[0]])), (PdVector)pgTetraSet.getVertex(pgEdgeStarArray[n].m_data[0]), (double)(dArray[pgEdgeStarArray[n].m_data[0]] / (dArray[pgEdgeStarArray[n].m_data[0]] - dArray[pgEdgeStarArray[n].m_data[1]])), (PdVector)pgTetraSet.getVertex(pgEdgeStarArray[n].m_data[1])));
                continue;
            }
            piVector.m_data[n] = -1;
        }
    }

    protected static void computeLevelVertices(PgTetraSet pgTetraSet, double[] dArray, PdVector pdVector, double d, Vector vector, PiVector[] piVectorArray, PiVector piVector, PiVector piVector2, double d2) {
        int n;
        int n2 = pgTetraSet.getNumVertices();
        PgEdgeStar[] pgEdgeStarArray = pgTetraSet.makeEdgeStars();
        int n3 = pgEdgeStarArray.length;
        piVector.setSize(n3);
        piVector.setConstant(-1);
        for (n = 0; n < n2; ++n) {
            if (dArray[n] == 0.0 || dArray[n] * d2 > 0.0) {
                piVector2.m_data[n] = vector.size();
                vector.addElement(PdVector.copyNew((PdVector)pgTetraSet.getVertex(n)));
                continue;
            }
            piVector2.m_data[n] = -1;
        }
        for (n = 0; n < n3; ++n) {
            int n4 = pgEdgeStarArray[n].getValence();
            for (int i = 0; i < n4; ++i) {
                piVectorArray[pgEdgeStarArray[n].getElementInd((int)i)].m_data[pgEdgeStarArray[n].getNeighbourLocInd((int)i)] = n;
            }
            if (dArray[pgEdgeStarArray[n].m_data[0]] * dArray[pgEdgeStarArray[n].m_data[1]] < 0.0) {
                piVector.m_data[n] = vector.size();
                vector.addElement(PdVector.blendNew((double)(dArray[pgEdgeStarArray[n].m_data[1]] / (dArray[pgEdgeStarArray[n].m_data[1]] - dArray[pgEdgeStarArray[n].m_data[0]])), (PdVector)pgTetraSet.getVertex(pgEdgeStarArray[n].m_data[0]), (double)(dArray[pgEdgeStarArray[n].m_data[0]] / (dArray[pgEdgeStarArray[n].m_data[0]] - dArray[pgEdgeStarArray[n].m_data[1]])), (PdVector)pgTetraSet.getVertex(pgEdgeStarArray[n].m_data[1])));
                continue;
            }
            piVector.m_data[n] = -1;
        }
    }

    private static void getSurfaceConnectivity(PgTetraSet pgTetraSet, PiVector piVector, PiVector piVector2, PiVector[] piVectorArray, double[] dArray, Vector vector) {
        int n = pgTetraSet.getNumTetras();
        for (int i = 0; i < n; ++i) {
            int n2;
            int n3;
            int n4 = 0;
            for (n3 = 0; n3 < 6; ++n3) {
                if (piVector2.m_data[piVectorArray[i].m_data[n3]] == -1) continue;
                ++n4;
            }
            if (n4 == 4) {
                PiVector piVector3 = new PiVector(4);
                for (n2 = 0; n2 < 3; ++n2) {
                    if (piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][0]]] != -1 || piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][1]]] != -1) continue;
                    piVector3.m_data[0] = piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][2]]];
                    piVector3.m_data[2] = piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][4]]];
                    if (dArray[pgTetraSet.getTetra((int)i).m_data[0]] > 0.0) {
                        piVector3.m_data[1] = piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][3]]];
                        piVector3.m_data[3] = piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][5]]];
                        continue;
                    }
                    piVector3.m_data[1] = piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][5]]];
                    piVector3.m_data[3] = piVector2.m_data[piVectorArray[i].m_data[quadIntersection[n2][3]]];
                }
                vector.addElement(piVector3);
                continue;
            }
            if (n4 == 3) {
                PiVector piVector4 = new PiVector(3);
                for (n2 = 0; n2 < 4; ++n2) {
                    if (piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][0]]] != -1 || piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][1]]] != -1 || piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][2]]] != -1) continue;
                    piVector4.m_data[0] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][3]]];
                    if (dArray[pgTetraSet.getTetra((int)i).m_data[n2]] > 0.0) {
                        piVector4.m_data[1] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][4]]];
                        piVector4.m_data[2] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][5]]];
                        continue;
                    }
                    piVector4.m_data[1] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][5]]];
                    piVector4.m_data[2] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersection[n2][4]]];
                }
                vector.addElement(piVector4);
                continue;
            }
            if (n4 == 2) {
                PiVector piVector5 = new PiVector(3);
                for (n2 = 0; n2 < 12; ++n2) {
                    if (piVector2.m_data[piVectorArray[i].m_data[triangleIntersectionOneZero[n2][0]]] == -1 || piVector2.m_data[piVectorArray[i].m_data[triangleIntersectionOneZero[n2][1]]] == -1) continue;
                    piVector5.m_data[0] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionOneZero[n2][2]]];
                    if (dArray[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionOneZero[n2][3]]] > 0.0) {
                        piVector5.m_data[1] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersectionOneZero[n2][0]]];
                        piVector5.m_data[2] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersectionOneZero[n2][1]]];
                        continue;
                    }
                    piVector5.m_data[1] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersectionOneZero[n2][1]]];
                    piVector5.m_data[2] = piVector2.m_data[piVectorArray[i].m_data[triangleIntersectionOneZero[n2][0]]];
                }
                vector.addElement(piVector5);
                continue;
            }
            if (n4 == 1) {
                PiVector piVector6 = new PiVector(3);
                for (n2 = 0; n2 < 6; ++n2) {
                    if (piVector2.m_data[piVectorArray[i].m_data[n2]] == -1) continue;
                    piVector6.m_data[0] = piVector2.m_data[piVectorArray[i].m_data[n2]];
                    if (dArray[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionTwoZeros[n2][2]]] > 0.0) {
                        piVector6.m_data[1] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionTwoZeros[n2][0]]];
                        piVector6.m_data[2] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionTwoZeros[n2][1]]];
                        continue;
                    }
                    piVector6.m_data[1] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionTwoZeros[n2][1]]];
                    piVector6.m_data[2] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[triangleIntersectionTwoZeros[n2][0]]];
                }
                vector.addElement(piVector6);
                continue;
            }
            if (n4 != 0) continue;
            n3 = 0;
            n2 = -1;
            for (int j = 0; j < 4; ++j) {
                if (piVector.m_data[pgTetraSet.getTetra((int)i).m_data[j]] != -1) {
                    ++n3;
                    continue;
                }
                n2 = j;
            }
            if (n3 != 3 || pgTetraSet.getNeighbour((int)i).m_data[n2] >= i) continue;
            PiVector piVector7 = new PiVector(3);
            piVector7.m_data[0] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[(n2 + 1) % 4]];
            if (n2 % 2 == 1 && dArray[pgTetraSet.getTetra((int)i).m_data[n2]] > 0.0 || n2 % 2 == 0 && dArray[pgTetraSet.getTetra((int)i).m_data[n2]] < 0.0) {
                piVector7.m_data[1] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[(n2 + 2) % 4]];
                piVector7.m_data[2] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[(n2 + 3) % 4]];
            } else {
                piVector7.m_data[1] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[(n2 + 3) % 4]];
                piVector7.m_data[2] = piVector.m_data[pgTetraSet.getTetra((int)i).m_data[(n2 + 2) % 4]];
            }
            vector.addElement(piVector7);
        }
    }

    private static void getIntersectedTetraConnectivity(PgTetraSet pgTetraSet, PiVector piVector, PiVector piVector2, PiVector[] piVectorArray, double[] dArray, Vector vector, double d) {
        int n = pgTetraSet.getNumTetras();
        block0: for (int i = 0; i < n; ++i) {
            PiVector piVector3;
            PiVector piVector4;
            int n2 = 0;
            for (int j = 0; j < 6; ++j) {
                if (piVector2.m_data[piVectorArray[i].m_data[j]] == -1) continue;
                ++n2;
            }
            if (n2 == 4) {
                PiVector piVector5 = pgTetraSet.getTetra(i);
                for (int j = 0; j < 3; ++j) {
                    if (piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]] == -1 || piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]] == -1) continue;
                    if (dArray[piVector5.m_data[tetIntersectionFourZeros[j][0]]] * d > 0.0) {
                        if (piVector5.m_data[tetIntersectionFourZeros[j][0]] < piVector5.m_data[tetIntersectionFourZeros[j][1]]) {
                            PiVector piVector6 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][0]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]], piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][1]]]);
                            vector.addElement(piVector6);
                            piVector4 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][0]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]]);
                            vector.addElement(piVector4);
                            piVector3 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][0]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][7]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]]);
                            vector.addElement(piVector3);
                            continue block0;
                        }
                        PiVector piVector7 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][1]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][7]]], piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][0]]]);
                        vector.addElement(piVector7);
                        piVector4 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][1]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][7]]]);
                        vector.addElement(piVector4);
                        piVector3 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][1]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]]);
                        vector.addElement(piVector3);
                        continue block0;
                    }
                    if (piVector5.m_data[tetIntersectionFourZeros[j][2]] < piVector5.m_data[tetIntersectionFourZeros[j][3]]) {
                        PiVector piVector8 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][2]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]], piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][3]]]);
                        vector.addElement(piVector8);
                        piVector4 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][2]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]]);
                        vector.addElement(piVector4);
                        piVector3 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][2]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][7]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]]);
                        vector.addElement(piVector3);
                        continue block0;
                    }
                    PiVector piVector9 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][7]]], piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][2]]]);
                    vector.addElement(piVector9);
                    piVector4 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][7]]]);
                    vector.addElement(piVector4);
                    piVector3 = new PiVector(piVector.m_data[piVector5.m_data[tetIntersectionFourZeros[j][3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][4]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][6]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionFourZeros[j][5]]]);
                    vector.addElement(piVector3);
                    continue block0;
                }
                continue;
            }
            if (n2 == 3) {
                PiVector piVector10 = pgTetraSet.getTetra(i);
                for (int j = 0; j < 4; ++j) {
                    if (piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][0]]] == -1 || piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][1]]] == -1 || piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][2]]] == -1) continue;
                    if (dArray[piVector10.m_data[j]] * d > 0.0) {
                        PiVector piVector11 = new PiVector(piVector.m_data[piVector10.m_data[j]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][0]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][1]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][2]]]);
                        vector.addElement(piVector11);
                        continue block0;
                    }
                    for (int k = 0; k < 3; ++k) {
                        PiVector piVector12;
                        if (piVector10.m_data[tetIntersectionThreeZeros[j][3 + (0 + k) % 3]] < piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]] && piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]] < piVector10.m_data[tetIntersectionThreeZeros[j][3 + (2 + k) % 3]]) {
                            piVector4 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(2 + k) % 3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(0 + k) % 3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(1 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (0 + k) % 3]]]);
                            vector.addElement(piVector4);
                            piVector3 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(2 + k) % 3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(1 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (0 + k) % 3]]]);
                            vector.addElement(piVector3);
                            piVector12 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(2 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (2 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (0 + k) % 3]]]);
                            vector.addElement(piVector12);
                            continue block0;
                        }
                        if (piVector10.m_data[tetIntersectionThreeZeros[j][3 + (0 + k) % 3]] <= piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]] || piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]] <= piVector10.m_data[tetIntersectionThreeZeros[j][3 + (2 + k) % 3]]) continue;
                        piVector4 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(0 + k) % 3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(1 + k) % 3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(2 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (2 + k) % 3]]]);
                        vector.addElement(piVector4);
                        piVector3 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(0 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(1 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (2 + k) % 3]]]);
                        vector.addElement(piVector3);
                        piVector12 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionThreeZeros[j][(0 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (0 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (1 + k) % 3]]], piVector.m_data[piVector10.m_data[tetIntersectionThreeZeros[j][3 + (2 + k) % 3]]]);
                        vector.addElement(piVector12);
                        continue block0;
                    }
                    continue block0;
                }
                continue;
            }
            if (n2 == 2) {
                PiVector piVector13 = pgTetraSet.getTetra(i);
                for (int j = 0; j < 12; ++j) {
                    if (piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][0]]] == -1 || piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][1]]] == -1) continue;
                    if (dArray[piVector13.m_data[tetIntersectionTwoZeros[j][3]]] * d > 0.0) {
                        PiVector piVector14 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][0]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][1]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][3]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][2]]]);
                        vector.addElement(piVector14);
                        continue block0;
                    }
                    if (piVector13.m_data[tetIntersectionTwoZeros[j][4]] < piVector13.m_data[tetIntersectionTwoZeros[j][5]]) {
                        PiVector piVector15 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][1]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][4]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][5]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][2]]]);
                        vector.addElement(piVector15);
                        piVector4 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][1]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][0]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][4]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][2]]]);
                        vector.addElement(piVector4);
                        continue block0;
                    }
                    PiVector piVector16 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][0]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][4]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][5]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][2]]]);
                    vector.addElement(piVector16);
                    piVector4 = new PiVector(piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][1]]], piVector2.m_data[piVectorArray[i].m_data[tetIntersectionTwoZeros[j][0]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][5]]], piVector.m_data[piVector13.m_data[tetIntersectionTwoZeros[j][2]]]);
                    vector.addElement(piVector4);
                    continue block0;
                }
                continue;
            }
            if (n2 == 1) {
                PiVector piVector17 = new PiVector(4);
                PiVector piVector18 = pgTetraSet.getTetra(i);
                for (int j = 0; j < 6; ++j) {
                    if (piVector2.m_data[piVectorArray[i].m_data[j]] == -1) continue;
                    piVector17.m_data[0] = piVector2.m_data[piVectorArray[i].m_data[j]];
                    if (dArray[piVector18.m_data[tetIntersectionOneZero[j][0]]] * d > 0.0) {
                        piVector17.m_data[1] = piVector.m_data[piVector18.m_data[tetIntersectionOneZero[j][0]]];
                        piVector17.m_data[2] = piVector.m_data[piVector18.m_data[tetIntersectionOneZero[j][2]]];
                        piVector17.m_data[3] = piVector.m_data[piVector18.m_data[tetIntersectionOneZero[j][3]]];
                        break;
                    }
                    piVector17.m_data[1] = piVector.m_data[piVector18.m_data[tetIntersectionOneZero[j][1]]];
                    piVector17.m_data[2] = piVector.m_data[piVector18.m_data[tetIntersectionOneZero[j][3]]];
                    piVector17.m_data[3] = piVector.m_data[piVector18.m_data[tetIntersectionOneZero[j][2]]];
                    break;
                }
                vector.addElement(piVector17);
                continue;
            }
            if (n2 != 0) continue;
            PiVector piVector19 = pgTetraSet.getTetra(i);
            if (!(dArray[piVector19.m_data[0]] * d >= 0.0) || !(dArray[piVector19.m_data[1]] * d >= 0.0) || !(dArray[piVector19.m_data[2]] * d >= 0.0) || !(dArray[piVector19.m_data[3]] * d >= 0.0)) continue;
            PiVector piVector20 = new PiVector(piVector.m_data[piVector19.m_data[0]], piVector.m_data[piVector19.m_data[1]], piVector.m_data[piVector19.m_data[2]], piVector.m_data[piVector19.m_data[3]]);
            vector.addElement(piVector20);
        }
    }

    public static void intersect(PgTetraSet pgTetraSet, PgElementSet pgElementSet, PuFunction puFunction) {
        PwTetraSet.intersect(pgTetraSet, pgElementSet, puFunction, 0.0);
    }

    public static void intersect(PgTetraSet pgTetraSet, PgElementSet pgElementSet, PuFunction puFunction, double d) {
        PwTetraSet.getLevelSurface(pgTetraSet, pgElementSet, puFunction, d);
    }

    public static boolean is3Dim(double[][] dArray) {
        int n = 3;
        int n2 = 3;
        if (dArray.length < n + 1) {
            PsDebug.warning((String)(n + 1 + "Vertices expected, but " + dArray.length + " passed - skipping."));
            return false;
        }
        if (dArray[0].length != n2 || dArray[1].length != n2 || dArray[2].length != n2 || dArray[3].length != n2) {
            PsDebug.warning((String)("Wrong vertex dimension (" + n2 + "expected) - skipping."));
            return false;
        }
        double[][] dArray2 = new double[n][n2];
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                dArray2[i][j] = dArray[i][j] - dArray[n][j];
            }
        }
        return dArray2[0][0] * (dArray2[1][1] * dArray2[2][2] - dArray2[2][1] * dArray2[1][2]) - dArray2[0][1] * (dArray2[1][0] * dArray2[2][2] - dArray2[2][0] * dArray2[1][2]) + dArray2[0][2] * (dArray2[1][0] * dArray2[2][1] - dArray2[2][0] * dArray2[1][1]) != 0.0;
    }

    public int removeNonIntersectingTetrahedra(boolean bl) {
        return PwTetraSet.removeNonIntersectingTetrahedra(this.m_tetraSet, this.m_function, this.m_level.getValue(), bl);
    }

    public static int removeNonIntersectingTetrahedra(PgTetraSet pgTetraSet, PuFunction puFunction, double d, boolean bl) {
        int n;
        int n2 = 0;
        int n3 = pgTetraSet.getNumTetras();
        int n4 = pgTetraSet.getNumVertices();
        double[] dArray = new double[n4];
        if (bl) {
            for (n = 0; n < n4; ++n) {
                dArray[n] = puFunction.eval(0, pgTetraSet.getVertex((int)n).m_data) - d;
            }
        } else {
            for (n = 0; n < n4; ++n) {
                dArray[n] = -puFunction.eval(0, pgTetraSet.getVertex((int)n).m_data) + d;
            }
        }
        for (n = 0; n < n3; ++n) {
            PiVector piVector = pgTetraSet.getTetra(n);
            boolean bl2 = false;
            for (int i = 0; i < 4; ++i) {
                if (!(dArray[piVector.m_data[i]] <= 0.0)) continue;
                bl2 = true;
                break;
            }
            if (bl2) continue;
            piVector.setTag(2);
            ++n2;
        }
        pgTetraSet.removeMarkedTetras();
        return n2;
    }

    public static float[] colorVertices(PgPointSet pgPointSet, float[] fArray) {
        float f;
        float f2;
        int n;
        int n2 = fArray.length;
        int n3 = pgPointSet.getNumVertices();
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        float f3 = fArray[0];
        float f4 = fArray[0];
        for (n = 0; n < n2; ++n) {
            f2 = fArray[n];
            if (Float.isNaN(f2)) continue;
            if (f3 > f2) {
                f3 = f2;
            }
            if (!(f4 < f2)) continue;
            f4 = f2;
        }
        if (Float.isNaN(f3) || Float.isNaN(f4) || Float.isInfinite(f3) || Float.isInfinite(f4)) {
            PsDebug.warning((String)"No valid data found.");
            return null;
        }
        float f5 = f = 0.25f;
        float f6 = f5 + f;
        float f7 = f6 + f;
        Color[] colorArray = new Color[n3];
        int n4 = n3 > n2 ? n2 : n3;
        for (n = 0; n < n4; ++n) {
            f2 = (fArray[n] - f3) / (f4 - f3);
            Color color = Float.isNaN(f2 = (float)Math.sqrt(f2)) ? Color.black : (f2 < f5 ? new Color(0.0f, f2 / f, 1.0f) : (f2 < f6 ? new Color(0.0f, 1.0f, (f6 - f2) / f) : (f2 < f7 ? new Color((f2 - f6) / f, 1.0f, 0.0f) : new Color(1.0f, (1.0f - f2) / f, 0.0f))));
            colorArray[n] = color;
        }
        for (n = n4; n < n3; ++n) {
            colorArray[n] = Color.black;
        }
        pgPointSet.setVertexColors(colorArray);
        pgPointSet.showVertexColors(true);
        return new float[]{f3, f4};
    }

    public static void makeBoundary(PgTetraSet pgTetraSet) {
        int n;
        int n2;
        PiVector piVector;
        PgBndElementSet[] pgBndElementSetArray = new PgBndElementSet[]{new PgBndElementSet(pgTetraSet.getDimOfVertices())};
        pgBndElementSetArray[0].setTetraSet(pgTetraSet);
        int n3 = pgTetraSet.getNumTetras();
        int n4 = pgTetraSet.getNumVertices();
        int n5 = 0;
        PiVector piVector2 = new PiVector(n4);
        piVector2.setConstant(-1);
        int n6 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < 4; ++j) {
                if (pgTetraSet.getNeighbour((int)i).m_data[j] != -1) continue;
                piVector = pgTetraSet.getTetra(i);
                for (n2 = 1; n2 < 4; ++n2) {
                    if (piVector2.m_data[piVector.m_data[(j + n2) % 4]] != -1) continue;
                    piVector2.m_data[piVector.m_data[(j + n2) % 4]] = n6++;
                }
                ++n5;
            }
        }
        PiVector[] piVectorArray = new PiVector[n5];
        PiVector piVector3 = new PiVector(n5);
        piVector = new PiVector(n5);
        n5 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 4; ++n) {
                if (pgTetraSet.getNeighbour((int)n2).m_data[n] != -1) continue;
                PiVector piVector4 = pgTetraSet.getTetra(n2);
                piVectorArray[n5] = new PiVector(3);
                piVector3.m_data[n5] = n2;
                piVector.m_data[n5] = n;
                for (int i = 0; i < 3; ++i) {
                    piVectorArray[n5].m_data[i] = n % 2 == 0 ? piVector2.m_data[piVector4.m_data[(n + i + 1) % 4]] : piVector2.m_data[piVector4.m_data[(n + (3 - i) % 3 + 1) % 4]];
                }
                ++n5;
            }
        }
        PiVector piVector5 = new PiVector(n6);
        for (n = 0; n < n4; ++n) {
            if (piVector2.m_data[n] == -1) continue;
            piVector5.m_data[piVector2.m_data[n]] = n;
        }
        pgBndElementSetArray[0].setNumVertices(n6);
        pgBndElementSetArray[0].setNumElements(n5);
        pgBndElementSetArray[0].setElements(piVectorArray);
        pgBndElementSetArray[0].setVertexInd(piVector5);
        pgBndElementSetArray[0].setTetraInd(piVector3);
        pgBndElementSetArray[0].setNeighbourLocInd(piVector);
        pgBndElementSetArray[0].assignVertices();
        pgBndElementSetArray[0].setName("Bnd[0] of " + pgTetraSet.getName());
        pgBndElementSetArray[0].showEdges(false);
        pgBndElementSetArray[0].showVertices(false);
        pgBndElementSetArray[0].showElements(true);
        pgBndElementSetArray[0].showElementBackColor(true);
        pgBndElementSetArray[0].makeNeighbour();
        pgBndElementSetArray[0].makeVertexNormals();
        pgBndElementSetArray[0].makeElementNormals();
        pgTetraSet.setBoundary(pgBndElementSetArray);
    }

    public static PiVector[] makeBoundaryFaces(PgTetraSet pgTetraSet) {
        int n;
        PgBndElementSet[] pgBndElementSetArray = new PgBndElementSet[]{new PgBndElementSet(pgTetraSet.getDimOfVertices())};
        pgBndElementSetArray[0].setTetraSet(pgTetraSet);
        int n2 = pgTetraSet.getNumTetras();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            for (n = 0; n < 4; ++n) {
                if (pgTetraSet.getNeighbour((int)i).m_data[n] != -1) continue;
                ++n3;
            }
        }
        PiVector[] piVectorArray = new PiVector[n3];
        n3 = 0;
        for (n = 0; n < n2; ++n) {
            for (int i = 0; i < 4; ++i) {
                if (pgTetraSet.getNeighbour((int)n).m_data[i] != -1) continue;
                PiVector piVector = pgTetraSet.getTetra(n);
                piVectorArray[n3] = new PiVector(3);
                for (int j = 0; j < 3; ++j) {
                    piVectorArray[n3].m_data[j] = i % 2 == 0 ? piVector.m_data[(i + j + 1) % 4] : piVector.m_data[(i + (3 - j) % 3 + 1) % 4];
                }
                ++n3;
            }
        }
        return piVectorArray;
    }

    public PiVector[] getTetToBndIndices(PgBndElementSet pgBndElementSet) {
        int n;
        PgTetraSet pgTetraSet = pgBndElementSet.getTetraSet();
        int n2 = pgTetraSet.getNumTetras();
        PiVector[] piVectorArray = new PiVector[n2];
        for (n = 0; n < n2; ++n) {
            piVectorArray[n] = new PiVector(4);
            piVectorArray[n].setConstant(-1);
        }
        n = pgBndElementSet.getNumElements();
        PiVector piVector = pgBndElementSet.getTetraInd();
        PiVector piVector2 = pgBndElementSet.getNeighbourLocInd();
        if (piVector == null || piVector.getSize() != n || piVector2 == null || piVector2.getSize() != n) {
            return null;
        }
        for (int i = 0; i < n; ++i) {
            piVectorArray[piVector.m_data[i]].m_data[piVector2.m_data[i]] = i;
        }
        return piVectorArray;
    }

    public static PgElementSet convertToElementSet(PgTetraSet pgTetraSet) {
        int n;
        PgElementSet pgElementSet = new PgElementSet(pgTetraSet.getDimOfVertices());
        int n2 = pgTetraSet.getNumVertices();
        pgElementSet.setNumVertices(n2);
        for (n = 0; n < n2; ++n) {
            pgElementSet.setVertex(n, PdVector.copyNew((PdVector)pgTetraSet.getVertex(n)));
        }
        n = pgTetraSet.getNumTetras();
        pgElementSet.setDimOfElements(4);
        pgElementSet.setNumElements(n);
        for (int i = 0; i < n; ++i) {
            pgElementSet.setElement(i, PiVector.copyNew((PiVector)pgTetraSet.getTetra(i)));
        }
        return pgElementSet;
    }

    public static void addTestVectorField(PgTetraSet pgTetraSet) {
        int n = pgTetraSet.getNumTetras();
        PgVectorField pgVectorField = new PgVectorField(3, 1);
        pgVectorField.setGeometry((PgPointSet)pgTetraSet);
        pgVectorField.setBasedOn(1);
        pgVectorField.setNumVectors(n);
        for (int i = 0; i < n; ++i) {
            PdVector pdVector = new PdVector(pgTetraSet.getDimOfVertices());
            PgGeometry.getCenterOfElement((PdVector)pdVector, (PdVector[])pgTetraSet.getVertices(), (int[])pgTetraSet.getTetra((int)i).m_data);
            PdVector pdVector2 = PdVector.subNew((PdVector)pgTetraSet.getVertex(pgTetraSet.getTetra((int)i).m_data[0]), (PdVector)pdVector);
            pdVector2.multScalar(0.5);
            pgVectorField.setVector(i, pdVector2);
        }
        pgVectorField.setGlobalVectorColor(new Color(0, 0, 191));
        pgVectorField.setGlobalVectorSize(2.0);
        pgVectorField.showIndividualMaterial(true);
        pgTetraSet.addVectorField(pgVectorField);
    }

    public static PgVectorField[] addTestFrameField(PgTetraSet pgTetraSet, boolean bl) {
        int n = pgTetraSet.getNumTetras();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[3];
        PdVector pdVector = new PdVector(1.0, 0.0, 0.0);
        PdVector pdVector2 = new PdVector(0.0, 0.0, 1.0);
        for (int i = 0; i < 3; ++i) {
            pgVectorFieldArray[i] = new PgVectorField(3, 1);
            pgVectorFieldArray[i].setGeometry((PgPointSet)pgTetraSet);
            pgVectorFieldArray[i].setBasedOn(1);
            pgVectorFieldArray[i].setNumVectors(n);
            for (int j = 0; j < n; ++j) {
                PdVector pdVector3 = new PdVector(3);
                pdVector3.setConstant(0.0);
                pdVector3.setEntry(i, 1.0);
                PdVector pdVector4 = new PdVector(pgTetraSet.getDimOfVertices());
                PgGeometry.getCenterOfElement((PdVector)pdVector4, (PdVector[])pgTetraSet.getVertices(), (int[])pgTetraSet.getTetra((int)j).m_data);
                pdVector4.setEntry(2, 0.0);
                double d = PdVector.angleWithOrientation((PdVector)pdVector, (PdVector)pdVector4, (PdVector)pdVector2);
                PdMatrix pdMatrix = new PdMatrix(3);
                PuReflect.makeRotation((PdMatrix)pdMatrix, (PdVector)pdVector2, (double)(d / 4.0));
                pdVector3.leftMultMatrix(pdMatrix);
                pgVectorFieldArray[i].setVector(j, pdVector3);
            }
            if (i == 0) {
                pgVectorFieldArray[i].setGlobalVectorColor(new Color(191, 0, 0));
            } else if (i == 1) {
                pgVectorFieldArray[i].setGlobalVectorColor(new Color(0, 127, 0));
            } else {
                pgVectorFieldArray[i].setGlobalVectorColor(new Color(0, 0, 191));
            }
            pgVectorFieldArray[i].setGlobalVectorSize(2.0);
            if (bl) {
                pgTetraSet.addVectorField(pgVectorFieldArray[i]);
            }
            pgVectorFieldArray[i].showIndividualMaterial(true);
        }
        return pgVectorFieldArray;
    }

    public static PgEdgeStar computeEdgeStar(PgTetraSet pgTetraSet, int n, int n2, int n3, PgEdgeStar pgEdgeStar) {
        int n4 = PwTetraSet.getLocalEdgeIndex(pgTetraSet, n, n2, n3);
        if (n4 == -1) {
            PsDebug.warning((String)("Edge " + n2 + " - " + n3 + " not found in tetrahedron " + n));
            return null;
        }
        return PwTetraSet.computeEdgeStar(pgTetraSet, n, n4, pgEdgeStar);
    }

    public static PgEdgeStar computeEdgeStar(PgTetraSet pgTetraSet, int n, int n2, PgEdgeStar pgEdgeStar) {
        int n3;
        int n4;
        int n5;
        PgEdgeStar pgEdgeStar2 = pgEdgeStar == null ? new PgEdgeStar() : pgEdgeStar;
        PiVector piVector = pgTetraSet.getTetra(n);
        for (n5 = 0; n5 < 2; ++n5) {
            pgEdgeStar2.setEntry(n5, piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2][n5]]);
        }
        n5 = (n2 + 3) % 6;
        int n6 = -2;
        int n7 = n;
        int n8 = -2;
        Vector<PiVector> vector = new Vector<PiVector>();
        while (n6 != n && n6 != -1) {
            if (n6 != -2) {
                n8 = n7;
                n7 = n6;
            }
            n4 = PwTetraSet.getLocalEdgeIndex(pgTetraSet, n7, pgEdgeStar2.m_data[0], pgEdgeStar2.m_data[1]);
            vector.addElement(new PiVector(n7, n4));
            n5 = (n4 + 3) % 6;
            n3 = pgTetraSet.getNeighbour((int)n7).m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n5][0]] == n8 ? PgTetraSet.LOCAL_EDGE_TO_VERTEX[n5][1] : PgTetraSet.LOCAL_EDGE_TO_VERTEX[n5][0];
            n6 = pgTetraSet.getNeighbour((int)n7).m_data[n3];
            if (vector.size() <= pgTetraSet.getNumTetras()) continue;
            break;
        }
        if (n6 != n) {
            n6 = n7;
            n8 = -1;
            n7 = -1;
            vector = new Vector();
            while (n6 != -1) {
                n8 = n7;
                n7 = n6;
                n4 = PwTetraSet.getLocalEdgeIndex(pgTetraSet, n7, pgEdgeStar2.m_data[0], pgEdgeStar2.m_data[1]);
                vector.addElement(new PiVector(n7, n4));
                n5 = (n4 + 3) % 6;
                n3 = pgTetraSet.getNeighbour((int)n7).m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n5][0]] == n8 ? PgTetraSet.LOCAL_EDGE_TO_VERTEX[n5][1] : PgTetraSet.LOCAL_EDGE_TO_VERTEX[n5][0];
                n6 = pgTetraSet.getNeighbour((int)n7).m_data[n3];
                if (vector.size() <= pgTetraSet.getNumTetras()) continue;
                break;
            }
        }
        n3 = vector.size();
        pgEdgeStar2.setMaxValence(n3);
        pgEdgeStar2.setValence(0);
        for (int i = 0; i < n3; ++i) {
            pgEdgeStar2.addElement(((PiVector)vector.elementAt((int)i)).m_data[0], ((PiVector)vector.elementAt((int)i)).m_data[1]);
        }
        return pgEdgeStar2;
    }

    public static void testEdgeStars(PgTetraSet pgTetraSet) {
        int n = pgTetraSet.getNumTetras();
        double d = 0.0;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < 6; ++j) {
                PgEdgeStar pgEdgeStar = PwTetraSet.computeEdgeStar(pgTetraSet, i, j, null);
                int n3 = pgEdgeStar.getValence();
                d += (double)n3;
                if (!PwTetraSet.edgeStarIsClosed(pgTetraSet, pgEdgeStar)) continue;
                ++n2;
            }
        }
        PsDebug.message((String)(6 * n + " EdgeStars were computed"));
        PsDebug.message((String)("Closed stars: " + n2 + " - Not closed stars: " + (6 * n - n2)));
        PsDebug.message((String)("Average valence: " + d / (6.0 * (double)n)));
    }

    public static int getLocalEdgeIndex(PgTetraSet pgTetraSet, int n, int n2, int n3) {
        PiVector piVector = pgTetraSet.getTetra(n);
        for (int i = 0; i < 6; ++i) {
            if ((piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[i][0]] != n2 || piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[i][1]] != n3) && (piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[i][1]] != n2 || piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[i][0]] != n3)) continue;
            return i;
        }
        PsDebug.warning((String)("Edge " + n2 + " - " + n3 + " not found in tetrahedron " + n));
        return -1;
    }

    public static boolean edgeStarIsClosed(PgTetraSet pgTetraSet, PgEdgeStar pgEdgeStar) {
        if (pgEdgeStar == null || pgEdgeStar.getValence() < 1) {
            PsDebug.warning((String)"No valid edge star!");
            return false;
        }
        int n = pgEdgeStar.getElementInd(0);
        int n2 = (PwTetraSet.getLocalEdgeIndex(pgTetraSet, n, pgEdgeStar.m_data[0], pgEdgeStar.m_data[1]) + 3) % 6;
        PiVector piVector = pgTetraSet.getNeighbour(n);
        return piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2][0]] != -1 && piVector.m_data[PgTetraSet.LOCAL_EDGE_TO_VERTEX[n2][1]] != -1;
    }

    public static void testVertexStars(PgTetraSet pgTetraSet) {
        int n = pgTetraSet.getNumTetras();
        double d = 0.0;
        int n2 = 0;
        PgTetraVertexStar pgTetraVertexStar = new PgTetraVertexStar();
        for (int i = 0; i < n; ++i) {
            PiVector piVector = pgTetraSet.getTetra(i);
            for (int j = 0; j < 4; ++j) {
                pgTetraVertexStar.makeVertexStar(pgTetraSet, piVector.m_data[j], i);
                int n3 = pgTetraVertexStar.getSize();
                d += (double)n3;
                if (!pgTetraVertexStar.isClosed()) continue;
                ++n2;
            }
        }
        PsDebug.message((String)(4 * n + " VertexStars were computed"));
        PsDebug.message((String)("Closed stars: " + n2 + " - Not closed stars: " + (4 * n - n2)));
        PsDebug.message((String)("Average valence: " + d / (4.0 * (double)n)));
    }

    public static void addTestTexture(PgTetraSet pgTetraSet) {
        int n = pgTetraSet.getNumTetras();
        pgTetraSet.assureTetraTextures();
        for (int i = 0; i < n; ++i) {
            PdVector[] pdVectorArray = new PdVector[4];
            PiVector piVector = pgTetraSet.getTetra(i);
            for (int j = 0; j < 4; ++j) {
                pdVectorArray[j] = PdVector.copyNew((PdVector)pgTetraSet.getVertex(piVector.m_data[j]));
            }
            pgTetraSet.setTetraTexture(i, pdVectorArray);
        }
    }

    public static PgVectorField[] deriveTexture(PgTetraSet pgTetraSet) {
        int n;
        boolean bl = pgTetraSet.hasVertexTextures();
        if (!bl && !pgTetraSet.hasTetraTextures()) {
            PsDebug.warning((String)"No texture found");
            return null;
        }
        int n2 = pgTetraSet.getDimOfTextures();
        PgVectorField[] pgVectorFieldArray = new PgVectorField[n2];
        for (n = 0; n < n2; ++n) {
            pgVectorFieldArray[n] = new PgVectorField(3, 1);
            pgVectorFieldArray[n].setGeometry((PgPointSet)pgTetraSet);
            pgVectorFieldArray[n].setName("VF[" + n + "]");
        }
        n = pgTetraSet.getNumTetras();
        for (int i = 0; i < n; ++i) {
            int n3;
            PiVector piVector = pgTetraSet.getTetra(i);
            int n4 = piVector.getSize();
            PdVector[] pdVectorArray = PdVector.realloc(null, (int)n2, (int)n4);
            for (n3 = 0; n3 < n4; ++n3) {
                int n5;
                if (bl) {
                    n5 = piVector.m_data[n3];
                    for (int j = 0; j < n2; ++j) {
                        pdVectorArray[j].m_data[n3] = pgTetraSet.getVertexTexture((int)n5).m_data[j];
                    }
                    continue;
                }
                for (n5 = 0; n5 < n2; ++n5) {
                    pdVectorArray[n5].m_data[n3] = pgTetraSet.getTetraTexture((int)i)[n3].m_data[n5];
                }
            }
            for (n3 = 0; n3 < n2; ++n3) {
                PgUtil.calcLinearGradient(pgTetraSet, i, pdVectorArray[n3], pgVectorFieldArray[n3].getVector(i));
            }
        }
        return pgVectorFieldArray;
    }

    public static void unfoldByTexture(PgTetraSet pgTetraSet) {
        if (pgTetraSet.hasVertexTextures()) {
            pgTetraSet.setVertices(pgTetraSet.getVertexTextures());
        } else if (pgTetraSet.hasTetraTextures()) {
            int n;
            int n2;
            int n3 = pgTetraSet.getNumTetras();
            PdVector[][] pdVectorArray = pgTetraSet.getTetraTextures();
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < 4; ++n) {
                    int n4 = pgTetraSet.getNeighbour((int)n2).m_data[n];
                    if (n4 < 0) continue;
                    int n5 = pgTetraSet.getNeighbour(n4).getIndexOf(n2);
                    if (n5 < 0) {
                        PsDebug.warning((String)"error in neighbours");
                        return;
                    }
                    boolean bl = true;
                    for (int i = 0; i < 3; ++i) {
                        int n6 = (n + i + 1) % 4;
                        int n7 = pgTetraSet.getTetra((int)n2).m_data[n6];
                        int n8 = pgTetraSet.getTetra(n4).getIndexOf(n7);
                        if (n8 < 0) {
                            PsDebug.warning((String)"Error in neighbours");
                            return;
                        }
                        double d = pdVectorArray[n2][n6].sqrDist(pdVectorArray[n4][n8]);
                        if (!(d > 1.0E-10)) continue;
                        bl = false;
                    }
                    if (bl) continue;
                    pgTetraSet.getNeighbour((int)n2).m_data[n] = -1;
                    pgTetraSet.getNeighbour((int)n4).m_data[n5] = -1;
                }
            }
            PwTetraSet.splitNonManifoldVertices(pgTetraSet);
            for (n2 = 0; n2 < n3; ++n2) {
                for (n = 0; n < 4; ++n) {
                    pgTetraSet.setVertex(pgTetraSet.getTetra((int)n2).m_data[n], pdVectorArray[n2][n]);
                }
            }
        }
    }

    public static PiVector splitNonManifoldVertices(PgTetraSet pgTetraSet) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = pgTetraSet.getNumTetras();
        PiVector[] piVectorArray = pgTetraSet.getTetras();
        PiVector piVector = new PiVector(4 * n6);
        for (n5 = 0; n5 < 4 * n6; ++n5) {
            piVector.m_data[n5] = n5;
        }
        for (n5 = 0; n5 < n6; ++n5) {
            for (n4 = 0; n4 < 4; ++n4) {
                int n7 = pgTetraSet.getNeighbour((int)n5).m_data[n4];
                if (n7 < 0) continue;
                for (n3 = 0; n3 < 3; ++n3) {
                    n2 = (n4 + n3 + 1) % 4;
                    n = pgTetraSet.getTetra((int)n5).m_data[n2];
                    int n8 = pgTetraSet.getTetra(n7).getIndexOf(n);
                    if (n8 < 0) {
                        PsDebug.warning((String)"Error in neighbours");
                        return null;
                    }
                    int n9 = 4 * n5 + n2;
                    while (piVector.m_data[n9] != n9) {
                        n9 = piVector.m_data[n9];
                    }
                    int n10 = 4 * n7 + n8;
                    while (piVector.m_data[n10] != n10) {
                        n10 = piVector.m_data[n10];
                    }
                    if (n9 == n10) continue;
                    piVector.m_data[n10] = n9;
                }
            }
        }
        PiVector piVector2 = new PiVector(4 * n6);
        piVector2.setConstant(-1);
        n4 = 0;
        PiVector piVector3 = new PiVector(4 * n6);
        for (n3 = 0; n3 < n6; ++n3) {
            for (n2 = 0; n2 < 4; ++n2) {
                n = 4 * n3 + n2;
                while (piVector.m_data[n] != n) {
                    n = piVector.m_data[n];
                }
                if (piVector2.m_data[n] < 0) {
                    piVector3.m_data[n4] = piVectorArray[n3].m_data[n2];
                    piVector2.m_data[n] = n4++;
                }
                piVectorArray[n3].m_data[n2] = piVector2.m_data[n];
            }
        }
        piVector3.setSize(n4);
        PdVector[] pdVectorArray = pgTetraSet.getVertices();
        pgTetraSet.setNumVertices(n4);
        for (n2 = 0; n2 < n4; ++n2) {
            pgTetraSet.setVertex(n2, pdVectorArray[piVector3.m_data[n2]]);
        }
        return piVector3;
    }

    public static PgPolygonSet convertToPolygonSet(PgTetraSet pgTetraSet) {
        PgPolygonSet pgPolygonSet = new PgPolygonSet(3);
        pgPolygonSet.setName("PolygonSet of " + pgTetraSet.getName());
        pgPolygonSet.setEnabledInstanceSharing(true);
        pgPolygonSet.setNumVertices(pgTetraSet.getNumVertices());
        pgPolygonSet.setMaxNumVertices(pgTetraSet.getMaxNumVertices());
        pgPolygonSet.setVertices(pgTetraSet.getVertices());
        pgPolygonSet.setEnabledInstanceSharing(false);
        PgEdgeStar[] pgEdgeStarArray = pgTetraSet.makeEdgeStars();
        int n = pgEdgeStarArray.length;
        pgPolygonSet.setNumPolygons(n);
        for (int i = 0; i < n; ++i) {
            PiVector piVector = new PiVector(pgEdgeStarArray[i].m_data[0], pgEdgeStarArray[i].m_data[1]);
            pgPolygonSet.setPolygon(i, piVector);
        }
        return pgPolygonSet;
    }

    public static PgElementSet convertFacesToElementSet(PgTetraSet pgTetraSet) {
        int n;
        int n2;
        PgElementSet pgElementSet = new PgElementSet(3);
        pgElementSet.setName("Faces of " + pgTetraSet.getName());
        pgElementSet.setEnabledInstanceSharing(true);
        pgElementSet.setNumVertices(pgTetraSet.getNumVertices());
        pgElementSet.setMaxNumVertices(pgTetraSet.getMaxNumVertices());
        pgElementSet.setVertices(pgTetraSet.getVertices());
        pgElementSet.setEnabledInstanceSharing(false);
        int n3 = pgTetraSet.getNumTetras();
        int n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 4; ++n) {
                if (pgTetraSet.getNeighbour((int)n2).m_data[n] >= n2) continue;
                ++n4;
            }
        }
        pgElementSet.setNumElements(n4);
        n4 = 0;
        for (n2 = 0; n2 < n3; ++n2) {
            for (n = 0; n < 4; ++n) {
                if (pgTetraSet.getNeighbour((int)n2).m_data[n] >= n2) continue;
                PiVector piVector = new PiVector(3);
                for (int i = 0; i < 3; ++i) {
                    piVector.m_data[i] = pgTetraSet.getTetra((int)n2).m_data[(n + i) % 4];
                }
                pgElementSet.setElement(n4++, piVector);
            }
        }
        return pgElementSet;
    }

    public static PdVector getVertex(PdVector pdVector, PgTetraSet pgTetraSet, PdBary pdBary) {
        int n = pdBary.getElementInd();
        if (n < 0 || n >= pgTetraSet.getNumTetras()) {
            PsDebug.warning((String)"Edge index out of bounds.");
            return null;
        }
        PiVector piVector = pgTetraSet.getTetra(n);
        if (piVector.getSize() != 4) {
            PsDebug.warning((String)"Element is not a tet.");
            return null;
        }
        pdVector = pdBary.getVertex(pdVector, pgTetraSet.getVertex(piVector.m_data[0]), pgTetraSet.getVertex(piVector.m_data[1]), pgTetraSet.getVertex(piVector.m_data[2]), pgTetraSet.getVertex(piVector.m_data[3]));
        return pdVector;
    }

    public static PdVector makeFaceNormal(PgTetraSet pgTetraSet, int n, int n2) {
        PiVector piVector = pgTetraSet.getTetra(n);
        int n3 = piVector.m_data[n2];
        int n4 = piVector.m_data[(n2 + 1) % 4];
        int n5 = piVector.m_data[(n2 + 2) % 4];
        int n6 = piVector.m_data[(n2 + 3) % 4];
        PdVector pdVector = PdVector.crossNew((PdVector)PdVector.subNew((PdVector)pgTetraSet.getVertex(n5), (PdVector)pgTetraSet.getVertex(n4)), (PdVector)PdVector.subNew((PdVector)pgTetraSet.getVertex(n6), (PdVector)pgTetraSet.getVertex(n4)));
        pdVector.normalize();
        if (pdVector.dot(pgTetraSet.getVertex(n3)) - pdVector.dot(pgTetraSet.getVertex(n4)) < 0.0) {
            pdVector.multScalar(-1.0);
        }
        return pdVector;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

