/*
 * Decompiled with CFR 0.152.
 */
package jvx.vector;

import java.awt.Color;
import jv.geom.PgElementSet;
import jv.geom.PgPointSet;
import jv.geom.PgVectorField;
import jv.number.PuDouble;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.object.PsUpdateIf;
import jv.project.PgGeometry;
import jv.vecmath.PdVector;
import jv.vecmath.PuMath;
import jvx.geom.PwCurvature;
import jvx.numeric.PnMassMatrix;
import jvx.project.PjWorkshop;

public class PwScalarField
extends PjWorkshop {
    public final String[] m_scalarFieldName = new String[]{PsConfig.getMessage((int)45070), PsConfig.getMessage((int)45071), PsConfig.getMessage((int)45072), PsConfig.getMessage((boolean)true, (int)45000, (String)"t-Height"), PsConfig.getMessage((int)45073), PsConfig.getMessage((int)45074), PsConfig.getMessage((int)45075), PsConfig.getMessage((int)45076), PsConfig.getMessage((int)45075) + " (" + PsConfig.getMessage((boolean)true, (int)45000, (String)"Absolute Value") + ")", PsConfig.getMessage((int)45076) + " (" + PsConfig.getMessage((boolean)true, (int)45000, (String)"Absolute Value") + ")", PsConfig.getMessage((boolean)true, (int)45000, (String)"Difference of Principal Curvatures"), PsConfig.getMessage((boolean)true, (int)45000, (String)"Sqrt(k1^2+k2^2)"), PsConfig.getMessage((boolean)true, (int)45000, (String)"k1*k2"), PsConfig.getMessage((int)45077)};
    public static final int SCALAR_X_HEIGHT = 0;
    public static final int SCALAR_Y_HEIGHT = 1;
    public static final int SCALAR_Z_HEIGHT = 2;
    public static final int SCALAR_T_HEIGHT = 3;
    public static final int SCALAR_GAUSS_CURVATURE = 4;
    public static final int SCALAR_MEAN_CURVATURE = 5;
    public static final int SCALAR_MAX_PRINCIPAL = 6;
    public static final int SCALAR_MIN_PRINCIPAL = 7;
    public static final int SCALAR_MAX_PRINCIPAL_ABS = 8;
    public static final int SCALAR_MIN_PRINCIPAL_ABS = 9;
    public static final int SCALAR_DIFF_PRINCIPAL = 10;
    public static final int SCALAR_TOTAL_CURVATURE = 11;
    public static final int SCALAR_GAUSS_VIA_PRINCIPAL = 12;
    public static final int SCALAR_IMPORTED_FUNCTION = 13;
    protected static final int m_numScalarTypes = 14;
    public static final int SCALAR_EXTREMALITY = 14;
    protected PgElementSet m_geom;
    protected PgVectorField m_scalar;
    protected int m_defScalarField = 0;
    protected int m_scalarType;
    protected int m_basisType;
    protected boolean m_bShowColor;
    protected boolean m_bShowGradient;
    protected boolean m_bInvertColor;
    protected boolean m_bShowVectorField;
    protected PgVectorField m_gradient;
    protected PgVectorField m_offsetVectorField;
    protected boolean m_bUseTotalCurv;
    protected boolean m_bChopField;
    protected PuDouble m_chopMin = new PuDouble(PsConfig.getMessage((int)54520), (PsUpdateIf)this);
    protected PuDouble m_chopMax = new PuDouble(PsConfig.getMessage((int)54521), (PsUpdateIf)this);
    protected PdVector m_backupField;
    protected PdVector m_backupOfImportedField;
    protected boolean m_hasImportedFunction = false;
    protected boolean m_bAdjustColoring;
    protected boolean m_bNonLinColoring;
    protected PuDouble m_colorMin;
    protected PuDouble m_colorMax = new PuDouble(PsConfig.getMessage((int)54522), (PsUpdateIf)this);
    protected boolean m_bUseGrayLevel;
    protected boolean m_bUseAbsValue;
    protected boolean m_bUseSymmetricInterval;
    protected boolean[] m_bFieldAvailable;
    protected boolean m_bIgnoreOutliersWhenColoring;
    private String m_backUpNameOfField = null;
    private static double[] m_ColorMapCurvatureIntervals = new double[]{0.05, 0.1, 0.2, 0.4, 0.45, 0.55, 0.85};
    private static double[] m_ColorMapLinearIntervals = new double[]{0.1, 0.2, 0.35, 0.5, 0.65, 0.8, 0.9};
    private static double[] m_ColorMapOldIntervals = new double[]{0.1, 0.15, 0.4, 0.5, 0.75, 0.82, 0.88};
    static /* synthetic */ Class class$jvx$vector$PwScalarField;

    public PwScalarField() {
        super(PsConfig.getMessage((int)54519));
        this.m_colorMin = new PuDouble(PsConfig.getMessage((int)54523), (PsUpdateIf)this);
        this.m_bFieldAvailable = new boolean[14];
        if (((Object)((Object)this)).getClass() == (class$jvx$vector$PwScalarField == null ? (class$jvx$vector$PwScalarField = PwScalarField.class$("jvx.vector.PwScalarField")) : class$jvx$vector$PwScalarField)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_scalarType = this.m_defScalarField;
        this.m_basisType = 0;
        this.m_bChopField = false;
        this.m_bUseTotalCurv = false;
        this.m_bShowGradient = false;
        this.m_bShowVectorField = false;
        this.m_bShowColor = true;
        this.m_bAdjustColoring = true;
        this.m_bUseGrayLevel = false;
        this.m_bUseAbsValue = false;
        this.m_bNonLinColoring = false;
        this.m_bIgnoreOutliersWhenColoring = false;
        this.m_bUseSymmetricInterval = false;
        this.m_bInvertColor = false;
        this.m_chopMax.init();
        this.m_chopMin.init();
        this.m_chopMax.setEnabled(this.m_bChopField);
        this.m_chopMin.setEnabled(this.m_bChopField);
        this.m_colorMax.init();
        this.m_colorMin.init();
        for (int i = 0; i < 14; ++i) {
            this.m_bFieldAvailable[i] = true;
        }
        if (this.m_scalar != null) {
            this.m_scalar.init();
            this.m_scalar.setType(this.m_basisType);
        }
    }

    public void reset() {
        super.reset();
        if (this.m_geom != null && this.m_geomSave != null) {
            this.m_geom.copy((PsObject)this.m_geomSave);
        }
        this.setGeometry(this.m_geom);
    }

    public boolean update(Object object) {
        if (this.isUpdateSender()) {
            return true;
        }
        if (object == this.m_geom) {
            if (this.isModal()) {
                return true;
            }
            this.setGeometry(this.m_geom);
            return true;
        }
        if (object == this) {
            this.computeScalar(this.m_geom, this.m_scalarType);
            this.adjustChopSliders();
            this.m_chopMin.update((Object)this.m_chopMin);
            this.m_chopMax.update((Object)this.m_chopMax);
            if (this.m_bAdjustColoring) {
                this.adjustColorSliders();
                this.m_colorMax.update((Object)this.m_colorMax);
                this.m_colorMin.update((Object)this.m_colorMin);
            }
            this.updateGradient();
            if (this.m_bShowColor) {
                this.updateColor();
            }
            if (this.m_bChopField) {
                this.chopField();
            }
            this.updateGeometry();
            return super.update((Object)this);
        }
        if (object == this.m_chopMin || object == this.m_chopMax) {
            if (!this.m_bChopField) {
                return true;
            }
            this.chopField();
            this.updateGradient();
            this.updateColor();
            this.m_bUpdateSender = true;
            this.m_scalar.update((Object)this.m_scalar);
            this.m_bUpdateSender = false;
            this.updateGeometry();
            return true;
        }
        if (object == this.m_colorMax || object == this.m_colorMin) {
            if (this.m_bUseSymmetricInterval) {
                if (object == this.m_colorMax) {
                    this.m_colorMin.setValue(-this.m_colorMax.getValue());
                    this.m_colorMin.updatePanels((Object)this.m_colorMin);
                } else {
                    this.m_colorMax.setValue(-this.m_colorMin.getValue());
                    this.m_colorMax.updatePanels((Object)this.m_colorMax);
                }
            }
            this.updateColor();
            this.updateGeometry();
            return true;
        }
        if (object == this.m_scalar && !this.m_bUpdateSender) {
            this.adjustChopSliders();
            this.m_chopMin.update((Object)this.m_chopMin);
            this.m_chopMax.update((Object)this.m_chopMax);
            if (this.m_bAdjustColoring) {
                this.adjustColorSliders();
                this.m_colorMax.update((Object)this.m_colorMax);
                this.m_colorMin.update((Object)this.m_colorMin);
            }
            this.updateGradient();
            if (this.m_bShowColor) {
                this.updateColor();
            }
            if (this.m_bChopField) {
                this.chopField();
            }
            this.updateGeometry();
            return true;
        }
        return super.update(object);
    }

    private void updateGeometry() {
        this.m_bUpdateSender = true;
        this.m_geom.update((Object)this.m_geom);
        this.m_bUpdateSender = false;
    }

    public void cancel() {
        this.m_scalar.removeUpdateListener((PsUpdateIf)this);
        this.resetColors();
        super.cancel();
    }

    public void ok() {
        this.m_scalar.removeUpdateListener((PsUpdateIf)this);
        super.ok();
    }

    public void showOnlyGrayLevels(boolean bl) {
        this.m_bUseGrayLevel = bl;
    }

    public boolean isShowingOnlyGrayLevels(boolean bl) {
        return this.m_bUseGrayLevel;
    }

    public void setColorMin(double d) {
        this.m_colorMin.setValue(d);
    }

    public double getColorMin() {
        return this.m_colorMin.getValue();
    }

    public void setColorMax(double d) {
        this.m_colorMax.setValue(d);
    }

    public double getColorMax() {
        return this.m_colorMax.getValue();
    }

    public void setGeometry(PgElementSet pgElementSet) {
        super.setGeometry((PgGeometry)pgElementSet);
        this.m_geom = pgElementSet;
        this.m_scalar = null;
        PgVectorField pgVectorField = this.m_geom.getSelectedVectorField();
        if (pgVectorField != null && pgVectorField.getDimOfVectors() == 1) {
            this.m_scalar = pgVectorField;
            this.m_scalarType = 13;
            this.m_hasImportedFunction = true;
            boolean bl = false;
            String string = pgVectorField.getName();
            for (int i = 0; i < 14; ++i) {
                if (!string.equals(this.m_scalarFieldName[i])) continue;
                bl = true;
                this.m_backUpNameOfField = new String(string);
                break;
            }
            if (!bl) {
                this.m_scalarFieldName[13] = string;
            }
            this.backupImportedField();
        } else {
            this.m_bFieldAvailable[13] = false;
            this.m_scalar = new PgVectorField(1);
            this.m_scalar.setType(this.m_basisType);
            this.m_scalar.setGeometry((PgPointSet)this.m_geom);
            this.m_scalar.setVisible(false);
            this.m_geom.addVectorField(this.m_scalar);
        }
        if (this.m_geom.getDimOfVertices() < 4) {
            this.m_bFieldAvailable[3] = false;
        }
        if (this.m_geom.getDimOfVertices() < 3) {
            this.m_bFieldAvailable[2] = false;
        }
        if (this.m_geom.getDimOfVertices() < 2) {
            this.m_bFieldAvailable[1] = false;
        }
        if (this.m_geom.getDimOfElements() != 3) {
            this.m_bFieldAvailable[5] = false;
        }
        this.computeScalar(this.m_geom, this.m_scalarType);
        this.adjustChopSliders();
        this.adjustColorSliders();
        this.m_chopMin.update((Object)this.m_chopMin);
        this.m_chopMax.update((Object)this.m_chopMax);
        this.m_colorMax.update((Object)this.m_colorMax);
        this.m_colorMin.update((Object)this.m_colorMin);
        this.updateGeometry();
        this.m_scalar.addUpdateListener((PsUpdateIf)this);
    }

    public int getScalarType() {
        return this.m_scalarType;
    }

    public void setScalarType(int n) {
        this.m_scalarType = n;
    }

    public void setAdjustColoring(boolean bl) {
        this.m_bAdjustColoring = bl;
    }

    public boolean getAdjustColoring() {
        return this.m_bAdjustColoring;
    }

    public String getScalarName(int n) {
        return this.m_scalarFieldName[n];
    }

    public boolean computeScalar() {
        return this.computeScalar((PgElementSet)this.getGeometry(), this.getScalarType());
    }

    public boolean computeScalar(PgElementSet pgElementSet, int n) {
        if (n < 0 || n >= 14) {
            PsDebug.warning((String)("scalar type out of bounds, type = " + n));
            return false;
        }
        PdVector pdVector = null;
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            pdVector = new PdVector(pgElementSet.getDimOfVertices());
        }
        switch (n) {
            case 0: {
                pdVector.setEntry(0, 1.0);
                break;
            }
            case 1: {
                pdVector.setEntry(1, 1.0);
                break;
            }
            case 2: {
                pdVector.setEntry(2, 1.0);
                break;
            }
            case 3: {
                pdVector.setEntry(3, 1.0);
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            default: {
                return false;
            }
        }
        int n2 = pgElementSet.getNumVertices();
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        if (n == 0 || n == 1 || n == 2 || n == 3) {
            PdVector[] pdVectorArray2 = pgElementSet.getBounds();
            if (pdVectorArray2 == null) {
                PsDebug.warning((String)"missing bounding box");
                return false;
            }
            for (int i = 0; i < n2; ++i) {
                double d;
                pdVectorArray[i].m_data[0] = d = PdVector.dot((PdVector)pdVector, (PdVector)pgElementSet.getVertex(i));
            }
        } else if (n == 4) {
            PdVector pdVector2 = new PdVector(n2);
            PwCurvature.getGaussCurvature(pgElementSet, pdVector2);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = pdVector2.m_data[i];
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 5) {
            PdVector pdVector3 = new PdVector(n2);
            PwCurvature.getMeanCurvature(pgElementSet, pdVector3);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = pdVector3.m_data[i] / 2.0;
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 6) {
            PdVector[] pdVectorArray3 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray3, null);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = pdVectorArray3[0].m_data[i];
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 7) {
            PdVector[] pdVectorArray4 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray4, null);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = pdVectorArray4[1].m_data[i];
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 8) {
            PdVector[] pdVectorArray5 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray5, null);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = Math.abs(pdVectorArray5[0].m_data[i]) >= Math.abs(pdVectorArray5[1].m_data[i]) ? pdVectorArray5[0].m_data[i] : pdVectorArray5[1].m_data[i];
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 9) {
            PdVector[] pdVectorArray6 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray6, null);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = Math.abs(pdVectorArray6[0].m_data[i]) >= Math.abs(pdVectorArray6[1].m_data[i]) ? pdVectorArray6[1].m_data[i] : pdVectorArray6[0].m_data[i];
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 10) {
            PdVector[] pdVectorArray7 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray7, null);
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = Math.abs(Math.abs(pdVectorArray7[0].m_data[i]) - Math.abs(pdVectorArray7[1].m_data[i]));
            }
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, this.m_scalar.getVectors(), true);
            }
        } else if (n == 11) {
            PdVector[] pdVectorArray8 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray8, null);
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, pdVectorArray8[0], true);
                PnMassMatrix.multInvMassMatrix(this.m_geom, pdVectorArray8[1], true);
            }
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = Math.sqrt(pdVectorArray8[0].m_data[i] * pdVectorArray8[0].m_data[i] + pdVectorArray8[1].m_data[i] * pdVectorArray8[1].m_data[i]);
            }
        } else if (n == 12) {
            PdVector[] pdVectorArray9 = PdVector.realloc(null, (int)2, (int)n2);
            PwCurvature.getPrincipalCurvatures(pgElementSet, pdVectorArray9, null);
            if (!this.m_bUseTotalCurv) {
                PnMassMatrix.multInvMassMatrix(this.m_geom, pdVectorArray9[0], true);
                PnMassMatrix.multInvMassMatrix(this.m_geom, pdVectorArray9[1], true);
            }
            for (int i = 0; i < n2; ++i) {
                pdVectorArray[i].m_data[0] = pdVectorArray9[0].m_data[i] * pdVectorArray9[1].m_data[i];
            }
        } else if (n == 13 && this.m_backupOfImportedField != null) {
            this.restoreField(this.m_backupOfImportedField);
        }
        if (n == 13 && this.m_backUpNameOfField != null) {
            this.m_scalar.setName(this.m_backUpNameOfField);
        } else {
            this.m_scalar.setName(this.m_scalarFieldName[n]);
        }
        this.backupField();
        if (this.m_bUseAbsValue) {
            this.computeAbsField();
        }
        return true;
    }

    protected void computeAbsField() {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        for (int i = 0; i < n; ++i) {
            if (!(pdVectorArray[i].m_data[0] < 0.0)) continue;
            pdVectorArray[i].m_data[0] = -pdVectorArray[i].m_data[0];
        }
    }

    protected void updateColor() {
        boolean bl;
        int n = this.m_scalar.getNumVectors();
        if (n <= 0) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        double d = this.m_colorMax.getValue();
        double d2 = this.m_colorMin.getValue();
        double d3 = 0.0;
        if (d - d2 > 1.0E-10) {
            d3 = 1.0 / (d - d2);
        }
        boolean bl2 = bl = this.m_scalar.getBasedOn() == 0;
        if (this.m_bNonLinColoring) {
            for (int i = 0; i < n; ++i) {
                Color color;
                double d4 = (pdVectorArray[i].m_data[0] - d2) * d3;
                if (d4 < 1.0 && d4 > 0.0) {
                    d4 = 1.0 - (Math.cos(Math.PI * d4) + 1.0) / 2.0;
                }
                if (this.m_bInvertColor) {
                    d4 = 1.0 - d4;
                }
                Color color2 = color = this.m_bUseGrayLevel ? PwScalarField.colorMapGray(d4) : PwScalarField.colorMapCurvature(d4);
                if (bl) {
                    this.m_geom.setVertexColor(i, color);
                    continue;
                }
                this.m_geom.setElementColor(i, color);
            }
        } else {
            for (int i = 0; i < n; ++i) {
                Color color;
                double d5 = (pdVectorArray[i].m_data[0] - d2) * d3;
                if (this.m_bInvertColor) {
                    d5 = 1.0 - d5;
                }
                Color color3 = color = this.m_bUseGrayLevel ? PwScalarField.colorMapGray(d5) : PwScalarField.colorMap(d5);
                if (bl) {
                    this.m_geom.setVertexColor(i, color);
                    continue;
                }
                this.m_geom.setElementColor(i, color);
            }
        }
    }

    protected void resetColors() {
        if (this.m_geomSave != null && this.m_geomSave instanceof PgElementSet) {
            PgElementSet pgElementSet = (PgElementSet)this.m_geomSave;
            this.m_geom.showElementColors(pgElementSet.isShowingElementColors());
            this.m_geom.showElementColorFromVertices(pgElementSet.isShowingElementColorFromVertices());
            this.m_geom.showElementBackColor(pgElementSet.isShowingElementBackColor());
        }
    }

    protected void updateGradient() {
        if (this.m_bShowGradient) {
            this.m_gradient = this.computeGradient(this.m_gradient);
            this.m_geom.addVectorField(this.m_gradient);
        }
        if (this.m_gradient != null) {
            this.m_gradient.setVisible(this.m_bShowGradient);
        }
    }

    protected void update3dVectorField() {
        if (this.m_bShowVectorField) {
            this.m_offsetVectorField = this.computer3dVectorField(this.m_offsetVectorField);
            this.m_geom.addVectorField(this.m_offsetVectorField);
        }
        if (this.m_offsetVectorField != null) {
            this.m_offsetVectorField.setVisible(this.m_bShowVectorField);
        }
    }

    protected void adjustChopSliders() {
        int n = this.m_scalar.getNumVectors();
        if (n < 1) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int[] nArray = new int[n];
        PuMath.heapsort((int)n, (double[])PwScalarField.scalarField2Array(this.m_scalar, null), (int[])nArray);
        double d = 0.0;
        double d2 = pdVectorArray[nArray[n - 1 - n / 10]].m_data[0];
        if (!this.m_bUseAbsValue) {
            d = pdVectorArray[nArray[n / 10]].m_data[0];
        }
        double d3 = d2 - d;
        double d4 = pdVectorArray[nArray[n - 1]].m_data[0];
        double d5 = 0.0;
        if (!this.m_bUseAbsValue) {
            d5 = pdVectorArray[nArray[0]].m_data[0];
        }
        this.m_chopMin.setBounds(d5, d4, d3 / 100.0, d3 / 10.0);
        this.m_chopMax.setBounds(d5, d4, d3 / 100.0, d3 / 10.0);
        if (!this.m_bChopField) {
            this.m_chopMax.setValue(d2);
            this.m_chopMin.setValue(d);
        }
    }

    protected void adjustColorSliders() {
        double d;
        double d2;
        int n = this.m_scalar.getNumVectors();
        if (n < 1) {
            return;
        }
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        double d3 = 0.0;
        if (this.m_bIgnoreOutliersWhenColoring) {
            int[] nArray = new int[n];
            PuMath.heapsort((int)n, (double[])PwScalarField.scalarField2Array(this.m_scalar, null), (int[])nArray);
            d2 = pdVectorArray[nArray[n - 1 - n / 10]].m_data[0];
            if (!this.m_bUseAbsValue) {
                d3 = pdVectorArray[nArray[n / 10]].m_data[0];
            }
            if (this.m_bUseSymmetricInterval && !this.m_bUseAbsValue) {
                if (d2 < -d3) {
                    d2 = -d3;
                } else {
                    d3 = -d2;
                }
            }
            d = d2 - d3;
        } else {
            d2 = d3 = pdVectorArray[0].m_data[0];
            for (int i = 1; i < n; ++i) {
                if (pdVectorArray[i].m_data[0] < d3) {
                    d3 = pdVectorArray[i].m_data[0];
                    continue;
                }
                if (!(pdVectorArray[i].m_data[0] > d2)) continue;
                d2 = pdVectorArray[i].m_data[0];
            }
            if (this.m_bUseAbsValue) {
                d3 = 0.0;
            }
            if (this.m_bUseSymmetricInterval && !this.m_bUseAbsValue) {
                if (d2 < -d3) {
                    d2 = -d3;
                } else {
                    d3 = -d2;
                }
            }
            d = d2 - d3;
        }
        this.m_colorMin.setBounds(d3 - d, d2 + d, d / 33.0, d / 3.0);
        this.m_colorMax.setBounds(d3 - d, d2 + d, d / 33.0, d / 3.0);
        this.m_colorMax.setValue(d2);
        this.m_colorMin.setValue(d3);
    }

    protected void symmetrizeColorSliders() {
        double d;
        if (this.m_bUseAbsValue) {
            return;
        }
        double d2 = this.m_colorMax.getMax();
        if (d2 < -(d = this.m_colorMax.getMin())) {
            this.m_colorMin.setBounds(d, -d);
            this.m_colorMax.setBounds(d, -d);
        } else {
            this.m_colorMin.setBounds(-d2, d2);
            this.m_colorMax.setBounds(-d2, d2);
        }
        d2 = this.m_colorMax.getValue();
        d = this.m_colorMin.getValue();
        if (d2 < -d) {
            this.m_colorMax.setValue(-d);
        } else {
            this.m_colorMin.setValue(-d2);
        }
    }

    protected void backupField() {
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int n = this.m_scalar.getNumVectors();
        if (this.m_backupField == null) {
            this.m_backupField = new PdVector(n);
        } else if (this.m_backupField.m_data.length < n) {
            this.m_backupField.setSize(n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_backupField.m_data[i] = pdVectorArray[i].m_data[0];
        }
    }

    protected void backupImportedField() {
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int n = this.m_scalar.getNumVectors();
        if (this.m_backupOfImportedField == null) {
            this.m_backupOfImportedField = new PdVector(n);
        } else if (this.m_backupOfImportedField.m_data.length < n) {
            this.m_backupOfImportedField.setSize(n);
        }
        for (int i = 0; i < n; ++i) {
            this.m_backupOfImportedField.m_data[i] = pdVectorArray[i].m_data[0];
        }
    }

    protected void restoreField(PdVector pdVector) {
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        int n = this.m_scalar.getNumVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].m_data[0] = pdVector.m_data[i];
        }
    }

    protected void chopField() {
        int n = this.m_scalar.getNumVectors();
        PdVector[] pdVectorArray = this.m_scalar.getVectors();
        double d = this.m_chopMin.getValue();
        double d2 = this.m_chopMax.getValue();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].m_data[0] = this.m_backupField.m_data[i] < d ? d : (this.m_backupField.m_data[i] > d2 ? d2 : this.m_backupField.m_data[i]);
        }
    }

    public PgVectorField computeGradient(PgVectorField pgVectorField) {
        int n = this.m_geom.getDimOfVertices();
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(n);
        }
        pgVectorField.setName(PsConfig.getMessage((int)45078) + " " + this.m_scalarFieldName[this.m_scalarType]);
        pgVectorField.computeGradient(this.m_geom, this.m_scalar.getVectors(), 0);
        this.m_geom.addVectorField(pgVectorField);
        return pgVectorField;
    }

    public static PgVectorField array2ScalarField(PgPointSet pgPointSet, double[] dArray, PgVectorField pgVectorField) {
        if (pgPointSet == null) {
            PsDebug.warning((String)"specified domain is null.");
            return pgVectorField;
        }
        int n = pgPointSet.getNumVertices();
        if (dArray == null || dArray.length != n) {
            PsDebug.warning((String)"length of array specifying a piecewise linear function, does not match with the number of vertices of the domain.");
            return pgVectorField;
        }
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(1);
        }
        pgVectorField.setBasedOn(0);
        if (pgPointSet != pgVectorField.getGeometry()) {
            pgVectorField.setGeometry(pgPointSet);
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray[i].m_data[0] = dArray[i];
        }
        return pgVectorField;
    }

    public static double[] scalarField2Array(PgVectorField pgVectorField, double[] dArray) {
        if (pgVectorField == null) {
            PsDebug.warning((String)"given scalar field is null.");
            return dArray;
        }
        int n = pgVectorField.getNumVectors();
        if (dArray == null || dArray.length != n) {
            dArray = new double[n];
        }
        PdVector[] pdVectorArray = pgVectorField.getVectors();
        for (int i = 0; i < n; ++i) {
            dArray[i] = pdVectorArray[i].m_data[0];
        }
        return dArray;
    }

    public static Color colorMapGray(double d) {
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        float f = (float)d;
        return new Color(f, f, f);
    }

    private static final Color colorMapCurvature(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapCurvatureIntervals[0]) {
            d /= m_ColorMapCurvatureIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int n = m_ColorMapOldIntervals.length;
            for (int i = 1; i < n; ++i) {
                if (!(d < m_ColorMapCurvatureIntervals[i])) continue;
                d -= m_ColorMapCurvatureIntervals[i - 1];
                d /= m_ColorMapCurvatureIntervals[i] - m_ColorMapCurvatureIntervals[i - 1];
                d *= m_ColorMapOldIntervals[i] - m_ColorMapOldIntervals[i - 1];
                d += m_ColorMapOldIntervals[i - 1];
                break;
            }
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    public static Color colorMap(double d) {
        float f;
        float f2;
        if (d < 0.0) {
            d = 0.0;
        }
        if (d > 1.0) {
            d = 1.0;
        }
        if (d < m_ColorMapLinearIntervals[0]) {
            d /= m_ColorMapLinearIntervals[0];
            d *= m_ColorMapOldIntervals[0];
        } else {
            int n = m_ColorMapOldIntervals.length;
            for (int i = 1; i < n; ++i) {
                if (!(d < m_ColorMapLinearIntervals[i])) continue;
                d -= m_ColorMapLinearIntervals[i - 1];
                d /= m_ColorMapLinearIntervals[i] - m_ColorMapLinearIntervals[i - 1];
                d *= m_ColorMapOldIntervals[i] - m_ColorMapOldIntervals[i - 1];
                d += m_ColorMapOldIntervals[i - 1];
                break;
            }
        }
        if (d > 0.2) {
            f2 = 1.0f;
            f = (float)(0.75 - (d -= 0.2));
            if (f < 0.0f) {
                f += 1.0f;
            }
        } else {
            f = 0.75f;
            d *= 5.0;
            d = d * d * d;
            f2 = (float)d;
        }
        return Color.getHSBColor(f, f2, 1.0f);
    }

    protected PgVectorField computer3dVectorField(PgVectorField pgVectorField) {
        pgVectorField = this.get3dVectorField(pgVectorField);
        this.m_geom.addVectorField(pgVectorField);
        return pgVectorField;
    }

    protected PgVectorField get3dVectorField(PgVectorField pgVectorField) {
        if (pgVectorField == null) {
            pgVectorField = new PgVectorField(3);
        }
        pgVectorField.setBasedOn(0);
        pgVectorField.setGeometry((PgPointSet)this.m_geom);
        pgVectorField.setName("Normal offset of " + this.m_scalar.getName());
        int n = this.m_geom.getNumVertices();
        this.m_geom.assureVertexNormals();
        PdVector[] pdVectorArray = this.m_geom.getVertexNormals();
        PdVector[] pdVectorArray2 = this.m_scalar.getVectors();
        PdVector[] pdVectorArray3 = pgVectorField.getVectors();
        for (int i = 0; i < n; ++i) {
            pdVectorArray3[i].multScalar(pdVectorArray[i], pdVectorArray2[i].m_data[0]);
        }
        return pgVectorField;
    }

    protected void showFunctionAsVertexLabels(boolean bl) {
        int n = this.m_geom.getNumVertices();
        PdVector[] pdVectorArray = this.m_geom.getVertices();
        PdVector[] pdVectorArray2 = this.m_scalar.getVectors();
        if (bl) {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].setName(Double.toString(pdVectorArray2[i].m_data[0]));
            }
        } else {
            for (int i = 0; i < n; ++i) {
                pdVectorArray[i].setName(Integer.toString(i));
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

