/*
 * Decompiled with CFR 0.152.
 */
package jvx.rsrc;

import java.util.Date;
import jv.loader.PsXmlLoader;
import jv.object.PsConfig;
import jv.object.PsDebug;
import jv.rsrc.PsAuthorInfo;
import jv.rsrc.PsGeometryInfo;
import jv.rsrc.PsXmlNode;
import jv.rsrc.PsXmlSrc;
import jvx.project.PjWorkshop;
import jvx.rsrc.PsModelInfo_IP;

public final class PsModelInfo
extends PjWorkshop {
    protected static boolean m_bInsideJavaView = true;
    protected transient PsModelInfo_IP m_dialog;
    protected int m_iDialog = 8;
    protected String m_rsrcFile;
    public static final String USAGE_MASTER = "Master";
    public static final String USAGE_PREVIEW = "Preview";
    public static final String USAGE_APPLET = "Applet";
    public static final String USAGE_IMAGE = "Image";
    public static final String USAGE_ORIGINAL = "Original";
    public static final String USAGE_OTHER = "Other";
    public static final String USAGE_PRINT = "Print";
    public static final String USAGE_README = "Readme";
    public static final String FILE_FORMAT_BYU = "BYU";
    public static final String FILE_FORMAT_JVX = "JVX";
    public static final String FILE_FORMAT_OBJ = "OBJ";
    public static final String FILE_FORMAT_POLY = "POLY";
    public static final String FILE_FORMAT_SEPARATOR = "---";
    public static final String FILE_FORMAT_EPS = "EPS";
    public static final String FILE_FORMAT_PS = "PS";
    public static final String FILE_FORMAT_GIF = "GIF";
    public static final String FILE_FORMAT_JPG = "JPG";
    public static final String FILE_FORMAT_PNG = "PNG";
    public static final String FILE_FORMAT_FE = "FE";
    public static final String FILE_FORMAT_MGS = "MGS";
    public static final String FILE_FORMAT_OFF = "OFF";
    public static final String FILE_FORMAT_TXT = "TXT";
    public static final String FILE_FORMAT_HTML = "HTML";
    public static final String FILE_FORMAT_WRL = "WRL";
    public static final String REFERENCE_ARTICLE = "Article";
    public static final String REFERENCE_BOOK = "Book";
    public static final String REFERENCE_INCOLLECTION = "InCollection";
    public static final String REFERENCE_MISC = "Misc";
    public static final String REFERENCE_URL = "URL";
    public static final String EMPTY_ITEM = "---";
    protected String m_egId;
    protected String m_title;
    protected String m_modelName;
    protected PsAuthorInfo m_authorInfo = new PsAuthorInfo();
    protected PsGeometryInfo m_geometryInfo = new PsGeometryInfo();
    protected static final int m_maxNumRefs = 10;
    protected int m_numRefs;
    protected String[] m_refType;
    protected String[] m_refAuthor;
    protected String[] m_refTitle;
    protected String[] m_refBooktitle;
    protected String[] m_refEditor;
    protected String[] m_refJournal;
    protected String[] m_refPages;
    protected String[] m_refLink;
    protected String[] m_refVolume;
    protected String[] m_refNumber;
    protected String[] m_refPublisher;
    protected String[] m_refYear;
    protected String[] m_refNote;
    protected static final int m_maxNumFiles = 20;
    protected int m_numFiles;
    protected boolean[] m_autoGen;
    protected String[] m_usage;
    protected String[] m_fileName;
    protected String[] m_fileFormat;
    protected String[] m_fileSize;
    protected String[] m_imageWidth;
    protected String[] m_imageHeight;
    protected String m_fileComment;

    public PsModelInfo() {
        super("Submission Dialog");
        this.init();
    }

    public void init() {
        int n;
        super.init();
        this.m_egId = null;
        this.m_title = null;
        this.m_modelName = "";
        this.m_authorInfo.init();
        this.m_geometryInfo.init();
        this.createReferences(10);
        for (n = this.m_numRefs = 0; n < 10; ++n) {
            this.m_refType[n] = null;
            this.m_refAuthor[n] = null;
            this.m_refTitle[n] = null;
            this.m_refJournal[n] = null;
            this.m_refBooktitle[n] = null;
            this.m_refEditor[n] = null;
            this.m_refPages[n] = null;
            this.m_refLink[n] = null;
            this.m_refVolume[n] = null;
            this.m_refNumber[n] = null;
            this.m_refPublisher[n] = null;
            this.m_refYear[n] = null;
            this.m_refNote[n] = null;
        }
        this.createFiles(20);
        this.m_numFiles = 3;
        this.m_usage[0] = USAGE_MASTER;
        this.m_autoGen[0] = true;
        this.m_fileFormat[0] = FILE_FORMAT_JVX;
        this.m_fileName[0] = this.m_modelName + "_" + this.m_usage[0];
        this.m_usage[1] = USAGE_APPLET;
        this.m_autoGen[1] = true;
        this.m_fileFormat[1] = FILE_FORMAT_JVX;
        this.m_fileName[1] = this.m_modelName + "_" + this.m_usage[1];
        this.m_usage[2] = USAGE_PREVIEW;
        this.m_autoGen[2] = true;
        this.m_fileFormat[2] = FILE_FORMAT_GIF;
        this.m_fileName[2] = this.m_modelName + "_" + this.m_usage[2];
        for (n = this.m_numFiles; n < 20; ++n) {
            this.m_autoGen[n] = false;
            this.m_usage[n] = null;
            this.m_fileName[n] = null;
            this.m_fileFormat[n] = null;
            this.m_fileSize[n] = null;
            this.m_imageWidth[n] = null;
            this.m_imageHeight[n] = null;
        }
        this.m_fileComment = null;
    }

    public Object clone() {
        PsModelInfo psModelInfo = (PsModelInfo)((Object)super.clone());
        if (psModelInfo == null) {
            return null;
        }
        if (this.m_refType != null) {
            psModelInfo.m_refType = (String[])this.m_refType.clone();
        }
        if (this.m_refAuthor != null) {
            psModelInfo.m_refAuthor = (String[])this.m_refAuthor.clone();
        }
        if (this.m_refTitle != null) {
            psModelInfo.m_refTitle = (String[])this.m_refTitle.clone();
        }
        if (this.m_refJournal != null) {
            psModelInfo.m_refJournal = (String[])this.m_refJournal.clone();
        }
        if (this.m_refBooktitle != null) {
            psModelInfo.m_refBooktitle = (String[])this.m_refBooktitle.clone();
        }
        if (this.m_refEditor != null) {
            psModelInfo.m_refEditor = (String[])this.m_refEditor.clone();
        }
        if (this.m_refPages != null) {
            psModelInfo.m_refPages = (String[])this.m_refPages.clone();
        }
        if (this.m_refLink != null) {
            psModelInfo.m_refLink = (String[])this.m_refLink.clone();
        }
        if (this.m_refVolume != null) {
            psModelInfo.m_refVolume = (String[])this.m_refVolume.clone();
        }
        if (this.m_refNumber != null) {
            psModelInfo.m_refNumber = (String[])this.m_refNumber.clone();
        }
        if (this.m_refPublisher != null) {
            psModelInfo.m_refPublisher = (String[])this.m_refPublisher.clone();
        }
        if (this.m_refYear != null) {
            psModelInfo.m_refYear = (String[])this.m_refYear.clone();
        }
        if (this.m_refNote != null) {
            psModelInfo.m_refNote = (String[])this.m_refNote.clone();
        }
        return psModelInfo;
    }

    public static final void runningInsideJavaView(boolean bl) {
        m_bInsideJavaView = bl;
    }

    private void createReferences(int n) {
        this.m_refType = new String[n];
        this.m_refAuthor = new String[n];
        this.m_refTitle = new String[n];
        this.m_refJournal = new String[n];
        this.m_refBooktitle = new String[n];
        this.m_refEditor = new String[n];
        this.m_refPages = new String[n];
        this.m_refLink = new String[n];
        this.m_refVolume = new String[n];
        this.m_refNumber = new String[n];
        this.m_refPublisher = new String[n];
        this.m_refYear = new String[n];
        this.m_refNote = new String[n];
    }

    private void createFiles(int n) {
        this.m_autoGen = new boolean[n];
        this.m_usage = new String[n];
        this.m_fileName = new String[n];
        this.m_fileFormat = new String[n];
        this.m_fileSize = new String[n];
        this.m_imageWidth = new String[n];
        this.m_imageHeight = new String[n];
    }

    public String getRsrcFile() {
        return this.m_rsrcFile;
    }

    public PsAuthorInfo getAuthorInfo() {
        return this.m_authorInfo;
    }

    public void setAuthorInfo(PsAuthorInfo psAuthorInfo) {
        this.m_authorInfo = psAuthorInfo;
    }

    public PsGeometryInfo getGeometryInfo() {
        return this.m_geometryInfo;
    }

    public void setGeometryInfo(PsGeometryInfo psGeometryInfo) {
        this.m_geometryInfo = psGeometryInfo;
    }

    public boolean read(String string) {
        if (string == null) {
            PsDebug.warning((String)"missing argument file name.");
            return false;
        }
        PsXmlSrc psXmlSrc = PsXmlLoader.read((String)string);
        if (psXmlSrc == null) {
            PsDebug.warning((String)("could not read rsrc file = " + string));
            return false;
        }
        this.setXml(psXmlSrc);
        return true;
    }

    public PsXmlSrc getXml() {
        PsXmlNode psXmlNode;
        int n;
        PsXmlSrc psXmlSrc = new PsXmlSrc();
        psXmlSrc.setDocName("eg-model");
        psXmlSrc.setDocType("http://www.eg-models.de/rsrc/eg-model.dtd");
        PsXmlNode psXmlNode2 = new PsXmlNode("eg-model");
        psXmlSrc.setRootNode(psXmlNode2);
        PsXmlNode[] psXmlNodeArray = new PsXmlNode[2];
        psXmlNodeArray[0] = psXmlNode2.addChild("meta");
        psXmlNodeArray[0].addAttribute("generator", PsConfig.getProgramAndVersion());
        psXmlNodeArray[1] = psXmlNode2.addChild("meta");
        psXmlNodeArray[1].addAttribute("date", new Date().toString());
        psXmlNode2.addChild("eg-id", this.m_egId);
        psXmlNode2.addChild("title", this.m_title);
        psXmlNode2.addChild("modelname", this.m_modelName);
        psXmlNode2.addChild(this.m_authorInfo.getXmlNode());
        PsXmlNode psXmlNode3 = this.m_geometryInfo.getXmlNode();
        psXmlNode2.addChild(psXmlNode3);
        PsXmlNode psXmlNode4 = psXmlNode3.addChild("references");
        for (n = 0; n < this.m_numRefs; ++n) {
            psXmlNode = null;
            if (this.m_refType[n].equals(REFERENCE_ARTICLE)) {
                psXmlNode = psXmlNode4.addChild("refarticle");
                psXmlNode.addChild("refauthor", this.m_refAuthor[n]);
                psXmlNode.addChild("reftitle", this.m_refTitle[n]);
                psXmlNode.addChild("refjournal", this.m_refJournal[n]);
                psXmlNode.addChild("refpages", this.m_refPages[n]);
                psXmlNode.addChild("refyear", this.m_refYear[n]);
                psXmlNode.addChild("refvolume", this.m_refVolume[n]);
                psXmlNode.addChild("refnumber", this.m_refNumber[n]);
                psXmlNode.addChild("reflink", this.m_refLink[n]);
            } else if (this.m_refType[n].equals(REFERENCE_BOOK)) {
                psXmlNode = psXmlNode4.addChild("refbook");
                psXmlNode.addChild("refauthor", this.m_refAuthor[n]);
                psXmlNode.addChild("refbooktitle", this.m_refBooktitle[n]);
                psXmlNode.addChild("refpublisher", this.m_refPublisher[n]);
                psXmlNode.addChild("refyear", this.m_refYear[n]);
                psXmlNode.addChild("reflink", this.m_refLink[n]);
            } else if (this.m_refType[n].equals(REFERENCE_INCOLLECTION)) {
                psXmlNode = psXmlNode4.addChild("refincollection");
                psXmlNode.addChild("refauthor", this.m_refAuthor[n]);
                psXmlNode.addChild("reftitle", this.m_refTitle[n]);
                psXmlNode.addChild("refbooktitle", this.m_refBooktitle[n]);
                psXmlNode.addChild("refeditor", this.m_refEditor[n]);
                psXmlNode.addChild("refpublisher", this.m_refPublisher[n]);
                psXmlNode.addChild("refpages", this.m_refPages[n]);
                psXmlNode.addChild("refyear", this.m_refYear[n]);
                psXmlNode.addChild("reflink", this.m_refLink[n]);
            } else if (this.m_refType[n].equals(REFERENCE_MISC)) {
                psXmlNode = psXmlNode4.addChild("refmisc");
                psXmlNode.addChild("refauthor", this.m_refAuthor[n]);
                psXmlNode.addChild("reftitle", this.m_refTitle[n]);
                psXmlNode.addChild("refyear", this.m_refYear[n]);
                psXmlNode.addChild("refnote", this.m_refNote[n]);
                psXmlNode.addChild("reflink", this.m_refLink[n]);
            } else if (this.m_refType[n].equals(REFERENCE_URL)) {
                psXmlNode = psXmlNode4.addChild("refurl");
                psXmlNode.addChild("refauthor", this.m_refAuthor[n]);
                psXmlNode.addChild("reftitle", this.m_refTitle[n]);
                psXmlNode.addChild("refnote", this.m_refNote[n]);
                psXmlNode.addChild("reflink", this.m_refLink[n]);
            } else {
                PsDebug.warning((String)("void reference type = " + this.m_refType[n]));
            }
            psXmlNode.addAttribute("num", String.valueOf(n + 1));
        }
        psXmlNode = psXmlNode2.addChild("files");
        for (n = 0; n < this.m_numFiles; ++n) {
            PsXmlNode psXmlNode5 = null;
            if (this.m_usage[n].equalsIgnoreCase(USAGE_MASTER)) {
                psXmlNode5 = psXmlNode.addChild("file_master");
            } else if (this.m_usage[n].equalsIgnoreCase(USAGE_PREVIEW)) {
                psXmlNode5 = psXmlNode.addChild("file_preview");
            } else if (this.m_usage[n].equals(USAGE_APPLET)) {
                psXmlNode5 = psXmlNode.addChild("file_applet");
            } else if (this.m_usage[n].equalsIgnoreCase(USAGE_IMAGE)) {
                psXmlNode5 = psXmlNode.addChild("file_image");
            } else if (this.m_usage[n].equalsIgnoreCase(USAGE_OTHER)) {
                psXmlNode5 = psXmlNode.addChild("file_other");
            } else if (this.m_usage[n].equalsIgnoreCase(USAGE_ORIGINAL)) {
                psXmlNode5 = psXmlNode.addChild("file_original");
            } else if (this.m_usage[n].equalsIgnoreCase(USAGE_PRINT)) {
                psXmlNode5 = psXmlNode.addChild("file_print");
            } else if (this.m_usage[n].equalsIgnoreCase(USAGE_README)) {
                psXmlNode5 = psXmlNode.addChild("file_readme");
            } else {
                PsDebug.warning((String)("unknown usage type = " + this.m_usage[n]));
                continue;
            }
            psXmlNode5.addAttribute("format", this.m_fileFormat[n].toLowerCase());
            psXmlNode5.addChild("filename", this.m_fileName[n]);
            psXmlNode5.addChild("filesize", this.m_fileSize[n]);
            if (!this.m_usage[n].equalsIgnoreCase(USAGE_PREVIEW) && !this.m_usage[n].equalsIgnoreCase(USAGE_IMAGE)) continue;
            psXmlNode5.addChild("imagewidth", this.m_imageWidth[n]);
            psXmlNode5.addChild("imageheight", this.m_imageHeight[n]);
        }
        psXmlNode.addChild("filecomment", this.m_fileComment);
        return psXmlSrc;
    }

    public void setXml(PsXmlSrc psXmlSrc) {
        int n;
        PsXmlNode[] psXmlNodeArray;
        PsXmlNode psXmlNode;
        boolean bl;
        this.init();
        if (psXmlSrc == null) {
            PsDebug.warning((String)"missing parameter.");
            return;
        }
        this.m_rsrcFile = psXmlSrc.getRsrcFile();
        PsXmlNode psXmlNode2 = psXmlSrc.getRootNode();
        if (psXmlNode2 == null) {
            PsDebug.warning((String)"missing element: eg-model.");
            return;
        }
        this.m_egId = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode2, (String)"eg-id");
        this.m_title = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode2, (String)"title");
        this.m_modelName = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode2, (String)"modelname");
        this.m_authorInfo.setXmlNode(psXmlNode2.getChild("authors"));
        PsXmlNode psXmlNode3 = psXmlNode2.getChild("description");
        String string = psXmlNode3.getType();
        if (string == null || !string.equals("description")) {
            PsDebug.error((String)("source node has wrong type = " + string));
            return;
        }
        PsXmlNode psXmlNode4 = psXmlNode2.getChild("classification");
        this.m_geometryInfo.setXmlNode(psXmlNode3, psXmlNode4);
        boolean bl2 = bl = psXmlNode4 != null;
        if (!bl) {
            psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"references");
            if (psXmlNode == null) {
                this.m_numRefs = 0;
            } else {
                psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode);
                if (psXmlNodeArray == null || psXmlNodeArray.length == 0) {
                    PsDebug.warning((String)"missing element: reference.");
                    return;
                }
                this.m_numRefs = psXmlNodeArray.length;
                if (this.m_numRefs > 10) {
                    PsDebug.warning((String)"too many references, some are ignored.");
                    this.m_numRefs = 10;
                }
                for (n = 0; n < this.m_numRefs; ++n) {
                    string = psXmlNodeArray[n].getType();
                    if (string.equals("refarticle")) {
                        this.m_refType[n] = REFERENCE_ARTICLE;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                        this.m_refJournal[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refjournal");
                        this.m_refPages[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpages");
                        this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                        this.m_refVolume[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refvolume");
                        this.m_refNumber[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refnumber");
                        this.m_refLink[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reflink");
                        continue;
                    }
                    if (string.equals("refbook")) {
                        this.m_refType[n] = REFERENCE_BOOK;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                        this.m_refBooktitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refbooktitle");
                        this.m_refPublisher[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpublisher");
                        this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                        this.m_refLink[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reflink");
                        continue;
                    }
                    if (string.equals("refincollection")) {
                        this.m_refType[n] = REFERENCE_INCOLLECTION;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                        this.m_refBooktitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refbooktitle");
                        this.m_refEditor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refeditor");
                        this.m_refPublisher[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpublisher");
                        this.m_refPages[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpages");
                        this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                        this.m_refLink[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reflink");
                        continue;
                    }
                    if (string.equals("refmisc")) {
                        this.m_refType[n] = REFERENCE_MISC;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                        this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                        this.m_refNote[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refnote");
                        this.m_refLink[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reflink");
                        continue;
                    }
                    if (string.equals("refurl")) {
                        this.m_refType[n] = REFERENCE_URL;
                        this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                        this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                        this.m_refNote[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refnote");
                        this.m_refLink[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reflink");
                        continue;
                    }
                    PsDebug.warning((String)("void reference type = " + string));
                }
            }
        } else {
            psXmlNode = PsXmlSrc.getRsrcNode((PsXmlNode)psXmlNode3, (String)"references");
            if (psXmlNode == null) {
                this.m_numRefs = 0;
                PsDebug.warning((String)"missing references node.");
            } else {
                psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode);
                if (psXmlNodeArray != null && psXmlNodeArray.length > 0) {
                    this.m_numRefs = psXmlNodeArray.length;
                    if (this.m_numRefs > 10) {
                        PsDebug.warning((String)"too many references, some are ignored.");
                        this.m_numRefs = 10;
                    }
                    for (n = 0; n < this.m_numRefs; ++n) {
                        string = psXmlNodeArray[n].getType();
                        if (string.equals("refarticle")) {
                            this.m_refType[n] = REFERENCE_ARTICLE;
                            this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                            this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                            this.m_refJournal[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refjournal");
                            this.m_refPages[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpages");
                            this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                            this.m_refVolume[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refvolume");
                            this.m_refNumber[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refnumber");
                            continue;
                        }
                        if (string.equals("refbook")) {
                            this.m_refType[n] = REFERENCE_BOOK;
                            this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                            this.m_refBooktitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refbooktitle");
                            this.m_refPublisher[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpublisher");
                            this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                            continue;
                        }
                        if (string.equals("refincollection")) {
                            this.m_refType[n] = REFERENCE_INCOLLECTION;
                            this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                            this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                            this.m_refBooktitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refbooktitle");
                            this.m_refEditor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refeditor");
                            this.m_refPublisher[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpublisher");
                            this.m_refPages[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refpages");
                            this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                            continue;
                        }
                        if (string.equals("refmisc")) {
                            this.m_refType[n] = REFERENCE_MISC;
                            this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                            this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                            this.m_refYear[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refyear");
                            this.m_refNote[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refnote");
                            continue;
                        }
                        if (string.equals("refurl")) {
                            this.m_refType[n] = REFERENCE_URL;
                            this.m_refAuthor[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"refauthor");
                            this.m_refTitle[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reftitle");
                            this.m_refLink[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"reflink");
                            continue;
                        }
                        PsDebug.warning((String)("void reference type = " + string));
                    }
                }
            }
        }
        psXmlNode = psXmlNode2.getChild("files");
        if (psXmlNode == null) {
            this.m_numFiles = 0;
            PsDebug.warning((String)"missing element: files.");
        } else {
            psXmlNodeArray = PsXmlSrc.getRsrcNodes((PsXmlNode)psXmlNode);
            if (psXmlNode4 != null) {
                this.m_geometryInfo.setSoftware(PsXmlSrc.getRsrc((PsXmlNode)psXmlNode, (String)"softwareproduced"));
                PsDebug.warning((String)"old version of eg-model.dtd encountered.\n\tAutomatic conversion into new format when saving.");
            }
            this.m_fileComment = PsXmlSrc.getRsrc((PsXmlNode)psXmlNode, (String)"filecomment");
            if (psXmlNodeArray != null) {
                this.m_numFiles = psXmlNodeArray.length;
                this.m_numFiles = Math.max(this.m_numFiles, 0);
                if (this.m_numFiles > 20) {
                    PsDebug.warning((String)"too many files, some are ignored.");
                    this.m_numFiles = 20;
                }
            } else {
                this.m_numFiles = 0;
            }
            for (n = 0; n < this.m_numFiles; ++n) {
                string = psXmlNodeArray[n].getType();
                if (string.equals("file_master")) {
                    this.m_usage[n] = USAGE_MASTER;
                } else if (string.equals("file_preview")) {
                    this.m_usage[n] = USAGE_PREVIEW;
                } else if (string.equals("file_applet")) {
                    this.m_usage[n] = USAGE_APPLET;
                } else if (string.equals("file_image")) {
                    this.m_usage[n] = USAGE_IMAGE;
                } else if (string.equals("file_other")) {
                    this.m_usage[n] = USAGE_OTHER;
                } else if (string.equals("file_original")) {
                    this.m_usage[n] = USAGE_ORIGINAL;
                } else if (string.equals("file_print")) {
                    this.m_usage[n] = USAGE_PRINT;
                } else {
                    if (!string.equals("file_readme")) break;
                    this.m_usage[n] = USAGE_README;
                }
                String string2 = psXmlNodeArray[n].getAttribute("format");
                this.m_fileFormat[n] = string2 != null ? string2.toUpperCase() : null;
                this.m_fileName[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"filename");
                this.m_fileSize[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"filesize");
                if (!this.m_usage[n].equalsIgnoreCase(USAGE_PREVIEW) && !this.m_usage[n].equalsIgnoreCase(USAGE_IMAGE)) continue;
                this.m_imageWidth[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"imagewidth");
                this.m_imageHeight[n] = PsXmlSrc.getRsrc((PsXmlNode)psXmlNodeArray[n], (String)"imageheight");
            }
        }
    }

    public boolean update(Object object) {
        if (object == this) {
            this.m_authorInfo.update((Object)this.m_authorInfo);
            this.m_geometryInfo.update((Object)this.m_geometryInfo);
            super.update((Object)this);
        }
        return super.update(object);
    }
}

