/*
 * Decompiled with CFR 0.152.
 */
package jvx.numeric;

import jv.geom.PgElementSet;
import jv.object.PsDebug;
import jv.object.PsObject;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;
import jv.vecmath.PuVectorGeom;
import jvx.geom.PwCurvature;
import jvx.numeric.PnEnergy;

public class PnGaussEnergy
extends PnEnergy {
    protected int m_noe;
    protected PdVector[] m_v;
    protected PdVector[] m_cVec;
    protected PdVector m_cLen;
    protected PdVector m_cSin;
    protected PdVector[] m_JcVec;
    protected PdVector m_grad;
    protected PdVector m_gauss;
    protected PgElementSet m_geomClone;
    static /* synthetic */ Class class$jvx$numeric$PnGaussEnergy;

    public PnGaussEnergy() {
        if (((Object)((Object)this)).getClass() == (class$jvx$numeric$PnGaussEnergy == null ? (class$jvx$numeric$PnGaussEnergy = PnGaussEnergy.class$("jvx.numeric.PnGaussEnergy")) : class$jvx$numeric$PnGaussEnergy)) {
            this.init();
        }
    }

    public void init() {
        super.init();
        this.m_v = null;
        this.m_cVec = null;
        this.m_cLen = null;
        this.m_cSin = null;
        this.m_JcVec = null;
        this.m_grad = null;
        this.m_gauss = null;
    }

    public void initSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
    }

    public boolean setSurface(PgElementSet pgElementSet, PgElementSet pgElementSet2) {
        if (pgElementSet2 == null) {
            PsDebug.warning((String)"missing surface geometry.");
            return false;
        }
        if (!super.setSurface(pgElementSet, pgElementSet2)) {
            return false;
        }
        if (this.m_surface.getDimOfElements() != 3) {
            PsDebug.warning((String)("surface=" + this.m_surface.getName() + " not triangulated"));
            PgElementSet.triangulate((PgElementSet)this.m_surface);
        }
        if (this.m_geomClone == null) {
            this.m_geomClone = (PgElementSet)this.m_surface.clone();
        } else {
            this.m_geomClone.copy((PsObject)this.m_surface);
        }
        if (this.m_v == null || this.m_v[0].getSize() != this.m_dim) {
            this.m_v = PdVector.realloc((PdVector[])this.m_v, (int)3, (int)this.m_dim);
            this.m_cVec = PdVector.realloc((PdVector[])this.m_cVec, (int)3, (int)this.m_dim);
            this.m_cLen = new PdVector(3);
            this.m_cSin = new PdVector(3);
            this.m_JcVec = PdVector.realloc((PdVector[])this.m_JcVec, (int)3, (int)this.m_dim);
            this.m_grad = new PdVector(this.m_dim);
            this.m_gauss = new PdVector();
        }
        this.m_gauss.setSize(pgElementSet2.getNumVertices());
        this.m_noe = this.m_surface.getNumElements();
        return true;
    }

    public double eval(PdVector pdVector) {
        PdVector[] pdVectorArray = this.m_geomClone.getVertices();
        int n = this.m_geomClone.getNumVertices();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                pdVectorArray[i].m_data[j] = pdVector.m_data[n2++];
            }
        }
        PwCurvature.getGaussCurvature(this.m_geomClone, this.m_gauss);
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            double d2 = this.m_gauss.getEntry(i);
            d += d2 * d2;
        }
        return d;
    }

    public PdVector evalGradient(PdVector pdVector, PdVector pdVector2) {
        if (pdVector2 == null) {
            if (this.m_store == null || this.m_store.getSize() == 0 && pdVector.getSize() != 0) {
                PsDebug.warning((String)"PnEnergy not initialized, cannot evaluate gradient");
                return null;
            }
            pdVector2 = this.m_store;
        }
        pdVector2.setConstant(0.0);
        PdVector[] pdVectorArray = this.m_geomClone.getVertices();
        int n = this.m_geomClone.getNumVertices();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < this.m_dim; ++j) {
                pdVectorArray[i].m_data[j] = pdVector.m_data[n2++];
            }
        }
        PwCurvature.getGaussCurvature(this.m_geomClone, this.m_gauss);
        PiVector[] piVectorArray = this.m_geomClone.getElements();
        PdVector pdVector3 = new PdVector(3);
        double[] dArray = pdVector3.m_data;
        boolean bl = false;
        for (int i = 0; i < this.m_noe; ++i) {
            int n3;
            int n4;
            for (n4 = 0; n4 < 3; ++n4) {
                n2 = this.m_dim * piVectorArray[i].getEntry(n4);
                for (int j = 0; j < this.m_dim; ++j) {
                    this.m_v[n4].m_data[j] = pdVector.m_data[n2++];
                }
            }
            PuVectorGeom.ctg((double[])dArray, (PdVector)this.m_v[0], (PdVector)this.m_v[1], (PdVector)this.m_v[2]);
            if (!bl && pdVector3.maxAbs() > 10000.0) {
                bl = true;
                PsDebug.warning((String)("ctg out of range, first in elem = " + i));
            }
            for (n4 = 0; n4 < 3; ++n4) {
                this.m_cVec[n4].sub(this.m_v[(n4 + 2) % 3], this.m_v[(n4 + 1) % 3]);
                this.m_cLen.setEntry(n4, this.m_cVec[n4].length());
            }
            double d = this.m_geomClone.getAreaOfElement(i);
            for (n3 = 0; n3 < 3; ++n3) {
                this.m_cSin.setEntry(n3, 2.0 * d / (this.m_cLen.getEntry((n3 + 2) % 3) * this.m_cLen.getEntry((n3 + 1) % 3)));
            }
            for (n3 = 0; n3 < 3; ++n3) {
                this.m_JcVec[n3].blend(dArray[(n3 + 1) % 3], this.m_cVec[(n3 + 1) % 3], -dArray[(n3 + 2) % 3], this.m_cVec[(n3 + 2) % 3]);
            }
            for (int j = 0; j < 3; ++j) {
                int n5;
                n3 = piVectorArray[i].getEntry(j);
                n2 = this.m_dim * n3;
                this.m_grad.sub(this.m_cVec[(j + 2) % 3], this.m_cVec[(j + 1) % 3]);
                this.m_grad.blendBase(this.m_grad, dArray[j], this.m_JcVec[j]);
                this.m_grad.multScalar(-2.0 * this.m_cSin.getEntry(j) * this.m_gauss.getEntry(n3) / (this.m_cLen.getEntry((j + 2) % 3) * this.m_cLen.getEntry((j + 1) % 3)));
                for (n5 = 0; n5 < this.m_dim; ++n5) {
                    int n6 = n2++;
                    pdVector2.m_data[n6] = pdVector2.m_data[n6] + this.m_grad.m_data[n5];
                }
                int n7 = piVectorArray[i].getEntry((j + 1) % 3);
                n2 = this.m_dim * n7;
                this.m_grad.copy(this.m_JcVec[(j + 2) % 3]);
                this.m_grad.multScalar(-2.0 * this.m_gauss.getEntry(n7) / (this.m_cLen.getEntry((j + 2) % 3) * this.m_cLen.getEntry((j + 2) % 3)));
                for (n5 = 0; n5 < this.m_dim; ++n5) {
                    int n8 = n2++;
                    pdVector2.m_data[n8] = pdVector2.m_data[n8] + this.m_grad.m_data[n5];
                }
                n7 = piVectorArray[i].getEntry((j + 2) % 3);
                n2 = this.m_dim * n7;
                this.m_grad.copy(this.m_JcVec[(j + 1) % 3]);
                this.m_grad.multScalar(-2.0 * this.m_gauss.getEntry(n7) / (this.m_cLen.getEntry((j + 1) % 3) * this.m_cLen.getEntry((j + 1) % 3)));
                for (n5 = 0; n5 < this.m_dim; ++n5) {
                    int n9 = n2++;
                    pdVector2.m_data[n9] = pdVector2.m_data[n9] + this.m_grad.m_data[n5];
                }
            }
        }
        return this.constrainGradient(pdVector, pdVector2);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

