/*
 * Decompiled with CFR 0.152.
 */
package jvx.loader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.Enumeration;
import java.util.Vector;
import jv.loader.PgAbstractLoader;
import jv.object.PsDebug;
import jv.project.PgJvxSrc;
import jv.vecmath.PdVector;
import jv.vecmath.PiVector;

public final class PgAnsLoader
extends PgAbstractLoader {
    protected String m_line;
    protected int m_lineInd = -1;

    public PgJvxSrc[] read(BufferedReader bufferedReader) {
        if (bufferedReader == null) {
            PsDebug.warning((String)"missing reader");
            return null;
        }
        PgJvxSrc pgJvxSrc = new PgJvxSrc();
        pgJvxSrc.setType(34);
        try {
            boolean bl = this.parse(bufferedReader, pgJvxSrc);
            if (!bl) {
                PsDebug.warning((String)"error during parsing of reader");
                return null;
            }
        }
        catch (IOException iOException) {
            PsDebug.warning((String)"exception during parsing of reader");
            iOException.printStackTrace();
            return null;
        }
        PgAnsLoader.geomInitType(pgJvxSrc);
        return new PgJvxSrc[]{pgJvxSrc};
    }

    private static void geomInitType(PgJvxSrc pgJvxSrc) {
        switch (pgJvxSrc.getType()) {
            case 30: {
                pgJvxSrc.showVertices(true);
                break;
            }
            case 33: {
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                break;
            }
            case 34: {
                pgJvxSrc.showEdges(true);
                pgJvxSrc.showElements(true);
                break;
            }
            case 32: {
                pgJvxSrc.showVertices(true);
                pgJvxSrc.showPolygons(true);
                pgJvxSrc.showEdges(true);
            }
        }
    }

    private StreamTokenizer readLine(BufferedReader bufferedReader) throws IOException {
        ++this.m_lineInd;
        this.m_line = bufferedReader.readLine();
        if (this.m_line == null) {
            return null;
        }
        StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(this.m_line));
        streamTokenizer.whitespaceChars(47, 47);
        streamTokenizer.whitespaceChars(44, 44);
        streamTokenizer.eolIsSignificant(true);
        return streamTokenizer;
    }

    protected boolean parse(BufferedReader bufferedReader, PgJvxSrc pgJvxSrc) throws IOException {
        StreamTokenizer streamTokenizer = this.readLine(bufferedReader);
        if (streamTokenizer == null) {
            PsDebug.warning((String)"error in header parsing.");
            return false;
        }
        int n = streamTokenizer.nextToken();
        if ("COM".equals(streamTokenizer.sval)) {
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            Vector<PdVector> vector = new Vector<PdVector>();
            Vector<PiVector> vector2 = new Vector<PiVector>();
            int n7 = 6;
            int n8 = 4;
            int[] nArray = new int[16];
            int[][] nArray2 = new int[n7][n8];
            boolean bl = false;
            block6: while (!bl) {
                streamTokenizer = this.readLine(bufferedReader);
                n = streamTokenizer.nextToken();
                while (n != -1) {
                    if (n == -3 && "NBLOCK".equals(streamTokenizer.sval)) {
                        bl = true;
                        continue block6;
                    }
                    n = streamTokenizer.nextToken();
                }
            }
            streamTokenizer = this.readLine(bufferedReader);
            boolean bl2 = true;
            try {
                while (bl2) {
                    streamTokenizer = this.readLine(bufferedReader);
                    n = streamTokenizer.nextToken();
                    if (n == -3) {
                        streamTokenizer.pushBack();
                        bl2 = false;
                        break;
                    }
                    n6 = 8;
                    n5 = 0;
                    n4 = Integer.parseInt(this.m_line.substring(0, n6).trim());
                    int n9 = 16;
                    n3 = 3;
                    PdVector pdVector = new PdVector(n3);
                    n5 = 3 * n6;
                    int n10 = this.m_line.length();
                    for (n2 = 0; n2 < n3 && n10 > n5; n5 += n9, ++n2) {
                        pdVector.m_data[n2] = Double.valueOf(this.m_line.substring(n5, n5 + n9).trim());
                    }
                    vector.addElement(pdVector);
                }
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("error at line = " + this.m_lineInd + "\n\tdump of currently scanned string: " + this.m_line + "\n\tnumber format error in vertex list"));
                return false;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                PsDebug.warning((String)("error at line = " + this.m_lineInd + "\n\tdump of currently scanned string: " + this.m_line + "\n\tstring index out of bounds error in vertex list"));
                return false;
            }
            boolean bl3 = true;
            streamTokenizer = this.readLine(bufferedReader);
            streamTokenizer = this.readLine(bufferedReader);
            try {
                while (bl3) {
                    streamTokenizer = this.readLine(bufferedReader);
                    n = streamTokenizer.nextToken();
                    if (n == -3) {
                        streamTokenizer.pushBack();
                        bl3 = false;
                    } else if (n != -2 || streamTokenizer.nval != -1.0) {
                        String string = this.m_line;
                        this.readLine(bufferedReader);
                        string = string + this.m_line;
                        n6 = 7;
                        int n11 = 27;
                        n3 = 16;
                        n5 = (n11 - n3 - 1) * n6;
                        n4 = Integer.parseInt(string.substring(n5, n5 + n6).trim());
                        for (n2 = 0; n2 < n3; ++n2) {
                            nArray[n2] = Integer.parseInt(string.substring(n5 += n6, n5 + n6).trim()) - 1;
                        }
                        nArray2[0][0] = nArray[3];
                        nArray2[0][1] = nArray[0];
                        nArray2[0][2] = nArray[4];
                        nArray2[0][3] = nArray[5];
                        nArray2[1][0] = nArray[3];
                        nArray2[1][1] = nArray[2];
                        nArray2[1][2] = nArray[1];
                        nArray2[1][3] = nArray[5];
                        nArray2[2][0] = nArray[3];
                        nArray2[2][1] = nArray[7];
                        nArray2[2][2] = nArray[6];
                        nArray2[2][3] = nArray[5];
                        nArray2[3][0] = nArray[1];
                        nArray2[3][1] = nArray[0];
                        nArray2[3][2] = nArray[3];
                        nArray2[3][3] = nArray[5];
                        nArray2[4][0] = nArray[6];
                        nArray2[4][1] = nArray[2];
                        nArray2[4][2] = nArray[3];
                        nArray2[4][3] = nArray[5];
                        nArray2[5][0] = nArray[4];
                        nArray2[5][1] = nArray[7];
                        nArray2[5][2] = nArray[3];
                        nArray2[5][3] = nArray[5];
                        for (int i = 0; i < n7; ++i) {
                            int[] nArray3 = nArray2[i];
                            if (nArray3[0] == nArray3[1] || nArray3[0] == nArray3[2] || nArray3[0] == nArray3[3] || nArray3[1] == nArray3[2] || nArray3[1] == nArray3[3] || nArray3[2] == nArray3[3]) continue;
                            vector2.addElement(new PiVector(nArray3));
                        }
                        continue;
                    }
                    break;
                }
            }
            catch (NumberFormatException numberFormatException) {
                PsDebug.warning((String)("error at line = " + this.m_lineInd + "\n\tdump of currently scanned string: " + this.m_line + "\n\tnumber format error in conncetivity list"));
                return false;
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                PsDebug.warning((String)("error at line = " + this.m_lineInd + "\n\tdump of currently scanned string: " + this.m_line + "\n\tstring index out of bounds error in conncetivity list"));
                return false;
            }
            PsDebug.notify((String)"... finished");
            int n12 = vector.size();
            if (n12 == 0) {
                return false;
            }
            pgJvxSrc.setDimOfVertices(3);
            pgJvxSrc.setNumVertices(n12);
            n4 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                pgJvxSrc.setVertex(n4++, (PdVector)enumeration.nextElement());
            }
            int n13 = vector2.size();
            if (n13 == 0) {
                return false;
            }
            pgJvxSrc.setDimOfElements(8);
            pgJvxSrc.setNumElements(n13);
            n4 = 0;
            Enumeration enumeration2 = vector2.elements();
            while (enumeration2.hasMoreElements()) {
                pgJvxSrc.setElement(n4++, (PiVector)enumeration2.nextElement());
            }
        } else {
            PdVector pdVector;
            int n14;
            int n15 = 0;
            Vector<PdVector> vector = new Vector<PdVector>();
            streamTokenizer = this.readLine(bufferedReader);
            while (streamTokenizer.nextToken() != -3 || !"NODE".equals(streamTokenizer.sval)) {
                streamTokenizer = this.readLine(bufferedReader);
            }
            n = streamTokenizer.nextToken();
            while (n == -3) {
                ++n15;
                n = streamTokenizer.nextToken();
            }
            while ((streamTokenizer = this.readLine(bufferedReader)) != null) {
                n = streamTokenizer.nextToken();
                if (n != -2) continue;
                n14 = (int)streamTokenizer.nval - 1;
                pdVector = new PdVector(n15);
                for (int i = 0; i < n15; ++i) {
                    n = streamTokenizer.nextToken();
                    if (n == -2) {
                        pdVector.setEntry(i, streamTokenizer.nval);
                        continue;
                    }
                    if (i > 0) {
                        pdVector.setEntry(--i, pdVector.getEntry(i) * Double.valueOf("1." + streamTokenizer.sval));
                        continue;
                    }
                    PsDebug.warning((String)("error at node " + (n14 + 1)));
                }
                if (n14 >= vector.size()) {
                    vector.setSize(n14 + 1);
                }
                vector.setElementAt(pdVector, n14);
            }
            if (vector.size() == 0) {
                return false;
            }
            int n16 = vector.size();
            pgJvxSrc.setDimOfVertices(n15);
            pgJvxSrc.setNumVertices(n16);
            n14 = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                pdVector = (PdVector)enumeration.nextElement();
                if (pdVector == null) {
                    pdVector = new PdVector(n15);
                    pdVector.setConstant(Double.NaN);
                }
                pgJvxSrc.setVertex(n14, pdVector);
                ++n14;
            }
        }
        return true;
    }
}

